/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.common.topics;

import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Int32Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.grpc.client.common.GrpcConnection;
import com.oracle.coherence.grpc.client.common.WrapperGrpcConnection;
import com.oracle.coherence.grpc.messages.topic.v1.TopicServiceRequest;
import com.oracle.coherence.grpc.messages.topic.v1.TopicServiceRequestType;
import com.oracle.coherence.grpc.messages.topic.v1.TopicServiceResponse;
import java.util.concurrent.CompletableFuture;

public class TopicServiceGrpcConnection
extends WrapperGrpcConnection {
    public TopicServiceGrpcConnection(GrpcConnection delegate) {
        super(delegate);
    }

    @Override
    public <T extends Message> T send(Message message) {
        if (!message.getClass().equals(TopicServiceRequest.class)) {
            throw new IllegalArgumentException("Message must be an instance of " + TopicServiceRequest.class.getName());
        }
        return super.send(message);
    }

    public TopicServiceResponse send(int nId, TopicServiceRequestType type, Message message) {
        TopicServiceRequest.Builder builder = TopicServiceRequest.newBuilder().setProxyId(nId).setType(type);
        if (message != null) {
            builder.setMessage(Any.pack((Message)message));
        } else {
            builder.setMessage(Any.pack((Message)Empty.getDefaultInstance()));
        }
        return (TopicServiceResponse)super.send((Message)builder.build());
    }

    public CompletableFuture<TopicServiceResponse> poll(int id, TopicServiceRequestType type) {
        return this.poll(id, type, null);
    }

    public CompletableFuture<TopicServiceResponse> poll(int id, TopicServiceRequestType type, Message message) {
        TopicServiceRequest.Builder builder = TopicServiceRequest.newBuilder().setProxyId(id).setType(type);
        if (message != null) {
            builder.setMessage(Any.pack((Message)message));
        } else {
            builder.setMessage(Any.pack((Message)Empty.getDefaultInstance()));
        }
        return this.f_delegate.poll((Message)builder.build());
    }

    public Int32Value unpackInteger(TopicServiceResponse response) {
        return this.unpackMessage(response, Int32Value.class);
    }

    public <M extends Message> M unpackMessage(TopicServiceResponse response, Class<M> type) {
        Any any = response.getMessage();
        try {
            return (M)any.unpack(type);
        }
        catch (InvalidProtocolBufferException e) {
            String sMsg = String.format("Failed to unpack protobuf message of type %s expected type %s uri=%s", response.getClass().getSimpleName(), type, any.getTypeUrl());
            throw Exceptions.ensureRuntimeException((Throwable)e, (String)sMsg);
        }
    }
}

