/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.common.v0;

import com.google.protobuf.BoolValue;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Empty;
import com.google.protobuf.Int32Value;
import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.grpc.client.common.AsyncNamedCacheClient;
import com.oracle.coherence.grpc.client.common.SingleValueStreamObserver;
import com.oracle.coherence.grpc.client.common.StreamStreamObserver;
import com.oracle.coherence.grpc.messages.cache.v0.AddIndexRequest;
import com.oracle.coherence.grpc.messages.cache.v0.AggregateRequest;
import com.oracle.coherence.grpc.messages.cache.v0.ClearRequest;
import com.oracle.coherence.grpc.messages.cache.v0.ContainsEntryRequest;
import com.oracle.coherence.grpc.messages.cache.v0.ContainsKeyRequest;
import com.oracle.coherence.grpc.messages.cache.v0.ContainsValueRequest;
import com.oracle.coherence.grpc.messages.cache.v0.DestroyRequest;
import com.oracle.coherence.grpc.messages.cache.v0.Entry;
import com.oracle.coherence.grpc.messages.cache.v0.EntryResult;
import com.oracle.coherence.grpc.messages.cache.v0.GetAllRequest;
import com.oracle.coherence.grpc.messages.cache.v0.GetRequest;
import com.oracle.coherence.grpc.messages.cache.v0.InvokeAllRequest;
import com.oracle.coherence.grpc.messages.cache.v0.InvokeRequest;
import com.oracle.coherence.grpc.messages.cache.v0.IsEmptyRequest;
import com.oracle.coherence.grpc.messages.cache.v0.IsReadyRequest;
import com.oracle.coherence.grpc.messages.cache.v0.MapListenerRequest;
import com.oracle.coherence.grpc.messages.cache.v0.MapListenerResponse;
import com.oracle.coherence.grpc.messages.cache.v0.OptionalValue;
import com.oracle.coherence.grpc.messages.cache.v0.PageRequest;
import com.oracle.coherence.grpc.messages.cache.v0.PutAllRequest;
import com.oracle.coherence.grpc.messages.cache.v0.PutIfAbsentRequest;
import com.oracle.coherence.grpc.messages.cache.v0.PutRequest;
import com.oracle.coherence.grpc.messages.cache.v0.RemoveIndexRequest;
import com.oracle.coherence.grpc.messages.cache.v0.RemoveMappingRequest;
import com.oracle.coherence.grpc.messages.cache.v0.RemoveRequest;
import com.oracle.coherence.grpc.messages.cache.v0.ReplaceMappingRequest;
import com.oracle.coherence.grpc.messages.cache.v0.ReplaceRequest;
import com.oracle.coherence.grpc.messages.cache.v0.SizeRequest;
import com.oracle.coherence.grpc.messages.cache.v0.TruncateRequest;
import com.oracle.coherence.grpc.messages.cache.v0.ValuesRequest;
import com.oracle.coherence.grpc.services.cache.v0.NamedCacheServiceGrpc;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public class NamedCacheGrpcClient {
    private final AsyncNamedCacheClient.Dependencies f_dependencies;

    public NamedCacheGrpcClient(AsyncNamedCacheClient.Dependencies dependencies) {
        this.f_dependencies = dependencies;
    }

    CompletionStage<Empty> clear(ClearRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStub().clear(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BoolValue> containsEntry(ContainsEntryRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStub().containsEntry(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BoolValue> containsKey(ContainsKeyRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStub().containsKey(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BoolValue> containsValue(ContainsValueRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStub().containsValue(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BoolValue> isEmpty(IsEmptyRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStub().isEmpty(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BoolValue> isReady(IsReadyRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStub().isReady(request, observer);
        return observer.completionStage();
    }

    CompletionStage<Int32Value> size(SizeRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStub().size(request, observer);
        return observer.completionStage();
    }

    CompletionStage<OptionalValue> get(GetRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStub().get(request, observer);
        return observer.completionStage();
    }

    Stream<Entry> getAll(GetAllRequest request) {
        try {
            StreamStreamObserver observer = new StreamStreamObserver();
            this.createStub().getAll(request, observer);
            return observer.future().get().stream();
        }
        catch (InterruptedException | ExecutionException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
    }

    CompletionStage<BytesValue> put(PutRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStub().put(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BytesValue> putIfAbsent(PutIfAbsentRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStub().putIfAbsent(request, observer);
        return observer.completionStage();
    }

    CompletionStage<Empty> putAll(PutAllRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStub().putAll(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BytesValue> remove(RemoveRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStub().remove(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BoolValue> removeMapping(RemoveMappingRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStub().removeMapping(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BytesValue> replace(ReplaceRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStub().replace(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BoolValue> replaceMapping(ReplaceMappingRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStub().replaceMapping(request, observer);
        return observer.completionStage();
    }

    Stream<BytesValue> nextKeySetPage(PageRequest request) {
        try {
            StreamStreamObserver observer = new StreamStreamObserver();
            this.createStub().nextKeySetPage(request, observer);
            return observer.future().get().stream();
        }
        catch (InterruptedException | ExecutionException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
    }

    Stream<EntryResult> nextEntrySetPage(PageRequest request) {
        try {
            StreamStreamObserver observer = new StreamStreamObserver();
            this.createStub().nextEntrySetPage(request, observer);
            return observer.future().get().stream();
        }
        catch (InterruptedException | ExecutionException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
    }

    CompletionStage<Empty> truncate(TruncateRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStub().truncate(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BytesValue> invoke(InvokeRequest request, long nDeadline) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStubWithDeadline(nDeadline).invoke(request, observer);
        return observer.completionStage();
    }

    void invokeAll(InvokeAllRequest request, StreamObserver<Entry> observer, long nDeadline) {
        this.createStubWithDeadline(nDeadline).invokeAll(request, observer);
    }

    CompletionStage<Empty> destroy(DestroyRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStub().destroy(request, observer);
        return observer.completionStage();
    }

    CompletionStage<Empty> addIndex(AddIndexRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStub().addIndex(request, observer);
        return observer.completionStage();
    }

    CompletionStage<Empty> removeIndex(RemoveIndexRequest request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStub().removeIndex(request, observer);
        return observer.completionStage();
    }

    CompletionStage<BytesValue> aggregate(AggregateRequest request, long nDeadline) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        this.createStubWithDeadline(nDeadline).aggregate(request, observer);
        return observer.completionStage();
    }

    Stream<BytesValue> values(ValuesRequest request) {
        try {
            StreamStreamObserver observer = new StreamStreamObserver();
            this.createStub().values(request, observer);
            return observer.future().get().stream();
        }
        catch (InterruptedException | ExecutionException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
    }

    StreamObserver<MapListenerRequest> events(StreamObserver<MapListenerResponse> observer) {
        return this.createStubWithoutDeadline().events(observer);
    }

    private NamedCacheServiceGrpc.NamedCacheServiceStub createStub() {
        long nDeadline = this.f_dependencies.getDeadline();
        return (NamedCacheServiceGrpc.NamedCacheServiceStub)this.createStubWithoutDeadline().withDeadlineAfter(nDeadline, TimeUnit.MILLISECONDS);
    }

    private NamedCacheServiceGrpc.NamedCacheServiceStub createStubWithDeadline(long nDeadline) {
        if (nDeadline == -1L) {
            return this.createStubWithoutDeadline();
        }
        if (nDeadline <= 0L) {
            return this.createStub();
        }
        return (NamedCacheServiceGrpc.NamedCacheServiceStub)this.createStubWithoutDeadline().withDeadlineAfter(nDeadline, TimeUnit.MILLISECONDS);
    }

    private NamedCacheServiceGrpc.NamedCacheServiceStub createStubWithoutDeadline() {
        Channel channel = this.f_dependencies.getChannel();
        return NamedCacheServiceGrpc.newStub((Channel)channel);
    }
}

