/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.common;

import com.google.protobuf.Message;
import com.oracle.coherence.common.base.Predicate;
import com.tangosol.internal.net.grpc.RemoteGrpcServiceDependencies;
import com.tangosol.io.Serializer;
import com.tangosol.util.UUID;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.util.EventListener;
import java.util.EventObject;
import java.util.concurrent.CompletableFuture;

public interface GrpcConnection {
    public Channel getChannel();

    public void connect();

    public boolean isConnected();

    public void close();

    public UUID getUUID();

    public String getProxyVersion();

    public int getProxyVersionEncoded();

    public int getProtocolVersion();

    public <T extends Message> T send(Message var1);

    public <T extends Message> CompletableFuture<T> poll(Message var1);

    public <T extends Message> void poll(Message var1, StreamObserver<T> var2);

    public <T extends Message> void addResponseObserver(Listener<T> var1);

    public <T extends Message> void removeResponseObserver(Listener<T> var1);

    public long getHeartbeatsSent();

    public long getLastHeartbeatTime();

    public long getHeartbeatsAcked();

    public void addConnectionListener(ConnectionListener var1);

    public void removeConnectionListener(ConnectionListener var1);

    public static class DefaultDependencies
    implements Dependencies {
        private final String f_sName;
        private final RemoteGrpcServiceDependencies f_deps;
        private final Channel f_channel;
        private final int f_nVersion;
        private final int f_nSupportedVersion;
        private final Serializer f_serializer;

        public DefaultDependencies(String sName, RemoteGrpcServiceDependencies deps, Channel channel, int nVersion, int nSupportedVersion, Serializer serializer) {
            this.f_sName = sName;
            this.f_deps = deps;
            this.f_channel = channel;
            this.f_nVersion = nVersion;
            this.f_nSupportedVersion = nSupportedVersion;
            this.f_serializer = serializer;
        }

        @Override
        public String getProtocolName() {
            return this.f_sName;
        }

        @Override
        public int getVersion() {
            return this.f_nVersion;
        }

        @Override
        public int getSupportedVersion() {
            return this.f_nSupportedVersion;
        }

        @Override
        public Channel getChannel() {
            return this.f_channel;
        }

        @Override
        public RemoteGrpcServiceDependencies getServiceDependencies() {
            return this.f_deps;
        }

        @Override
        public Serializer getSerializer() {
            return this.f_serializer;
        }
    }

    public static interface Dependencies {
        public String getProtocolName();

        public int getVersion();

        public int getSupportedVersion();

        public Channel getChannel();

        public RemoteGrpcServiceDependencies getServiceDependencies();

        public Serializer getSerializer();
    }

    public static class ConnectionEvent
    extends EventObject {
        private final Type f_type;

        public ConnectionEvent(GrpcConnection source, Type type) {
            super(source);
            this.f_type = type;
        }

        public Type getType() {
            return this.f_type;
        }

        public static enum Type {
            Connected,
            Disconnected;

        }
    }

    public static interface ConnectionListener
    extends EventListener {
        default public void onConnectionEvent(ConnectionEvent event) {
        }
    }

    public record Listener<T extends Message>(StreamObserver<T> observer, Predicate<T> predicate) {
    }
}

