/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.common;

import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.UnsafeByteOperations;
import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.grpc.client.common.BaseGrpcClient;
import com.oracle.coherence.grpc.client.common.ClientProtocol;
import com.oracle.coherence.grpc.client.common.GrpcConnection;
import com.tangosol.io.NamedSerializerFactory;
import com.tangosol.io.Serializer;
import com.tangosol.util.ExternalizableHelper;
import java.nio.ByteBuffer;

public abstract class BaseClientChannel<DepsType extends BaseGrpcClient.Dependencies, Con extends GrpcConnection>
implements ClientProtocol {
    protected static final Void VOID = null;
    protected final Con f_connection;
    protected final DepsType f_dependencies;
    protected final Serializer f_serializer;
    protected final String f_sFormat;
    protected final String f_sScopeName;

    protected BaseClientChannel(DepsType dependencies, Con connection) {
        this.f_dependencies = dependencies;
        this.f_connection = connection;
        this.f_sScopeName = dependencies.getScopeName().orElse("");
        this.f_sFormat = dependencies.getSerializerFormat().orElseGet(() -> dependencies.getSerializer().map(Serializer::getName).orElseGet(BaseGrpcClient::getDefaultSerializerFormat));
        this.f_serializer = dependencies.getSerializer().orElseGet(() -> BaseClientChannel.createSerializer(this.f_sFormat));
    }

    @Override
    public void close() {
        this.f_connection.close();
    }

    @Override
    public int getVersion() {
        return this.f_connection.getProtocolVersion();
    }

    @Override
    public boolean isActive() {
        return this.f_connection.isConnected();
    }

    @Override
    public GrpcConnection getConnection() {
        return this.f_connection;
    }

    public DepsType getDependencies() {
        return this.f_dependencies;
    }

    public BytesValue toBytesValue(Object obj) {
        return BytesValue.of((ByteString)this.toByteString(obj));
    }

    public ByteString toByteStringOrNull(Object obj) {
        return obj == null ? null : this.toByteString(obj);
    }

    public ByteString toByteString(Object obj) {
        return UnsafeByteOperations.unsafeWrap((ByteBuffer)ExternalizableHelper.toBinary((Object)obj, (Serializer)this.f_serializer).toByteBuffer());
    }

    protected static Serializer createSerializer(String sFormat) {
        return NamedSerializerFactory.DEFAULT.getNamedSerializer(sFormat, Classes.getContextClassLoader());
    }
}

