/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.common;

import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Empty;
import com.google.protobuf.Int32Value;
import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.grpc.MaybeByteString;
import com.oracle.coherence.grpc.client.common.BaseGrpcClient;
import com.oracle.coherence.grpc.client.common.DeactivationListener;
import com.oracle.coherence.grpc.client.common.GrpcCacheLifecycleEventDispatcher;
import com.oracle.coherence.grpc.client.common.GrpcRemoteCacheService;
import com.oracle.coherence.grpc.client.common.NamedCacheClient;
import com.oracle.coherence.grpc.client.common.NamedCacheClientChannel;
import com.oracle.coherence.grpc.client.common.RemoteEntrySet;
import com.oracle.coherence.grpc.client.common.RemoteKeySet;
import com.oracle.coherence.grpc.client.common.RemoteValues;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedMap;
import com.tangosol.net.PriorityTask;
import com.tangosol.net.RequestIncompleteException;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.util.Base;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MapTriggerListener;
import com.tangosol.util.PagedIterator;
import com.tangosol.util.SparseArray;
import com.tangosol.util.SynchronousListener;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.AlwaysFilter;
import io.grpc.Channel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AsyncNamedCacheClient<K, V>
extends BaseGrpcClient<V, NamedCacheClientChannel>
implements AsyncNamedCache<K, V>,
NamedCacheClientChannel.EventDispatcher {
    protected static final Void VOID = null;
    private final NamedCacheClient<K, V> f_synchronousCache;
    private final List<DeactivationListener<AsyncNamedCacheClient<? super K, ? super V>>> f_listDeactivationListeners;
    private final List<NamedCacheDeactivationListener> f_listCacheDeactivationListeners = new ArrayList<NamedCacheDeactivationListener>();
    private final Lock f_lockDeactivationListeners = new ReentrantLock();
    private final Lock f_lock = new ReentrantLock();
    private final MapListenerSupport m_listenerSupport;
    private final LongArray<Filter<?>> m_aEvtFilter;
    protected final AtomicInteger f_cListener = new AtomicInteger(0);
    private GrpcRemoteCacheService m_cacheService;

    public AsyncNamedCacheClient(Dependencies dependencies, NamedCacheClientChannel client) {
        super(dependencies, client);
        this.f_synchronousCache = new NamedCacheClient(this);
        this.f_listDeactivationListeners = new ArrayList<DeactivationListener<AsyncNamedCacheClient<? super K, ? super V>>>();
        this.m_listenerSupport = new MapListenerSupport();
        this.m_aEvtFilter = new SparseArray();
        client.setEventDispatcher(this);
    }

    public NamedCache<K, V> getNamedCache() {
        return this.getNamedCacheClient();
    }

    public NamedMap<K, V> getNamedMap() {
        return this.getNamedCacheClient();
    }

    public <R> CompletableFuture<R> aggregate(Collection<? extends K> colKeys, InvocableMap.EntryAggregator<? super K, ? super V, R> entryAggregator) {
        return this.executeIfActive(() -> {
            try {
                List<ByteString> keys = colKeys.stream().map(this::toKeyByteString).collect(Collectors.toList());
                long nDeadline = 0L;
                if (entryAggregator instanceof PriorityTask) {
                    nDeadline = ((PriorityTask)entryAggregator).getRequestTimeoutMillis();
                }
                return ((NamedCacheClientChannel)this.f_client).aggregate(keys, this.toByteString(entryAggregator), nDeadline).thenApply(this::fromBytesValue);
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<R> aggregate(Filter<?> filter, InvocableMap.EntryAggregator<? super K, ? super V, R> entryAggregator) {
        return this.executeIfActive(() -> {
            try {
                long nDeadline = 0L;
                if (entryAggregator instanceof PriorityTask) {
                    nDeadline = ((PriorityTask)entryAggregator).getRequestTimeoutMillis();
                }
                return ((NamedCacheClientChannel)this.f_client).aggregate(this.toByteString(filter), this.toByteString(entryAggregator), nDeadline).thenApply(this::fromBytesValue);
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<R> invoke(K k, InvocableMap.EntryProcessor<K, V, R> entryProcessor) {
        return this.executeIfActive(() -> {
            try {
                long nDeadline = 0L;
                if (entryProcessor instanceof PriorityTask) {
                    nDeadline = ((PriorityTask)entryProcessor).getRequestTimeoutMillis();
                }
                return ((NamedCacheClientChannel)this.f_client).invoke(this.toKeyByteString(k), this.toByteString(entryProcessor), nDeadline).thenApplyAsync(this::valueFromBytesValue).thenApply(r -> r).toCompletableFuture();
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<Map<K, R>> invokeAll(Collection<? extends K> colKeys, InvocableMap.EntryProcessor<K, V, R> processor) {
        return this.executeIfActive(() -> {
            try {
                long nDeadline = 0L;
                if (processor instanceof PriorityTask) {
                    nDeadline = ((PriorityTask)processor).getRequestTimeoutMillis();
                }
                Collection serializedKeys = colKeys.stream().map(this::toKeyByteString).collect(Collectors.toList());
                return ((NamedCacheClientChannel)this.f_client).invokeAll((Collection<ByteString>)serializedKeys, this.toByteString(processor), nDeadline).thenApply(this::toMap);
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<Map<K, R>> invokeAll(Filter<?> filter, InvocableMap.EntryProcessor<K, V, R> processor) {
        return this.executeIfActive(() -> {
            try {
                return ((NamedCacheClientChannel)this.f_client).invokeAll(this.toByteString(filter), this.toByteString(processor)).thenApply(this::toMap);
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<Void> invokeAll(Collection<? extends K> colKeys, InvocableMap.EntryProcessor<K, V, R> processor, Consumer<? super Map.Entry<? extends K, ? extends R>> callback) {
        return this.executeIfActive(() -> {
            try {
                Collection serializedKeys = colKeys.stream().map(this::toKeyByteString).collect(Collectors.toList());
                Consumer<Map.Entry<ByteString, ByteString>> consumer = entry -> callback.accept(this.toMapEntry((Map.Entry<ByteString, ByteString>)entry));
                return ((NamedCacheClientChannel)this.f_client).invokeAll((Collection<ByteString>)serializedKeys, this.toByteString(processor), consumer);
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<Void> invokeAll(Filter<?> filter, InvocableMap.EntryProcessor<K, V, R> processor, Consumer<? super Map.Entry<? extends K, ? extends R>> callback) {
        return this.executeIfActive(() -> {
            try {
                Consumer<Map.Entry<ByteString, ByteString>> consumer = entry -> callback.accept(this.toMapEntry((Map.Entry<ByteString, ByteString>)entry));
                return ((NamedCacheClientChannel)this.f_client).invokeAll(this.toByteString(filter), this.toByteString(processor), consumer);
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public CompletableFuture<Void> clear() {
        return this.executeIfActive(() -> {
            try {
                return ((NamedCacheClientChannel)this.f_client).clear();
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        return this.executeIfActive(() -> this.containsKeyInternal(key));
    }

    public CompletableFuture<Set<Map.Entry<K, V>>> entrySet() {
        return this.executeIfActive(() -> CompletableFuture.completedFuture(new RemoteEntrySet(this)));
    }

    public CompletableFuture<Set<Map.Entry<K, V>>> entrySet(Filter<?> filter) {
        return this.executeIfActive(() -> {
            try {
                return ((NamedCacheClientChannel)this.f_client).entrySet(this.toByteString(filter)).thenApply(map -> this.toMap((Map<ByteString, ByteString>)map).entrySet());
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public CompletableFuture<Set<Map.Entry<K, V>>> entrySet(Filter<?> filter, Comparator<?> comparator) {
        return this.executeIfActive(() -> {
            try {
                return ((NamedCacheClientChannel)this.f_client).entrySet(this.toByteString(filter), this.toByteString(comparator)).thenApply(map -> this.toMap((Map<ByteString, ByteString>)map).entrySet());
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public CompletableFuture<V> get(K key) {
        return this.executeIfActive(() -> this.getInternal(key, null));
    }

    public CompletableFuture<Map<K, V>> getAll(Collection<? extends K> colKeys) {
        return this.executeIfActive(() -> {
            if (colKeys.isEmpty()) {
                return CompletableFuture.completedFuture(new HashMap());
            }
            return CompletableFuture.supplyAsync(() -> this.getAllInternalAsMap(colKeys));
        });
    }

    public CompletableFuture<V> getOrDefault(K key, V defaultValue) {
        return this.executeIfActive(() -> this.getInternal(key, defaultValue));
    }

    public <R> CompletableFuture<Map<K, R>> invokeAll(InvocableMap.EntryProcessor<K, V, R> processor) {
        return this.executeIfActive(() -> {
            try {
                return ((NamedCacheClientChannel)this.f_client).invokeAll(this.toByteString(AlwaysFilter.INSTANCE()), this.toByteString(processor)).thenApply(this::toMap);
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<Void> invokeAll(InvocableMap.EntryProcessor<K, V, R> processor, Consumer<? super Map.Entry<? extends K, ? extends R>> callback) {
        return this.executeIfActive(() -> {
            try {
                Consumer<Map.Entry<ByteString, ByteString>> consumer = e -> callback.accept(this.toMapEntry((Map.Entry<ByteString, ByteString>)e));
                return ((NamedCacheClientChannel)this.f_client).invokeAll(this.toByteString(AlwaysFilter.INSTANCE()), this.toByteString(processor), consumer);
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<Void> invokeAll(InvocableMap.EntryProcessor<K, V, R> processor, BiConsumer<? super K, ? super R> callback) {
        return this.executeIfActive(() -> {
            try {
                return ((NamedCacheClientChannel)this.f_client).invokeAll(this.toByteString(AlwaysFilter.INSTANCE()), this.toByteString(processor), (ByteString k, ByteString v) -> callback.accept((K)this.fromByteString((ByteString)k), (Object)this.fromByteString((ByteString)v)));
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<Void> invokeAll(Collection<? extends K> colKeys, InvocableMap.EntryProcessor<K, V, R> processor, BiConsumer<? super K, ? super R> callback) {
        return this.executeIfActive(() -> {
            try {
                Collection keys = colKeys.stream().map(this::toKeyByteString).collect(Collectors.toList());
                return ((NamedCacheClientChannel)this.f_client).invokeAll((Collection<ByteString>)keys, this.toByteString(processor), (ByteString k, ByteString v) -> callback.accept((K)this.fromByteString((ByteString)k), (Object)this.fromByteString((ByteString)v)));
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<Void> invokeAll(Filter<?> filter, InvocableMap.EntryProcessor<K, V, R> processor, BiConsumer<? super K, ? super R> callback) {
        return this.executeIfActive(() -> {
            try {
                return ((NamedCacheClientChannel)this.f_client).invokeAll(this.toByteString(filter), this.toByteString(processor), (ByteString k, ByteString v) -> callback.accept((K)this.fromByteString((ByteString)k), (Object)this.fromByteString((ByteString)v)));
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.executeIfActive(() -> ((NamedCacheClientChannel)this.f_client).isEmpty().thenApply(BoolValue::getValue).toCompletableFuture());
    }

    public CompletableFuture<Set<K>> keySet() {
        return this.executeIfActive(() -> CompletableFuture.completedFuture(new RemoteKeySet(this)));
    }

    public CompletableFuture<Void> put(K key, V value) {
        return this.putInternal(key, value, 0L).thenApply(v -> VOID);
    }

    public CompletableFuture<Void> put(K key, V value, long ttl) {
        return this.putInternal(key, value, ttl).thenApply(v -> VOID);
    }

    public CompletableFuture<V> putIfAbsent(K key, V value) {
        return this.executeIfActive(() -> ((NamedCacheClientChannel)this.f_client).putIfAbsent(this.toKeyByteString(key), this.toByteString(value)).thenApplyAsync(this::valueFromBytesValue).toCompletableFuture());
    }

    public CompletableFuture<Void> putAll(Map<? extends K, ? extends V> map) {
        return this.putAllInternal(map, 0L).thenApply(v -> VOID);
    }

    public CompletableFuture<Void> putAll(Map<? extends K, ? extends V> map, long cMillis) {
        return this.putAllInternal(map, cMillis).thenApply(v -> VOID);
    }

    public CompletableFuture<V> remove(K key) {
        return this.removeInternal(key);
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        return this.removeInternal(key, value);
    }

    public CompletableFuture<V> replace(K key, V value) {
        return this.executeIfActive(() -> ((NamedCacheClientChannel)this.f_client).replace(this.toKeyByteString(key), this.toByteString(value)).thenApplyAsync(this::valueFromBytesValue).toCompletableFuture());
    }

    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return this.executeIfActive(() -> ((NamedCacheClientChannel)this.f_client).replaceMapping(this.toKeyByteString(key), this.toByteString(oldValue), this.toByteString(newValue)).thenApplyAsync(BoolValue::getValue).toCompletableFuture());
    }

    public CompletableFuture<Integer> size() {
        return this.executeIfActive(() -> ((NamedCacheClientChannel)this.f_client).size().thenApply(Int32Value::getValue).toCompletableFuture());
    }

    public CompletableFuture<Collection<V>> values() {
        return this.executeIfActive(() -> CompletableFuture.completedFuture(new RemoteValues(this)));
    }

    public CompletableFuture<Collection<V>> values(Filter<?> filter, Comparator<? super V> comparator) {
        return this.executeIfActive(() -> this.valuesInternal(filter, comparator));
    }

    public CompletableFuture<Boolean> containsKeyInternal(Object oKey) {
        return this.executeIfActive(() -> ((NamedCacheClientChannel)this.f_client).containsKey(this.toKeyByteString(oKey)).thenApplyAsync(BoolValue::getValue).toCompletableFuture());
    }

    public PagedIterator.Advancer createEntryAdvancer() {
        return new EntryAdvancer(this);
    }

    public Map<K, V> getAllInternalAsMap(Collection<? extends K> colKeys) {
        this.assertActive();
        if (colKeys.isEmpty()) {
            return Map.of();
        }
        return ((NamedCacheClientChannel)this.f_client).getAll((Iterable<ByteString>)ConverterCollections.getCollection(colKeys, this::toByteString, this::fromByteString)).collect(Collectors.toMap(e -> this.fromByteString((ByteString)e.getKey()), e -> this.fromByteString((ByteString)e.getValue())));
    }

    public CompletableFuture<V> getInternal(Object key, V defaultValue) {
        return ((NamedCacheClientChannel)this.f_client).get(this.toKeyByteString(key)).thenApply(o -> this.fromByteString((MaybeByteString)o, defaultValue)).toCompletableFuture();
    }

    public String getScopeName() {
        return this.f_sScopeName;
    }

    protected String getFormat() {
        return this.f_sFormat;
    }

    public String getCacheName() {
        return this.f_sName;
    }

    public CacheService getCacheService() {
        return this.m_cacheService;
    }

    public void setCacheService(GrpcRemoteCacheService cacheService) {
        this.m_cacheService = cacheService;
    }

    public NamedCacheClient<K, V> getNamedCacheClient() {
        return this.f_synchronousCache;
    }

    public CompletableFuture<Boolean> isActive() {
        return CompletableFuture.completedFuture(this.isActiveInternal());
    }

    public CompletableFuture<Boolean> isReady() {
        if (this.isActiveInternal()) {
            return this.executeIfActive(() -> ((NamedCacheClientChannel)this.f_client).isReady().thenApply(BoolValue::getValue).toCompletableFuture());
        }
        return CompletableFuture.completedFuture(false);
    }

    public CompletableFuture<V> putInternal(K key, V value, long cTtl) {
        return this.executeIfActive(() -> ((NamedCacheClientChannel)this.f_client).put(this.toKeyByteString(key), this.toByteString(value), cTtl).thenApplyAsync(this::valueFromBytesValue).toCompletableFuture());
    }

    protected CompletableFuture<Empty> putAllInternal(Map<? extends K, ? extends V> map, long cMillis) {
        return this.executeIfActive(() -> {
            try {
                HashMap<ByteString, ByteString> mapBinary = new HashMap<ByteString, ByteString>();
                for (Map.Entry entry : map.entrySet()) {
                    mapBinary.put(this.toKeyByteString(entry.getKey()), this.toByteString(entry.getValue()));
                }
                return ((NamedCacheClientChannel)this.f_client).putAll(mapBinary, cMillis);
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public CompletableFuture<Void> release() {
        return this.executeIfActive(() -> this.releaseInternal(false));
    }

    public <T, E> CompletableFuture<Void> removeIndex(ValueExtractor<? super T, ? extends E> valueExtractor) {
        return ((NamedCacheClientChannel)this.f_client).removeIndex(this.toByteString(valueExtractor)).thenApply(e -> VOID).toCompletableFuture();
    }

    public CompletableFuture<V> removeInternal(Object key) {
        return this.executeIfActive(() -> ((NamedCacheClientChannel)this.f_client).remove(this.toKeyByteString(key)).thenApplyAsync(this::valueFromBytesValue).toCompletableFuture());
    }

    public CompletableFuture<Boolean> removeInternal(Object key, Object value) {
        return this.executeIfActive(() -> ((NamedCacheClientChannel)this.f_client).remove(this.toKeyByteString(key), this.toByteString(value)).thenApplyAsync(BoolValue::getValue).toCompletableFuture());
    }

    public CompletableFuture<Void> removeMapListener(MapListener<? super K, ? super V> mapListener) {
        return this.removeMapListener(mapListener, (Filter)null);
    }

    public CompletableFuture<Void> removeMapListener(MapListener<? super K, ? super V> listener, K key) {
        return this.executeIfActive(() -> {
            MapListenerSupport support;
            MapListenerSupport mapListenerSupport = support = this.getMapListenerSupport();
            synchronized (mapListenerSupport) {
                support.removeListener(listener, key);
                boolean fEmpty = support.isEmpty(key);
                boolean fPriming = MapListenerSupport.isPrimingListener((MapListener)listener);
                if (fEmpty || fPriming) {
                    return ((NamedCacheClientChannel)this.f_client).removeMapListener(this.toKeyByteString(key), fPriming);
                }
                return CompletableFuture.completedFuture(VOID);
            }
        });
    }

    public CompletableFuture<Void> removeMapListener(MapListener<? super K, ? super V> listener, Filter<?> filter) {
        return this.executeIfActive(() -> {
            MapListenerSupport support;
            if (listener instanceof NamedCacheDeactivationListener && filter == null) {
                this.f_lockDeactivationListeners.lock();
                try {
                    if (this.f_listCacheDeactivationListeners.remove(listener)) {
                        this.f_cListener.decrementAndGet();
                    }
                }
                finally {
                    this.f_lockDeactivationListeners.unlock();
                }
                return CompletableFuture.completedFuture(VOID);
            }
            if (listener instanceof MapTriggerListener) {
                MapTriggerListener triggerListener = (MapTriggerListener)listener;
                return ((NamedCacheClientChannel)this.f_client).removeMapListener(ByteString.EMPTY, 0L, this.toByteString(triggerListener.getTrigger()));
            }
            MapListenerSupport mapListenerSupport = support = this.getMapListenerSupport();
            synchronized (mapListenerSupport) {
                long nId = this.getFilterId(filter);
                support.removeListener(listener, filter);
                if (support.isEmpty(filter)) {
                    return ((NamedCacheClientChannel)this.f_client).removeMapListener(this.toByteString(filter), nId, ByteString.EMPTY);
                }
            }
            return CompletableFuture.completedFuture(VOID);
        });
    }

    protected Stream<InvocableMap.Entry<K, V>> stream() {
        this.assertActive();
        return this.stream((Filter<V>)AlwaysFilter.INSTANCE());
    }

    public Stream<InvocableMap.Entry<K, V>> stream(Filter<V> filter) {
        this.assertActive();
        throw new UnsupportedOperationException("method not implemented");
    }

    public CompletableFuture<Void> truncate() {
        return this.executeIfActive(() -> ((NamedCacheClientChannel)this.f_client).truncate().thenApply(e -> VOID).toCompletableFuture());
    }

    public CompletableFuture<Collection<V>> valuesInternal(Filter<?> filter, Comparator comparator) {
        return this.values(filter).thenApply(colValues -> {
            ArrayList values = new ArrayList(colValues);
            values.sort(comparator);
            return values;
        });
    }

    public CompletableFuture<Boolean> containsValue(Object oValue) {
        return this.executeIfActive(() -> ((NamedCacheClientChannel)this.f_client).containsValue(this.toByteString(oValue)).thenApplyAsync(BoolValue::getValue).toCompletableFuture());
    }

    public CompletableFuture<Void> destroy() {
        return this.executeIfActive(() -> this.releaseInternal(true));
    }

    protected MapListenerSupport getMapListenerSupport() {
        return this.m_listenerSupport;
    }

    public Stream<BytesValue> getKeysPage(BytesValue cookie) {
        this.assertActive();
        ByteString s = cookie == null ? null : cookie.getValue();
        return ((NamedCacheClientChannel)this.f_client).getKeysPage(s);
    }

    public boolean containsEntry(K key, V value) {
        this.assertActive();
        try {
            BoolValue boolValue = ((NamedCacheClientChannel)this.f_client).containsEntry(this.toKeyByteString(key), this.toByteString(value)).toCompletableFuture().get();
            return boolValue != null && boolValue.getValue();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public void assertActive() {
        if (this.m_fReleased || this.m_fDestroyed) {
            String reason = this.m_fDestroyed ? "destroyed" : "released";
            throw new IllegalStateException("remote cache '" + this.f_sName + "' has been " + reason);
        }
    }

    protected <T> CompletableFuture<T> executeIfActive(Supplier<CompletableFuture<T>> supplier) {
        if (!this.m_fReleased && !this.m_fDestroyed) {
            try {
                return supplier.get().handle(AsyncNamedCacheClient::handleException);
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        }
        String reason = this.m_fDestroyed ? "destroyed" : "released";
        return this.failedFuture(new IllegalStateException("remote cache '" + this.f_sName + "' has been " + reason));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> releaseInternal(boolean destroy) {
        this.f_lock.lock();
        try {
            CompletableFuture<Void> future;
            this.f_cListener.set(0);
            if (!this.m_fDestroyed && !this.m_fReleased) {
                if (destroy) {
                    this.m_fDestroyed = true;
                    future = ((NamedCacheClientChannel)this.f_client).destroy();
                } else {
                    this.m_fReleased = true;
                    future = CompletableFuture.completedFuture(VOID);
                }
            } else {
                future = CompletableFuture.completedFuture(VOID);
            }
            this.getMapListenerSupport().clear();
            CompletionStage completionStage = future.handleAsync((v, err) -> {
                for (DeactivationListener<AsyncNamedCacheClient<K, V>> listener : this.f_listDeactivationListeners) {
                    try {
                        if (destroy) {
                            listener.destroyed(this);
                            continue;
                        }
                        listener.released(this);
                    }
                    catch (Throwable t) {
                        Logger.err((Throwable)t);
                    }
                }
                this.f_listDeactivationListeners.clear();
                CacheEvent evt = this.createDeactivationEvent(true);
                for (NamedCacheDeactivationListener listener : this.f_listCacheDeactivationListeners) {
                    try {
                        listener.entryDeleted(evt);
                    }
                    catch (Throwable t) {
                        Logger.err((Throwable)t);
                    }
                }
                this.f_listCacheDeactivationListeners.clear();
                if (err != null) {
                    throw Base.ensureRuntimeException((Throwable)err);
                }
                return VOID;
            });
            return completionStage;
        }
        finally {
            this.f_lock.unlock();
        }
    }

    protected <Ke, Ve> CacheEvent<Ke, Ve> createDeactivationEvent(boolean destroyed) {
        return new CacheEvent(this.getNamedCache(), destroyed ? 3 : 2, null, null, null, true);
    }

    public void addDeactivationListener(DeactivationListener<AsyncNamedCacheClient<? super K, ? super V>> listener) {
        this.assertActive();
        this.f_lockDeactivationListeners.lock();
        try {
            if (listener != null) {
                this.f_listDeactivationListeners.add(listener);
            }
        }
        finally {
            this.f_lockDeactivationListeners.unlock();
        }
    }

    public void addDeactivationListener(NamedCacheDeactivationListener listener) {
        if (listener != null) {
            if (this.m_fReleased || this.m_fDestroyed) {
                listener.entryDeleted(this.createDeactivationEvent(this.m_fDestroyed));
            } else {
                this.f_lockDeactivationListeners.lock();
                try {
                    this.f_listCacheDeactivationListeners.add(listener);
                }
                finally {
                    this.f_lockDeactivationListeners.unlock();
                }
            }
        }
    }

    public void removeDeactivationListener(DeactivationListener<AsyncNamedCacheClient<? super K, ? super V>> listener) {
        if (listener != null) {
            this.f_lockDeactivationListeners.lock();
            try {
                this.f_listDeactivationListeners.remove(listener);
            }
            finally {
                this.f_lockDeactivationListeners.unlock();
            }
        }
    }

    protected List<NamedCacheDeactivationListener> getDeactivationListeners() {
        return Collections.unmodifiableList(this.f_listCacheDeactivationListeners);
    }

    public <T, E> CompletableFuture<Void> addIndex(ValueExtractor<? super T, ? extends E> extractor, boolean fOrdered, Comparator<? super E> comparator) {
        return this.executeIfActive(() -> ((NamedCacheClientChannel)this.f_client).addIndex(this.toByteString(extractor), fOrdered, this.toByteStringOrNull(comparator)));
    }

    public CompletableFuture<Void> addMapListener(MapListener<? super K, ? super V> mapListener) {
        return this.addMapListener(mapListener, (Filter)null, false);
    }

    public CompletableFuture<Void> addMapListener(MapListener<? super K, ? super V> mapListener, K key, boolean fLite) {
        return this.executeIfActive(() -> {
            try {
                return this.addKeyMapListener(mapListener, key, fLite);
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(e);
            }
        });
    }

    public CompletableFuture<Void> addMapListener(MapListener<? super K, ? super V> mapListener, Filter<?> filter, boolean fLite) {
        return this.executeIfActive(() -> {
            try {
                return this.addFilterMapListener(mapListener, filter, fLite);
            }
            catch (Exception e) {
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(e);
                return future;
            }
        });
    }

    protected CompletableFuture<Void> addKeyMapListener(MapListener<? super K, ? super V> listener, Object key, boolean fLite) {
        MapListenerSupport support = this.getMapListenerSupport();
        boolean fShouldAdd = support.addListenerWithCheck(listener, key, fLite);
        boolean fPriming = MapListenerSupport.isPrimingListener(listener);
        boolean fSynchronous = listener.isSynchronous();
        if (fShouldAdd || fPriming) {
            return ((NamedCacheClientChannel)this.f_client).addMapListener(this.toKeyByteString(key), fLite, fPriming, fSynchronous).handle((ignored, err) -> {
                if (err != null) {
                    MapListenerSupport mapListenerSupport = support;
                    synchronized (mapListenerSupport) {
                        support.removeListener(listener, key);
                    }
                }
                return VOID;
            });
        }
        return CompletableFuture.completedFuture(VOID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> addFilterMapListener(MapListener<? super K, ? super V> listener, Filter<?> filter, boolean fLite) {
        CompletableFuture<Void> future;
        long filterId;
        boolean first;
        boolean wasEmpty;
        MapListenerSupport support;
        boolean fSynchronous = listener.isSynchronous();
        if (listener instanceof NamedCacheDeactivationListener) {
            this.f_lockDeactivationListeners.lock();
            try {
                this.f_listCacheDeactivationListeners.add((NamedCacheDeactivationListener)listener);
                this.f_cListener.incrementAndGet();
            }
            finally {
                this.f_lockDeactivationListeners.unlock();
            }
            return CompletableFuture.completedFuture(VOID);
        }
        if (listener instanceof MapTriggerListener) {
            MapTriggerListener triggerListener = (MapTriggerListener)listener;
            return ((NamedCacheClientChannel)this.f_client).addMapListener(ByteString.EMPTY, 0L, fLite, this.toByteString(triggerListener.getTrigger()), fSynchronous);
        }
        MapListenerSupport mapListenerSupport = support = this.getMapListenerSupport();
        synchronized (mapListenerSupport) {
            wasEmpty = support.isEmpty(filter);
            first = support.addListenerWithCheck(listener, filter, fLite);
            filterId = wasEmpty ? this.registerFilter(filter) : this.getFilterId(filter);
        }
        if (wasEmpty || first) {
            future = ((NamedCacheClientChannel)this.f_client).addMapListener(this.toByteString(filter), filterId, fLite, ByteString.EMPTY, fSynchronous);
            if (future.isCompletedExceptionally()) {
                mapListenerSupport = support;
                synchronized (mapListenerSupport) {
                    if (wasEmpty) {
                        this.m_aEvtFilter.remove(filterId);
                    }
                    support.removeListener(listener, filter);
                }
            }
        } else {
            future = CompletableFuture.completedFuture(VOID);
        }
        return future;
    }

    protected long registerFilter(Filter<?> filter) {
        if (this.m_aEvtFilter.isEmpty()) {
            this.m_aEvtFilter.set(1L, filter);
            return 1L;
        }
        return this.m_aEvtFilter.add(filter);
    }

    protected long getFilterId(Filter<?> filter) {
        LongArray.Iterator iter = this.m_aEvtFilter.iterator();
        while (iter.hasNext()) {
            Filter filterThat = (Filter)iter.next();
            if (!Base.equals(filter, (Object)filterThat)) continue;
            return iter.getIndex();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(List<Long> listFilterIds, int nEventId, ByteString binKey, ByteString binOldValue, ByteString binNewValue, boolean fSynthetic, boolean fPriming, CacheEvent.TransformationState transformState) {
        Listeners listeners;
        int cFilters = listFilterIds == null ? 0 : listFilterIds.size();
        Object oKey = this.fromByteString(binKey);
        Object oValueOld = this.fromByteString(binOldValue);
        Object oValueNew = this.fromByteString(binNewValue);
        MapListenerSupport support = this.getMapListenerSupport();
        CacheEvent evt = null;
        Listeners listeners2 = listeners = transformState == CacheEvent.TransformationState.TRANSFORMED ? null : support.getListeners(oKey);
        if (cFilters > 0) {
            LongArray<Filter<?>> laFilters = this.m_aEvtFilter;
            ArrayList<Filter> listFilters = null;
            MapListenerSupport mapListenerSupport = support;
            synchronized (mapListenerSupport) {
                for (int i = 0; i < cFilters; ++i) {
                    long lFilterId = listFilterIds.get(i);
                    if (!laFilters.exists(lFilterId)) continue;
                    Filter filter = (Filter)laFilters.get(lFilterId);
                    if (listFilters == null) {
                        listFilters = new ArrayList<Filter>(cFilters - i);
                        Listeners listenersTemp = new Listeners();
                        listenersTemp.addAll(listeners);
                        listeners = listenersTemp;
                    }
                    listFilters.add(filter);
                    listeners.addAll(support.getListeners(filter));
                }
            }
            if (listFilters != null) {
                Filter[] aFilters = new Filter[listFilters.size()];
                aFilters = listFilters.toArray(aFilters);
                evt = new MapListenerSupport.FilterEvent(this.getNamedMap(), nEventId, oKey, oValueOld, oValueNew, fSynthetic, transformState, fPriming, aFilters);
            }
        }
        if (listeners != null && !listeners.isEmpty()) {
            if (evt == null) {
                evt = new CacheEvent(this.getNamedMap(), nEventId, oKey, oValueOld, oValueNew, fSynthetic, transformState, fPriming);
            }
            for (EventListener listener : listeners.listeners()) {
                EventTask task = new EventTask(evt, (MapListener)listener);
                if (listener instanceof SynchronousListener) {
                    task.run();
                    continue;
                }
                this.f_executor.execute(task);
            }
        }
    }

    @Override
    public void onDestroy() {
        if (this.isActiveInternal()) {
            this.m_fDestroyed = true;
            this.releaseInternal(true);
        }
        this.f_cListener.set(0);
    }

    @Override
    public void onTruncate() {
        CacheEvent evt = this.createDeactivationEvent(false);
        for (NamedCacheDeactivationListener listener : this.getDeactivationListeners()) {
            try {
                listener.entryUpdated(evt);
            }
            catch (Throwable t) {
                Logger.err((Throwable)t);
            }
        }
    }

    @Override
    public void incrementListeners() {
        this.f_cListener.incrementAndGet();
    }

    @Override
    public void decrementListeners() {
        this.f_cListener.decrementAndGet();
    }

    public int getListenerCount() {
        return this.f_cListener.get();
    }

    public GrpcCacheLifecycleEventDispatcher getEventDispatcher() {
        return (GrpcCacheLifecycleEventDispatcher)this.f_dispatcher;
    }

    protected Dependencies getDependencies() {
        return (Dependencies)this.f_dependencies;
    }

    public String toString() {
        return "AsyncNamedCacheClient{scope: \"" + this.f_sScopeName + "\"name: \"" + this.f_sName + "\" format: \"" + this.f_sFormat + "\"}";
    }

    protected static <T> T handleException(T result, Throwable t) {
        if (t != null) {
            StatusRuntimeException sre;
            Throwable cause = t.getCause();
            if (cause instanceof StatusRuntimeException && (sre = (StatusRuntimeException)cause).getStatus().getCode() == Status.Code.UNIMPLEMENTED.toStatus().getCode()) {
                throw new UnsupportedOperationException("This operation is not supported by the current gRPC proxy. Either upgrade the version of Coherence on the gRPC proxy or connect to a gRPC proxy that supports the operation.", (Throwable)sre);
            }
            throw Exceptions.ensureRuntimeException((Throwable)t);
        }
        return result;
    }

    protected static class EntryAdvancer<K, V>
    implements PagedIterator.Advancer {
        protected boolean m_exhausted;
        protected ByteString m_cookie;
        protected final AsyncNamedCacheClient<K, V> f_parent;

        protected EntryAdvancer(AsyncNamedCacheClient<K, V> client) {
            this.f_parent = client;
        }

        public void remove(Object oCurr) {
            Map.Entry entry = (Map.Entry)oCurr;
            try {
                this.f_parent.removeInternal(entry.getKey()).toCompletableFuture().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RequestIncompleteException((Throwable)e);
            }
        }

        public Collection nextPage() {
            if (this.m_exhausted) {
                return null;
            }
            NamedCacheClientChannel.EntrySetPage page = ((NamedCacheClientChannel)this.f_parent.f_client).getEntriesPage(this.m_cookie);
            this.m_cookie = !page.isEmpty() ? page.cookie() : null;
            this.m_exhausted = this.m_cookie == null || this.m_cookie.isEmpty();
            return ConverterCollections.getEntrySet(page.entries(), this.f_parent::fromByteString, this.f_parent::toKeyByteString, this.f_parent::fromByteString, this.f_parent::toByteString);
        }
    }

    public static class EventTask
    implements Runnable {
        private final CacheEvent<?, ?> f_event;
        private final MapListener f_listener;

        public EventTask(CacheEvent<?, ?> event, MapListener listener) {
            this.f_event = event;
            this.f_listener = listener;
        }

        @Override
        public void run() {
            NamedCache cache = (NamedCache)this.f_event.getSource();
            if (cache.isActive()) {
                try {
                    this.f_event.dispatch(this.f_listener);
                }
                catch (Throwable thrown) {
                    CacheFactory.err((String)"Caught exception dispatching event to listener");
                    CacheFactory.err((Throwable)thrown);
                }
            }
        }
    }

    public static interface Dependencies
    extends BaseGrpcClient.Dependencies {
        public long getHeartbeatMillis();

        public boolean isRequireHeartbeatAck();
    }

    public static class DefaultDependencies
    extends BaseGrpcClient.DefaultDependencies
    implements Dependencies {
        private long m_nEventsHeartbeat = 0L;
        private boolean m_fRequireHeartbeatAck;

        public DefaultDependencies(String sCacheName, Channel channel, GrpcCacheLifecycleEventDispatcher dispatcher) {
            super(sCacheName, channel, (EventDispatcher)dispatcher);
        }

        @Override
        public long getHeartbeatMillis() {
            return this.m_nEventsHeartbeat;
        }

        @Override
        public boolean isRequireHeartbeatAck() {
            return this.m_fRequireHeartbeatAck;
        }

        public void setHeartbeatMillis(long nEventsHeartbeat) {
            this.m_nEventsHeartbeat = Math.max(0L, nEventsHeartbeat);
        }

        public void setRequireHeartbeatAck(boolean fRequireHeartbeatAck) {
            this.m_fRequireHeartbeatAck = fRequireHeartbeatAck;
        }
    }

    protected static class WrapperDeactivationListener<K, V>
    implements DeactivationListener<AsyncNamedCacheClient<? super K, ? super V>> {
        protected final MapListener<? super K, ? super V> m_listener;

        protected WrapperDeactivationListener(MapListener<? super K, ? super V> listener) {
            this.m_listener = listener;
        }

        @Override
        public void released(AsyncNamedCacheClient<? super K, ? super V> client) {
        }

        @Override
        public void destroyed(AsyncNamedCacheClient<? super K, ? super V> client) {
            CacheEvent evt = client.createDeactivationEvent(true);
            this.m_listener.entryDeleted(evt);
        }
    }
}

