/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.common.v0;

import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Empty;
import com.google.protobuf.Int32Value;
import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.grpc.MaybeByteString;
import com.oracle.coherence.grpc.SafeStreamObserver;
import com.oracle.coherence.grpc.client.common.AsyncNamedCacheClient;
import com.oracle.coherence.grpc.client.common.BaseNamedCacheClientChannel;
import com.oracle.coherence.grpc.client.common.FutureStreamObserver;
import com.oracle.coherence.grpc.client.common.GrpcConnection;
import com.oracle.coherence.grpc.client.common.NamedCacheClientChannel;
import com.oracle.coherence.grpc.client.common.v0.NamedCacheGrpcClient;
import com.oracle.coherence.grpc.messages.cache.v0.Entry;
import com.oracle.coherence.grpc.messages.cache.v0.EntryResult;
import com.oracle.coherence.grpc.messages.cache.v0.GetAllRequest;
import com.oracle.coherence.grpc.messages.cache.v0.InvokeAllRequest;
import com.oracle.coherence.grpc.messages.cache.v0.MapEventResponse;
import com.oracle.coherence.grpc.messages.cache.v0.MapListenerErrorResponse;
import com.oracle.coherence.grpc.messages.cache.v0.MapListenerRequest;
import com.oracle.coherence.grpc.messages.cache.v0.MapListenerResponse;
import com.oracle.coherence.grpc.messages.cache.v0.MapListenerSubscribedResponse;
import com.oracle.coherence.grpc.messages.cache.v0.MapListenerUnsubscribedResponse;
import com.oracle.coherence.grpc.v0.Requests;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.SimpleMapEntry;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NamedCacheClientChannel_V0
extends BaseNamedCacheClientChannel
implements NamedCacheClientChannel {
    protected final NamedCacheGrpcClient f_service;
    protected EventStreamObserver m_evtResponseObserver;

    public NamedCacheClientChannel_V0(AsyncNamedCacheClient.Dependencies dependencies, GrpcConnection connection) {
        super(dependencies, connection);
        this.f_service = new NamedCacheGrpcClient(dependencies);
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public CompletableFuture<BytesValue> aggregate(List<ByteString> keys, ByteString aggregator, long nDeadline) {
        return this.f_service.aggregate(Requests.aggregate((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, keys, (ByteString)aggregator), nDeadline).toCompletableFuture();
    }

    @Override
    public CompletableFuture<BytesValue> aggregate(ByteString filter, ByteString aggregator, long nDeadline) {
        return this.f_service.aggregate(Requests.aggregate((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)filter, (ByteString)aggregator), nDeadline).toCompletableFuture();
    }

    @Override
    public CompletionStage<BytesValue> invoke(ByteString key, ByteString processor, long nDeadline) {
        return this.f_service.invoke(Requests.invoke((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)key, (ByteString)processor), nDeadline);
    }

    @Override
    public CompletableFuture<Map<ByteString, ByteString>> invokeAll(Collection<ByteString> serializedKeys, ByteString processor, long nDeadline) {
        CompletableFuture<Map<ByteString, ByteString>> future = new CompletableFuture<Map<ByteString, ByteString>>();
        BiFunction<Entry, Map, Map> function = (e, m) -> {
            try {
                m.put(e.getKey(), e.getValue());
                return m;
            }
            catch (Throwable ex) {
                future.completeExceptionally(ex);
                return null;
            }
        };
        FutureStreamObserver<Entry, Map> observer = new FutureStreamObserver<Entry, Map>(future, new HashMap(), function);
        InvokeAllRequest request = Requests.invokeAll((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, serializedKeys, (ByteString)processor);
        this.invokeAll(request, observer, nDeadline);
        return future;
    }

    @Override
    public CompletableFuture<Map<ByteString, ByteString>> invokeAll(ByteString filter, ByteString processor) {
        CompletableFuture<Map<ByteString, ByteString>> future = new CompletableFuture<Map<ByteString, ByteString>>();
        BiFunction<Entry, Map, Map> function = (e, m) -> {
            try {
                m.put(e.getKey(), e.getValue());
                return m;
            }
            catch (Throwable ex) {
                future.completeExceptionally(ex);
                return null;
            }
        };
        FutureStreamObserver<Entry, Map> observer = new FutureStreamObserver<Entry, Map>(future, new HashMap(), function);
        this.invokeAll(Requests.invokeAll((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)filter, (ByteString)processor), observer);
        return future;
    }

    @Override
    public CompletableFuture<Void> invokeAll(Collection<ByteString> colKeys, ByteString processor, Consumer<Map.Entry<ByteString, ByteString>> callback) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        BiFunction<Entry, Void, Void> function = (e, v) -> {
            try {
                callback.accept((Map.Entry<ByteString, ByteString>)new SimpleMapEntry((Object)e.getKey(), (Object)e.getValue()));
            }
            catch (Throwable ex) {
                future.completeExceptionally(ex);
            }
            return null;
        };
        FutureStreamObserver<Entry, Void> observer = new FutureStreamObserver<Entry, Void>(future, VOID, function);
        this.invokeAll(Requests.invokeAll((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, colKeys, (ByteString)processor), observer);
        return future;
    }

    @Override
    public CompletableFuture<Void> invokeAll(Collection<ByteString> colKeys, ByteString processor, BiConsumer<ByteString, ByteString> callback) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        BiFunction<Entry, Void, Void> function = (e, v) -> {
            try {
                callback.accept(e.getKey(), e.getValue());
            }
            catch (Throwable ex) {
                future.completeExceptionally(ex);
            }
            return null;
        };
        FutureStreamObserver<Entry, Void> observer = new FutureStreamObserver<Entry, Void>(future, VOID, function);
        this.invokeAll(Requests.invokeAll((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, colKeys, (ByteString)processor), observer);
        return future;
    }

    @Override
    public CompletableFuture<Void> invokeAll(ByteString filter, ByteString processor, Consumer<Map.Entry<ByteString, ByteString>> callback) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        BiFunction<Entry, Void, Void> function = (e, v) -> {
            try {
                callback.accept((Map.Entry<ByteString, ByteString>)new SimpleMapEntry((Object)e.getKey(), (Object)e.getValue()));
            }
            catch (Throwable ex) {
                future.completeExceptionally(ex);
            }
            return null;
        };
        FutureStreamObserver<Entry, Void> observer = new FutureStreamObserver<Entry, Void>(future, VOID, function);
        this.invokeAll(Requests.invokeAll((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)filter, (ByteString)processor), observer);
        return future;
    }

    @Override
    public CompletableFuture<Void> invokeAll(ByteString filter, ByteString processor, BiConsumer<ByteString, ByteString> callback) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        BiFunction<Entry, Void, Void> function = (e, v) -> {
            try {
                callback.accept(e.getKey(), e.getValue());
            }
            catch (Throwable ex) {
                future.completeExceptionally(ex);
            }
            return VOID;
        };
        FutureStreamObserver<Entry, Void> observer = new FutureStreamObserver<Entry, Void>(future, VOID, function);
        this.invokeAll(Requests.invokeAll((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)filter, (ByteString)processor), observer);
        return future;
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.f_service.clear(Requests.clear((String)this.f_sScopeName, (String)this.f_sName)).thenApply(e -> VOID).toCompletableFuture();
    }

    @Override
    public CompletionStage<BoolValue> isEmpty() {
        return this.f_service.isEmpty(Requests.isEmpty((String)this.f_sScopeName, (String)this.f_sName));
    }

    @Override
    public CompletionStage<BytesValue> putIfAbsent(ByteString key, ByteString value) {
        return this.f_service.putIfAbsent(Requests.putIfAbsent((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)key, (ByteString)value));
    }

    @Override
    public CompletionStage<BytesValue> replace(ByteString key, ByteString value) {
        return this.f_service.replace(Requests.replace((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)key, (ByteString)value));
    }

    @Override
    public CompletionStage<BoolValue> replaceMapping(ByteString key, ByteString oldValue, ByteString newValue) {
        return this.f_service.replaceMapping(Requests.replace((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)key, (ByteString)oldValue, (ByteString)newValue));
    }

    @Override
    public CompletionStage<Int32Value> size() {
        return this.f_service.size(Requests.size((String)this.f_sScopeName, (String)this.f_sName));
    }

    @Override
    public Stream<Map.Entry<ByteString, ByteString>> getAll(Iterable<ByteString> keys) {
        GetAllRequest request = Requests.getAll((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, keys);
        return this.f_service.getAll(request).map(e -> new SimpleMapEntry((Object)e.getKey(), (Object)e.getValue()));
    }

    @Override
    public CompletionStage<MaybeByteString> get(ByteString key) {
        return this.f_service.get(Requests.get((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)key)).thenApply(v -> v.getPresent() ? MaybeByteString.ofNullable((ByteString)v.getValue()) : MaybeByteString.empty());
    }

    public void invokeAll(InvokeAllRequest request, StreamObserver<Entry> observer) {
        this.invokeAll(request, observer, 0L);
    }

    protected void invokeAll(InvokeAllRequest request, StreamObserver<Entry> observer, long nDeadline) {
        this.f_service.invokeAll(request, observer, nDeadline);
    }

    @Override
    public CompletionStage<BoolValue> isReady() {
        return this.f_service.isReady(Requests.ready((String)this.f_sScopeName, (String)this.f_sName));
    }

    @Override
    public CompletionStage<BytesValue> put(ByteString key, ByteString value, long ttl) {
        return this.f_service.put(Requests.put((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)key, (ByteString)value, (long)ttl));
    }

    @Override
    public CompletableFuture<Empty> putAll(Map<ByteString, ByteString> map, long cMillis) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (Map.Entry<ByteString, ByteString> entry : map.entrySet()) {
            entries.add(Entry.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        return this.f_service.putAll(Requests.putAll((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, entries, (long)cMillis)).toCompletableFuture();
    }

    @Override
    public CompletionStage<Empty> removeIndex(ByteString extractor) {
        return this.f_service.removeIndex(Requests.removeIndex((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)extractor));
    }

    @Override
    public CompletionStage<BytesValue> remove(ByteString key) {
        return this.f_service.remove(Requests.remove((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)key));
    }

    @Override
    public CompletionStage<BoolValue> remove(ByteString key, ByteString value) {
        return this.f_service.removeMapping(Requests.remove((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)key, (ByteString)value));
    }

    @Override
    public CompletableFuture<Void> removeMapListener(ByteString key, boolean fPriming) {
        String uid = "";
        try {
            MapListenerRequest request = Requests.removeKeyMapListener((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)key, (boolean)fPriming, (ByteString)ByteString.EMPTY);
            uid = request.getUid();
            return this.m_evtResponseObserver.send(request);
        }
        catch (Throwable t) {
            this.m_evtResponseObserver.removeAndComplete(uid, t);
            return CompletableFuture.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<Void> removeMapListener(ByteString filterBytes, long nFilterId, ByteString triggerBytes) {
        String uid = "";
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            MapListenerRequest request = Requests.removeFilterMapListener((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)filterBytes, (long)nFilterId, (boolean)false, (boolean)false, (ByteString)triggerBytes);
            uid = request.getUid();
            future = this.m_evtResponseObserver.send(request);
        }
        catch (Throwable t) {
            this.m_evtResponseObserver.removeAndComplete(uid, t);
            future.completeExceptionally(t);
        }
        return future;
    }

    @Override
    public CompletionStage<Empty> truncate() {
        return this.f_service.truncate(Requests.truncate((String)this.f_sScopeName, (String)this.f_sName));
    }

    @Override
    public CompletionStage<BoolValue> containsKey(ByteString key) {
        return this.f_service.containsKey(Requests.containsKey((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)key));
    }

    @Override
    public CompletionStage<BoolValue> containsValue(ByteString value) {
        return this.f_service.containsValue(Requests.containsValue((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)value));
    }

    @Override
    public void setEventDispatcher(NamedCacheClientChannel.EventDispatcher dispatcher) {
        this.m_evtResponseObserver = new EventStreamObserver(dispatcher);
        CompletableFuture<Void> future = this.m_evtResponseObserver.whenSubscribed().toCompletableFuture();
        future.handle((v, err) -> {
            if (err != null) {
                this.m_evtResponseObserver.onCompleted();
            }
            return null;
        });
        long cDeadlineMillis = ((AsyncNamedCacheClient.Dependencies)this.f_dependencies).getDeadline();
        try {
            future.get(cDeadlineMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RequestTimeoutException("Timed out waiting for event subscription after " + cDeadlineMillis + " ms", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
    }

    @Override
    public Stream<BytesValue> getKeysPage(ByteString cookie) {
        return this.f_service.nextKeySetPage(Requests.page((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)cookie));
    }

    @Override
    public NamedCacheClientChannel.EntrySetPage getEntriesPage(ByteString cookie) {
        LinkedList list = this.f_service.nextEntrySetPage(Requests.page((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)cookie)).collect(Collectors.toCollection(LinkedList::new));
        if (list.isEmpty()) {
            return new NamedCacheClientChannel.EntrySetPage(null, List.of());
        }
        EntryResult first = (EntryResult)list.poll();
        return new NamedCacheClientChannel.EntrySetPage(first.getCookie(), (List<Map.Entry<ByteString, ByteString>>)ConverterCollections.getList((List)list, e -> new SimpleMapEntry((Object)e.getKey(), (Object)e.getValue()), e -> null));
    }

    @Override
    public CompletionStage<BoolValue> containsEntry(ByteString key, ByteString value) {
        return this.f_service.containsEntry(Requests.containsEntry((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)key, (ByteString)value));
    }

    @Override
    public CompletableFuture<Void> destroy() {
        if (this.m_evtResponseObserver != null) {
            this.m_evtResponseObserver.onCompleted();
        }
        return this.f_service.destroy(Requests.destroy((String)this.f_sScopeName, (String)this.f_sName)).thenApply(e -> VOID).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Void> addIndex(ByteString extractor, boolean fOrdered, ByteString comparator) {
        if (comparator == null) {
            return this.f_service.addIndex(Requests.addIndex((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)extractor, (boolean)fOrdered)).thenApply(e -> VOID).toCompletableFuture();
        }
        return this.f_service.addIndex(Requests.addIndex((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)extractor, (boolean)fOrdered, (ByteString)comparator)).thenApply(e -> VOID).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Void> addMapListener(ByteString key, boolean fLite, boolean fPriming, boolean fSynchronous) {
        String uid = "";
        try {
            MapListenerRequest request = Requests.addKeyMapListener((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)key, (boolean)fLite, (boolean)fPriming, (ByteString)ByteString.EMPTY);
            uid = request.getUid();
            return this.m_evtResponseObserver.send(request);
        }
        catch (Throwable t) {
            this.m_evtResponseObserver.removeAndComplete(uid, t);
            return CompletableFuture.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<Void> addMapListener(ByteString filterBytes, long nFilterId, boolean fLite, ByteString triggerBytes, boolean fSynchronous) {
        CompletableFuture<Void> future;
        String uid = "";
        try {
            MapListenerRequest request = Requests.addFilterMapListener((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)filterBytes, (long)nFilterId, (boolean)fLite, (boolean)false, (ByteString)triggerBytes);
            uid = request.getUid();
            future = this.m_evtResponseObserver.send(request);
        }
        catch (Throwable t) {
            this.m_evtResponseObserver.removeAndComplete(uid, t);
            future = CompletableFuture.failedFuture(t);
        }
        return future;
    }

    protected class EventStreamObserver
    implements StreamObserver<MapListenerResponse> {
        private final NamedCacheClientChannel.EventDispatcher f_dispatcher;
        protected final String f_sUid;
        protected final CompletableFuture<Void> f_future;
        protected volatile boolean m_fDone;
        protected final Lock f_lock = new ReentrantLock();
        private final SafeStreamObserver<MapListenerRequest> m_evtRequestObserver;
        protected final Map<String, CompletableFuture<Void>> f_mapFuture = new ConcurrentHashMap<String, CompletableFuture<Void>>();

        protected EventStreamObserver(NamedCacheClientChannel.EventDispatcher dispatcher) {
            this.f_dispatcher = dispatcher;
            this.f_sUid = UUID.randomUUID().toString();
            this.f_future = new CompletableFuture();
            StreamObserver<MapListenerRequest> observer = NamedCacheClientChannel_V0.this.f_service.events(this);
            this.m_evtRequestObserver = (SafeStreamObserver)SafeStreamObserver.ensureSafeObserver(observer);
            this.m_evtRequestObserver.whenDone().thenAccept(v -> this.f_mapFuture.values().forEach(f -> f.complete(null)));
            long nDeadline = ((AsyncNamedCacheClient.Dependencies)NamedCacheClientChannel_V0.this.f_dependencies).getDeadline();
            MapListenerRequest request = MapListenerRequest.newBuilder().setScope(NamedCacheClientChannel_V0.this.f_sScopeName).setCache(NamedCacheClientChannel_V0.this.f_sName).setUid(this.f_sUid).setSubscribe(true).setFormat(NamedCacheClientChannel_V0.this.f_sFormat).setType(MapListenerRequest.RequestType.INIT).setHeartbeatMillis(((AsyncNamedCacheClient.Dependencies)NamedCacheClientChannel_V0.this.f_dependencies).getHeartbeatMillis()).build();
            observer.onNext((Object)request);
        }

        public CompletionStage<Void> whenSubscribed() {
            return this.f_future;
        }

        public void onNext(MapListenerResponse response) {
            switch (response.getResponseTypeCase()) {
                case SUBSCRIBED: {
                    this.onSubscribed(response);
                    break;
                }
                case UNSUBSCRIBED: {
                    this.onUnsubscribed(response);
                    break;
                }
                case EVENT: {
                    MapEventResponse event = response.getEvent();
                    CacheEvent.TransformationState transformState = CacheEvent.TransformationState.valueOf((String)event.getTransformationState().toString());
                    this.f_dispatcher.dispatch(event.getFilterIdsList(), event.getId(), event.getKey(), event.getOldValue(), event.getNewValue(), event.getSynthetic(), event.getPriming(), transformState);
                    break;
                }
                case ERROR: {
                    this.onError(response);
                    break;
                }
                case DESTROYED: {
                    this.onDestroyed(response);
                    break;
                }
                case TRUNCATED: {
                    this.onTruncated(response);
                    break;
                }
                case HEARTBEAT: {
                    break;
                }
                case RESPONSETYPE_NOT_SET: {
                    Logger.info((String)"Received unexpected event without a response type!");
                    break;
                }
                default: {
                    Logger.info((String)("Received unexpected event " + String.valueOf(response.getEvent())));
                }
            }
        }

        public void onError(Throwable t) {
            this.f_lock.lock();
            try {
                this.m_fDone = true;
                if (!this.f_future.isDone()) {
                    this.f_future.completeExceptionally(t);
                }
                this.f_mapFuture.values().forEach(f -> f.complete(null));
            }
            finally {
                this.f_lock.unlock();
            }
        }

        public void onCompleted() {
            this.f_lock.lock();
            try {
                this.m_fDone = true;
                if (!this.f_future.isDone()) {
                    this.f_future.completeExceptionally(new IllegalStateException("Event observer completed without subscription"));
                }
                this.f_mapFuture.values().forEach(f -> f.complete(null));
            }
            finally {
                this.f_lock.unlock();
            }
        }

        private void onSubscribed(MapListenerResponse response) {
            MapListenerSubscribedResponse subscribed = response.getSubscribed();
            String responseUid = subscribed.getUid();
            if (this.f_sUid.equals(responseUid)) {
                this.f_future.complete(VOID);
            } else {
                CompletableFuture<Void> future = this.f_mapFuture.remove(responseUid);
                if (future != null) {
                    future.complete(VOID);
                }
                this.f_dispatcher.incrementListeners();
            }
        }

        private void onUnsubscribed(MapListenerResponse response) {
            MapListenerUnsubscribedResponse unsubscribed = response.getUnsubscribed();
            CompletableFuture<Void> future = this.f_mapFuture.remove(unsubscribed.getUid());
            if (future != null) {
                future.complete(VOID);
            }
            this.f_dispatcher.decrementListeners();
        }

        private void onDestroyed(MapListenerResponse response) {
            if (response.getDestroyed().getCache().equals(NamedCacheClientChannel_V0.this.f_sName)) {
                this.f_dispatcher.onDestroy();
            }
        }

        private void onTruncated(MapListenerResponse response) {
            if (response.getTruncated().getCache().equals(NamedCacheClientChannel_V0.this.f_sName)) {
                this.f_dispatcher.onTruncate();
            }
        }

        private void onError(MapListenerResponse response) {
            MapListenerErrorResponse error = response.getError();
            String responseUid = error.getUid();
            if (this.f_sUid.equals(responseUid)) {
                this.f_future.completeExceptionally(new RuntimeException(error.getMessage()));
            } else {
                CompletableFuture<Void> future = this.f_mapFuture.remove(responseUid);
                if (future != null) {
                    future.completeExceptionally(new RuntimeException(error.getMessage()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletableFuture<Void> send(MapListenerRequest request) {
            if (this.m_fDone) {
                return CompletableFuture.completedFuture(null);
            }
            this.f_lock.lock();
            try {
                if (this.m_fDone) {
                    CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                    return completableFuture;
                }
                CompletableFuture<Void> future = new CompletableFuture<Void>();
                this.f_mapFuture.put(request.getUid(), future);
                this.m_evtRequestObserver.onNext((Object)request);
                CompletableFuture<Void> completableFuture = future;
                return completableFuture;
            }
            finally {
                this.f_lock.unlock();
            }
        }

        public void removeAndComplete(String uid, Throwable t) {
            CompletableFuture<Void> future = this.f_mapFuture.remove(uid);
            if (future != null && !future.isDone()) {
                if (t == null) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(t);
                }
            }
        }

        public String toString() {
            return "EventStreamObserver(cacheName='" + NamedCacheClientChannel_V0.this.f_sName + "', uid='" + this.f_sUid + "')";
        }
    }
}

