/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.common;

import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.UnsafeByteOperations;
import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.grpc.BinaryHelper;
import com.oracle.coherence.grpc.MaybeByteString;
import com.oracle.coherence.grpc.client.common.ClientProtocol;
import com.tangosol.coherence.config.Config;
import com.tangosol.io.NamedSerializerFactory;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.net.cache.KeyAssociation;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.util.Binary;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.ExternalizableHelper;
import io.grpc.Channel;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public abstract class BaseGrpcClient<V, ClientType extends ClientProtocol> {
    protected final ClientType f_client;
    protected final String f_sScopeName;
    protected final String f_sName;
    protected final Serializer f_serializer;
    protected final String f_sFormat;
    protected volatile boolean m_fReleased;
    protected volatile boolean m_fDestroyed;
    protected final Executor f_executor;
    protected final EventDispatcher f_dispatcher;
    protected final Dependencies f_dependencies;
    private final boolean f_fDeferKeyAssociationCheck;

    public BaseGrpcClient(Dependencies dependencies, ClientType client) {
        this.f_client = (ClientProtocol)Objects.requireNonNull(client);
        this.f_dependencies = dependencies;
        this.f_sName = dependencies.getName();
        this.f_dispatcher = dependencies.getEventDispatcher();
        this.f_sScopeName = dependencies.getScopeName().orElse("");
        this.f_executor = dependencies.getExecutor().orElseGet(BaseGrpcClient::createDefaultExecutor);
        this.f_sFormat = dependencies.getSerializerFormat().orElseGet(() -> dependencies.getSerializer().map(Serializer::getName).orElseGet(BaseGrpcClient::getDefaultSerializerFormat));
        this.f_serializer = dependencies.getSerializer().orElseGet(() -> BaseGrpcClient.createSerializer(this.f_sFormat));
        this.f_fDeferKeyAssociationCheck = dependencies.isDeferKeyAssociationCheck();
    }

    public ClientType getClientProtocol() {
        return this.f_client;
    }

    public boolean isReleased() {
        return this.m_fReleased;
    }

    public boolean isDestroyed() {
        return this.m_fDestroyed;
    }

    public boolean isActiveInternal() {
        return this.f_client.isActive() && !this.m_fReleased && !this.m_fDestroyed;
    }

    protected static Serializer createSerializer(String sFormat) {
        return NamedSerializerFactory.DEFAULT.getNamedSerializer(sFormat, Classes.getContextClassLoader());
    }

    public static String getDefaultSerializerFormat() {
        return Config.getBoolean((String)"coherence.pof.enabled") ? "pof" : "java";
    }

    protected static Executor createDefaultExecutor() {
        return Executors.newSingleThreadExecutor();
    }

    public BytesValue toBytesValue(Object obj) {
        return BytesValue.of((ByteString)this.toByteString(obj));
    }

    public ByteString toByteStringOrNull(Object obj) {
        return obj == null ? null : this.toByteString(obj);
    }

    public ByteString toByteString(Object obj) {
        return UnsafeByteOperations.unsafeWrap((ByteBuffer)ExternalizableHelper.toBinary((Object)obj, (Serializer)this.f_serializer).toByteBuffer());
    }

    public ByteString toKeyByteString(Object obj) {
        Binary bin = ExternalizableHelper.toBinary((Object)obj, (Serializer)this.f_serializer);
        if (this.f_fDeferKeyAssociationCheck) {
            return UnsafeByteOperations.unsafeWrap((ByteBuffer)bin.toByteBuffer());
        }
        BinaryHelper.toKeyByteString((Binary)bin, (Object)obj, (Serializer)this.f_serializer);
        Binary binDeco = bin;
        if (obj instanceof KeyAssociation && (obj = ((KeyAssociation)obj).getAssociatedKey()) != null) {
            binDeco = ExternalizableHelper.toBinary((Object)obj, (Serializer)this.f_serializer);
        }
        return UnsafeByteOperations.unsafeWrap((ByteBuffer)ExternalizableHelper.decorateBinary((ReadBuffer)bin, (int)binDeco.calculateNaturalPartition(0)).toByteBuffer());
    }

    <KOut, VOut> Map<KOut, VOut> toMap(Map<ByteString, ByteString> map) {
        return ConverterCollections.getMap(map, this::fromByteString, this::toByteString, this::fromByteString, this::toByteString);
    }

    <KOut, VOut> Map.Entry<KOut, VOut> toMapEntry(Map.Entry<ByteString, ByteString> entry) {
        return ConverterCollections.getEntry(entry, this::fromByteString, this::fromByteString, this::toByteString);
    }

    public V valueFromBytesValue(BytesValue bv) {
        return (V)this.fromBytesValue(bv);
    }

    public <T> T fromBytesValue(BytesValue bytes) {
        return (T)BinaryHelper.fromBytesValue((BytesValue)bytes, (Serializer)this.f_serializer);
    }

    public <T> T fromByteString(ByteString bytes) {
        return (T)BinaryHelper.fromByteString((ByteString)bytes, (Serializer)this.f_serializer);
    }

    public <T> T fromByteString(MaybeByteString bytes, T defaultValue) {
        if (bytes.isPresent()) {
            return (T)BinaryHelper.fromByteString((ByteString)bytes.value(), (Serializer)this.f_serializer);
        }
        return defaultValue;
    }

    public <T> CompletableFuture<T> failedFuture(Throwable t) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(t);
        return future;
    }

    public static interface Dependencies {
        public String getName();

        public Channel getChannel();

        public Optional<String> getScopeName();

        public Optional<Serializer> getSerializer();

        public Optional<String> getSerializerFormat();

        public Optional<Executor> getExecutor();

        public EventDispatcher getEventDispatcher();

        default public long getDeadline() {
            return 30000L;
        }

        default public boolean isDeferKeyAssociationCheck() {
            return false;
        }
    }

    public static class DefaultDependencies
    implements Dependencies {
        private final String f_sName;
        private final Channel f_channel;
        private final EventDispatcher f_dispatcher;
        private String m_sScopeName;
        private Executor m_executor;
        private Serializer m_serializer;
        private String m_serializerFormat;
        private long m_cDeadlineMillis;
        private boolean m_fDeferKeyAssociationCheck;

        public DefaultDependencies(String sName, Channel channel, EventDispatcher dispatcher) {
            this.f_sName = sName;
            this.f_channel = channel;
            this.m_sScopeName = "";
            this.f_dispatcher = dispatcher;
        }

        @Override
        public String getName() {
            return this.f_sName;
        }

        @Override
        public Channel getChannel() {
            return this.f_channel;
        }

        @Override
        public Optional<String> getScopeName() {
            return Optional.ofNullable(this.m_sScopeName);
        }

        @Override
        public Optional<Serializer> getSerializer() {
            return Optional.ofNullable(this.m_serializer);
        }

        @Override
        public Optional<String> getSerializerFormat() {
            return Optional.ofNullable(this.m_serializerFormat);
        }

        @Override
        public Optional<Executor> getExecutor() {
            return Optional.ofNullable(this.m_executor);
        }

        @Override
        public EventDispatcher getEventDispatcher() {
            return this.f_dispatcher;
        }

        @Override
        public long getDeadline() {
            if (this.m_cDeadlineMillis <= 0L) {
                return Dependencies.super.getDeadline();
            }
            return this.m_cDeadlineMillis;
        }

        @Override
        public boolean isDeferKeyAssociationCheck() {
            return this.m_fDeferKeyAssociationCheck;
        }

        public void setScope(String sScopeName) {
            this.m_sScopeName = "$DEFAULT$".equals(sScopeName) ? "" : sScopeName;
        }

        public void setExecutor(Executor executor) {
            this.m_executor = executor;
        }

        public void setSerializerFormat(String sFormat) {
            this.m_serializerFormat = sFormat;
            this.m_serializer = null;
        }

        public void setSerializer(Serializer serializer) {
            String sFormat = serializer == null ? null : serializer.getName();
            this.setSerializer(serializer, sFormat);
        }

        public void setSerializer(Serializer serializer, String sFormat) {
            this.m_serializer = serializer;
            this.m_serializerFormat = sFormat;
        }

        public void setDeadline(long cMillis) {
            this.m_cDeadlineMillis = cMillis;
        }

        public void setDeferKeyAssociationCheck(boolean f) {
            this.m_fDeferKeyAssociationCheck = f;
        }
    }
}

