/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.discovery;

import com.tangosol.discovery.Connection;
import com.tangosol.discovery.NSLookup;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.zip.CRC32;

public class PingRequest {
    public static final String COMMAND_HELP = "?";
    public static final String COMMAND_HOST = "host";
    public static final String COMMAND_PORT = "port";
    public static final String COMMAND_NAME = "name";
    public static final String COMMAND_CLUSTER = "cluster";
    public static final String COMMAND_TIMEOUT = "timeout";
    public static final String COMMAND_LIST = "list";
    public static final int DEFAULT_TIMEOUT = 30;
    public static final String PING_SUCCEEDED = "Coherence proxy service ping succeeded";
    public static final String PING_FAILED = "Coherence proxy service ping failed";
    public static final String[] VALID_COMMANDS = new String[]{"?", "host", "port", "name", "cluster", "timeout", "list"};
    private static final byte[] BASIC_PING = new byte[]{7, 0, 3, 0, 0, 66, 0, 64};
    private static final byte[] BASIC_RESULT = new byte[]{9, 0, 4, 3, 0, 66, 0, 3, 100, 64};
    private static final byte[] BASIC_RESULT_NO_LEN = new byte[]{0, 4, 3, 0, 66, 0, 3, 100, 64};
    private static final byte[] OLDER_VERSION_RESULT = new byte[]{9, 0, 4, 2, 0, 66, 1, 3, 100, 64};
    private static final byte[] OLDER_VERSION_NO_LEN = new byte[]{0, 4, 2, 0, 66, 0, 3, 100, 64};
    private static final byte[] QUERY_PING = new byte[]{7, 0, 3, 0, 0, 66, 1, 64};
    private String m_sHost;
    private int m_nPort;
    private String m_sName;
    private String m_sCluster;
    private int m_cTimeoutMillis;
    private boolean m_fList;

    public PingRequest(String sHost, int nPort, String sName, String sCluster, int cTimeout, boolean fList) {
        this.m_sHost = sHost;
        this.m_nPort = nPort;
        this.m_sName = sName;
        this.m_sCluster = sCluster;
        this.m_cTimeoutMillis = cTimeout * 1000;
        this.m_fList = fList;
    }

    public static void main(String[] asArg) {
        String sHost = null;
        int nPort = 0;
        String sName = null;
        String sCluster = null;
        int nTimeout = 30;
        boolean fList = false;
        try {
            LinkedHashMap mapArgs = NSLookup.parseArguments(asArg, VALID_COMMANDS, true);
            if (mapArgs.isEmpty()) {
                PingRequest.missingArguments();
            }
            if (mapArgs.containsKey(COMMAND_HELP) || mapArgs.get(0) != null) {
                PingRequest.missingArguments();
            }
            sHost = (String)mapArgs.get(COMMAND_HOST);
            String sPort = (String)mapArgs.get(COMMAND_PORT);
            if (sPort != null) {
                nPort = Integer.parseInt((String)mapArgs.get(COMMAND_PORT));
            }
            if ((sName = (String)mapArgs.get(COMMAND_NAME)) != null) {
                if (nPort == 0) {
                    nPort = 7574;
                }
                sCluster = (String)mapArgs.get(COMMAND_CLUSTER);
            } else {
                if (nPort == 0) {
                    PingRequest.missingArguments();
                }
                fList = mapArgs.containsKey(COMMAND_LIST);
            }
            String sTimeout = (String)mapArgs.get(COMMAND_TIMEOUT);
            nTimeout = sTimeout == null ? 30 : Integer.parseInt(sTimeout);
        }
        catch (Throwable e) {
            System.err.println();
            System.err.println(e);
            System.err.println();
            PingRequest.showInstructions();
            System.exit(1);
        }
        try {
            boolean result;
            PingRequest request = new PingRequest(sHost, nPort, sName, sCluster, nTimeout, fList);
            boolean bl = result = sName == null ? request.ping() : request.nsLookup();
            if (result) {
                System.out.println(PING_SUCCEEDED);
            } else {
                System.out.println(PING_FAILED);
            }
        }
        catch (Exception e) {
            System.err.println("An exception occurred while executing the PingRequest:");
            System.err.println(e);
            System.out.println(PING_FAILED);
            System.err.println();
            System.exit(1);
        }
    }

    protected static void missingArguments() {
        System.out.println();
        System.out.println("Missing arguments.");
        System.out.println("Please either specify proxy server host and port, or proxy service name with optional cluster name, address, or port.");
        PingRequest.showInstructions();
        System.exit(1);
    }

    protected static void showInstructions() {
        String sClass = PingRequest.class.getCanonicalName();
        System.out.println();
        System.out.println("java " + sClass + " <commands ...>");
        System.out.println();
        System.out.println("command options:");
        System.out.println("\t-host     (optional when -name is specified; required otherwise) the host of the proxy service or cluster to send the ping request");
        System.out.println("\t-port     (optional when -name is specified; required otherwise) the listen port of the proxy service or the cluster port");
        System.out.println("\t-name     (optional when -host and -port are specified; required otherwise) the proxy service name.  When using -name, the host is the cluster address");
        System.out.println("\t-cluster  (optional) the cluster; used only with -name");
        System.out.println("\t-timeout  (optional) the timeout (in seconds) of the ping request, default 30s");
        System.out.println("\t-list     (optional) returns a list of the address:port of the members in the proxy service, separated by ','");
        System.out.println();
        System.out.println("Example: obtain a list of proxy service listen addresses by pinging a proxy service directly...");
        System.out.println("\tjava " + sClass + " -host proxyhost.mycompany.com -port 9000 -list");
        System.out.println();
        System.out.println("Example: obtain a list of proxy service listen addresses for a proxy service by name...");
        System.out.println("\tjava " + sClass + " -name myproxyservice -cluster mycluster");
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping() throws IOException {
        InetAddress[] aHostAddresses;
        IOException ex = null;
        for (InetAddress address : aHostAddresses = InetAddress.getAllByName(this.m_sHost)) {
            try (Socket clientSocket = null;){
                int i;
                clientSocket = new Socket();
                clientSocket.setTcpNoDelay(true);
                clientSocket.connect(new InetSocketAddress(address, this.m_nPort), this.m_cTimeoutMillis);
                DataOutputStream outToServer = new DataOutputStream(clientSocket.getOutputStream());
                DataInputStream inFromServer = new DataInputStream(clientSocket.getInputStream());
                if (this.m_fList) {
                    outToServer.write(QUERY_PING);
                } else {
                    outToServer.write(BASIC_PING);
                }
                outToServer.flush();
                byte[] resultReturned = NSLookup.read(inFromServer);
                int len = resultReturned.length;
                if (!this.m_fList) {
                    if (Arrays.equals(BASIC_RESULT, resultReturned) || Arrays.equals(BASIC_RESULT_NO_LEN, resultReturned) || Arrays.equals(OLDER_VERSION_NO_LEN, resultReturned)) {
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                if (len == 10) {
                    if (Arrays.equals(OLDER_VERSION_RESULT, resultReturned)) {
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                for (i = 0; i < len && (i <= 6 || resultReturned[i] != 85); ++i) {
                }
                DataInputStream resultStream = new DataInputStream(new ByteArrayInputStream(resultReturned, i, len - i));
                Collection aAddresses = PingRequest.readCollection(resultStream);
                System.out.println("Addresses-hash: " + PingRequest.makeCheckSumHash(resultReturned));
                System.out.println("Address-list: " + String.valueOf(aAddresses));
                boolean bl = true;
                return bl;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return false;
    }

    public static long makeCheckSumHash(byte[] input) {
        CRC32 checksum = new CRC32();
        checksum.reset();
        checksum.update(input);
        return checksum.getValue();
    }

    public static Collection readCollection(DataInputStream inputStream) throws IOException {
        inputStream.skipBytes(1);
        int size = NSLookup.readPackedInt(inputStream);
        if (size < 0) {
            throw new IOException("Received a message with a negative array length");
        }
        ArrayList<String> result = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            inputStream.skipBytes(1);
            int len = NSLookup.readPackedInt(inputStream);
            byte[] ab = new byte[len];
            inputStream.readFully(ab, 0, len);
            result.add(new String(ab));
        }
        return result;
    }

    public boolean nsLookup() throws IOException {
        InetAddress[] aHostAddresses;
        for (InetAddress address : aHostAddresses = InetAddress.getAllByName(this.m_sHost)) {
            InetSocketAddress socketAddr = new InetSocketAddress(address, this.m_nPort);
            try (Connection conn = Connection.open(this.m_sCluster, socketAddr, this.m_cTimeoutMillis);){
                DataInputStream resultStream = conn.lookupRaw("NameService/string/" + this.m_sName + "/addresses");
                byte[] resultReturned = new byte[256];
                int len = resultStream.read(resultReturned);
                resultStream.reset();
                if (resultStream == null) continue;
                System.out.println("Addresses-hash: " + PingRequest.makeCheckSumHash(resultReturned));
                System.out.println("Address-list: " + NSLookup.readString(resultStream));
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

