/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.discovery;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.remote.JMXServiceURL;

public class NSLookup {
    public static final String COMMAND_HELP = "?";
    public static final String COMMAND_HOST = "host";
    public static final String COMMAND_LOCAL = "local";
    public static final String COMMAND_TTL = "ttl";
    public static final String COMMAND_PORT = "port";
    public static final String COMMAND_TIMEOUT = "timeout";
    public static final String COMMAND_CLUSTER = "cluster";
    public static final String COMMAND_NAME = "name";
    public static final String[] VALID_COMMANDS = new String[]{"?", "host", "local", "ttl", "cluster", "port", "timeout", "name"};
    public static final String NS_STRING_PREFIX = "NameService/string/";
    public static final String JMX_CONNECTOR_URL = "management/JMXServiceURL";
    public static final String HTTP_MANAGEMENT_URL = "management/HTTPManagementURL";
    public static final String HTTP_METRICS_URL = "metrics/HTTPMetricsURL";
    public static final String HTTP_HEALTH_URL = "health/HTTPHealthURL";
    public static final int DEFAULT_TIMEOUT = 5000;
    public static final int DEFAULT_CLUSTERPORT = 7574;
    public static final String DEFAULT_HOST = "239.192.0.0";
    public static final int DEFAULT_TTL = 4;
    public static final String DEFAULT_NAME = "Cluster/info";
    private static final int MULTIPLEXED_SOCKET = 1522655232;
    private static final int NAMESERVICE_SUBPORT = 3;
    private static final byte REQ_END_MARKER = 64;
    private static final byte[] CONN_OPEN = new byte[]{0, 1, 2, 0, 66, 0, 1, 14, 0, 0, 66, -90, -74, -97, -34, -78, 81, 1, 65, -29, -13, -28, -35, 15, 2, 65, -113, -10, -70, -103, 1, 3, 65, -8, -76, -27, -14, 4, 4, 65, -60, -2, -36, -11, 5, 5, 65, -41, -50, -61, -115, 7, 6, 65, -37, -119, -36, -43, 10, 64, 2, 110, 3, 93, 78, 87, 2, 17, 77, 101, 115, 115, 97, 103, 105, 110, 103, 80, 114, 111, 116, 111, 99, 111, 108, 2, 65, 2, 65, 2, 19, 78, 97, 109, 101, 83, 101, 114, 118, 105, 99, 101, 80, 114, 111, 116, 111, 99, 111, 108, 2, 65, 1, 65, 1, 5, -96, 2, 0, 0, 14, 0, 0, 66, -82, -119, -98, -34, -78, 81, 1, 65, -127, -128, -128, -16, 15, 5, 65, -104, -97, -127, -128, 8, 6, 65, -109, -98, 1, 64, 1, 106, 2, 110, 3, 106, 4, 113, 5, 113, 6, 78, 8, 67, 108, 117, 115, 116, 101, 114, 66, 9, 78, 9, 108, 111, 99, 97, 108, 104, 111, 115, 116, 10, 78, 5, 50, 48, 50, 51, 51, 12, 78, 16, 67, 111, 104, 101, 114, 101, 110, 99, 101, 67, 111, 110, 115, 111, 108, 101, 64, 64};
    private static final byte[] CHANNEL_OPEN = new byte[]{0, 11, 2, 0, 66, 1, 1, 78, 19, 78, 97, 109, 101, 83, 101, 114, 118, 105, 99, 101, 80, 114, 111, 116, 111, 99, 111, 108, 2, 78, 11, 78, 97, 109, 101, 83, 101, 114, 118, 105, 99, 101, 64};
    private static final byte[] NS_LOOKUP_REQ_ID = new byte[]{1, 1, 0, 66, 0, 1, 78};

    public static JMXServiceURL lookupJMXServiceURL(SocketAddress socketAddr) throws IOException {
        return NSLookup.lookupJMXServiceURL(null, socketAddr);
    }

    public static JMXServiceURL lookupJMXServiceURL(String sCluster, SocketAddress socketAddr) throws IOException {
        String sURL = NSLookup.lookup(sCluster, JMX_CONNECTOR_URL, socketAddr, 5000);
        return sURL == null ? null : new JMXServiceURL(sURL);
    }

    public static Collection<URL> lookupHTTPManagementURL(SocketAddress socketAddr) throws IOException {
        return NSLookup.lookupHTTPManagementURL(null, socketAddr);
    }

    public static Collection<URL> lookupHTTPManagementURL(String sCluster, SocketAddress socketAddr) throws IOException {
        return NSLookup.lookupURL(sCluster, socketAddr, "NameService/string/management/HTTPManagementURL");
    }

    public static Collection<URL> lookupHTTPMetricsURL(SocketAddress socketAddr) throws IOException {
        return NSLookup.lookupHTTPMetricsURL(null, socketAddr);
    }

    public static Collection<URL> lookupHTTPMetricsURL(String sCluster, SocketAddress socketAddr) throws IOException {
        return NSLookup.lookupURL(sCluster, socketAddr, "NameService/string/metrics/HTTPMetricsURL");
    }

    public static Collection<URL> lookupHTTPHealthURL(SocketAddress socketAddr) throws IOException {
        return NSLookup.lookupHTTPHealthURL(null, socketAddr);
    }

    public static Collection<URL> lookupHTTPHealthURL(String sCluster, SocketAddress socketAddr) throws IOException {
        return NSLookup.lookupURL(sCluster, socketAddr, "NameService/string/health/HTTPHealthURL");
    }

    private static Collection<URL> lookupURL(String sCluster, SocketAddress socketAddr, String sName) throws IOException {
        String[] asURL;
        ArrayList<URL> colUrl = new ArrayList<URL>();
        String sURL = NSLookup.lookup(sCluster, sName, socketAddr, 5000);
        String[] stringArray = asURL = sURL == null ? null : sURL.split("[\\[,\\] ]+");
        if (asURL != null) {
            for (int i = 1; i < asURL.length; ++i) {
                colUrl.add(new URL(asURL[i]));
            }
        }
        return colUrl;
    }

    public static String lookup(String sName, SocketAddress socketAddr, int cTimeOutMillis) throws IOException {
        try (Connection connection = new Connection(socketAddr, cTimeOutMillis);){
            String string = connection.lookup(sName);
            return string;
        }
    }

    public static String lookup(String sCluster, String sName, SocketAddress socketAddr, int cTimeOutMillis) throws IOException {
        try (Connection conn = Connection.open(sCluster, socketAddr, cTimeOutMillis);){
            String string = conn.lookup(sName);
            return string;
        }
    }

    private static void write(DataOutputStream outStream, byte[] ab) throws IOException {
        int cb = ab.length;
        NSLookup.writePackedInt(outStream, cb);
        outStream.write(ab, 0, cb);
    }

    protected static byte[] read(DataInputStream inStream) throws IOException {
        int cb = NSLookup.readPackedInt(inStream);
        if (cb < 0) {
            throw new IOException("Received a message with a negative length");
        }
        if (cb == 0) {
            throw new IOException("Received a message with a length of zero");
        }
        byte[] ab = new byte[cb];
        inStream.readFully(ab);
        return ab;
    }

    private static void writePackedInt(DataOutputStream outStream, int n) throws IOException {
        int b = 0;
        if (n < 0) {
            b = 64;
            n ^= 0xFFFFFFFF;
        }
        b |= (byte)(n & 0x3F);
        n >>>= 6;
        while (n != 0) {
            outStream.writeByte(b |= 0x80);
            b = n & 0x7F;
            n >>>= 7;
        }
        outStream.writeByte(b);
    }

    protected static int readPackedInt(DataInputStream inStream) throws IOException {
        boolean fNeg;
        int b = inStream.readUnsignedByte();
        int n = b & 0x3F;
        int cBits = 6;
        boolean bl = fNeg = (b & 0x40) != 0;
        while ((b & 0x80) != 0) {
            b = inStream.readUnsignedByte();
            n |= (b & 0x7F) << cBits;
            cBits += 7;
        }
        if (fNeg) {
            n ^= 0xFFFFFFFF;
        }
        return n;
    }

    protected static String validateCommand(String sCommand, String[] asCommand, boolean fCaseSens) {
        if (!fCaseSens) {
            sCommand = sCommand.toLowerCase();
        }
        if (asCommand == null) {
            return sCommand;
        }
        for (int i = 0; i < asCommand.length; ++i) {
            if (!asCommand[i].equals(sCommand)) continue;
            return sCommand;
        }
        throw new IllegalArgumentException("Illegal command: -" + sCommand);
    }

    public static LinkedHashMap parseArguments(String[] asArg, String[] asCommand, boolean fCaseSens) {
        LinkedHashMap<Object, String> map = new LinkedHashMap<Object, String>();
        String sCommand = null;
        int iArg = -1;
        for (int i = 0; i < asArg.length; ++i) {
            String sArg = asArg[i];
            if (sArg.charAt(0) == '-') {
                if (sCommand != null) {
                    map.put(sCommand, null);
                }
                if ((sCommand = sArg.substring(1)).length() == 0) {
                    throw new IllegalArgumentException("An empty command");
                }
                int of = sCommand.indexOf(61);
                if (of < 0) {
                    of = sCommand.indexOf(58);
                }
                if (of > 0) {
                    String sValue = sCommand.substring(of + 1);
                    sCommand = NSLookup.validateCommand(sCommand.substring(0, of), asCommand, fCaseSens);
                    map.put(sCommand, sValue);
                    sCommand = null;
                    continue;
                }
                sCommand = NSLookup.validateCommand(sCommand, asCommand, fCaseSens);
                continue;
            }
            if (sCommand == null) {
                map.put(++iArg, sArg);
                continue;
            }
            map.put(sCommand, sArg);
            sCommand = null;
        }
        if (sCommand != null) {
            map.put(sCommand, null);
        }
        return map;
    }

    public static void datagramLookupRaw(String sCluster, String sName, InetSocketAddress addrGroup, InetAddress addrLocal, int cTimeoutMillis, int nTTL, byte[] abMemberClient, BiConsumer<String, DataInputStream> consumerResult) throws IOException {
        HashSet<String> setCluster = new HashSet<String>();
        try (MulticastSocket socket = new MulticastSocket();){
            int cAttempts;
            byte[] abAddrThis = addrLocal == null || addrLocal.isAnyLocalAddress() ? null : addrLocal.getAddress();
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outBytes);
            int cDelayMillis = 200;
            if (cTimeoutMillis == 0) {
                cAttempts = Integer.MAX_VALUE;
            } else {
                cDelayMillis = Math.min(cTimeoutMillis, cDelayMillis);
                cAttempts = cTimeoutMillis / cDelayMillis;
            }
            out.writeInt(232718554);
            out.writeUTF(sCluster == null ? "" : sCluster);
            out.flush();
            int ofAttempt = outBytes.size();
            out.writeByte(0);
            out.writeByte(cAttempts);
            if (abAddrThis == null) {
                out.writeByte(0);
                out.writeInt(0);
            } else {
                out.writeByte(abAddrThis.length);
                out.write(abAddrThis);
                out.writeInt(socket.getLocalPort());
                socket.setInterface(addrLocal);
            }
            out.writeUTF(sName);
            if (abMemberClient == null) {
                out.writeInt(0);
            } else {
                out.writeInt(abMemberClient.length);
                out.write(abMemberClient);
            }
            out.flush();
            byte[] abReq = outBytes.toByteArray();
            DatagramPacket packetReq = new DatagramPacket(abReq, 0, abReq.length);
            packetReq.setSocketAddress(addrGroup);
            socket.setSoTimeout(cDelayMillis);
            socket.setTimeToLive(nTTL);
            byte[] abResp = new byte[65535];
            DatagramPacket packetResp = new DatagramPacket(abResp, 0, abResp.length);
            int n = ofAttempt;
            abReq[n] = (byte)(abReq[n] + 1);
            socket.send(packetReq);
            do {
                try {
                    if (Thread.interrupted()) {
                        throw new InterruptedIOException();
                    }
                    socket.receive(packetResp);
                    DataInputStream in = new DataInputStream(new ByteArrayInputStream(abResp));
                    if (in.readInt() == 232718554) {
                        String sClusterResult = in.readUTF();
                        if (sCluster == null || sCluster.equals(sClusterResult)) {
                            in.read();
                            in.read();
                            byte cbAddr = in.readByte();
                            byte[] abAddr = new byte[cbAddr];
                            in.readFully(abAddr);
                            in.readInt();
                            if (sName.equals(in.readUTF()) && setCluster.add(sClusterResult)) {
                                in.mark(4);
                                int cbResult = in.readInt();
                                in.reset();
                                if (cbResult == -1) {
                                    InetAddress addrTcp = InetAddress.getByAddress(abAddr);
                                    try (Connection conn = Connection.open(sClusterResult, new InetSocketAddress(addrTcp, addrGroup.getPort()), cTimeoutMillis);){
                                        consumerResult.accept(sClusterResult, conn.lookupRaw(sName));
                                    }
                                } else {
                                    consumerResult.accept(sClusterResult, in);
                                }
                                if (sCluster != null) {
                                    return;
                                }
                            }
                        }
                    }
                }
                catch (SocketTimeoutException e) {
                    --cAttempts;
                    int n2 = ofAttempt;
                    abReq[n2] = (byte)(abReq[n2] + 1);
                    if (abReq[ofAttempt] == 0) {
                        abReq[ofAttempt] = 1;
                    }
                    socket.send(packetReq);
                }
            } while (cAttempts > 0);
        }
        if (setCluster.isEmpty()) {
            throw new IOException((String)(sCluster == null ? "no cluster could be located" : "cluster '" + sCluster + "' could not be located"));
        }
    }

    public static DataInputStream datagramLookupRaw(String sCluster, String sName, InetSocketAddress addrGroup, InetAddress addrLocal, int cTimeoutMillis, int nTTL, byte[] abMemberClient) throws IOException {
        final AtomicReference refResult = new AtomicReference();
        NSLookup.datagramLookupRaw(sCluster, sName, addrGroup, addrLocal, cTimeoutMillis, nTTL, abMemberClient, new BiConsumer<String, DataInputStream>(){

            @Override
            public void accept(String t, DataInputStream in) {
                refResult.set(in);
            }
        });
        return (DataInputStream)refResult.get();
    }

    public static void datagramLookup(String sCluster, String sName, InetSocketAddress addrGroup, InetAddress addrLocal, int cTimeoutMillis, int nTTL, byte[] abMemberClient, final BiConsumer<String, String> consumerResult) throws IOException {
        NSLookup.datagramLookupRaw(sCluster, sName, addrGroup, addrLocal, cTimeoutMillis, nTTL, abMemberClient, new BiConsumer<String, DataInputStream>(){

            @Override
            public void accept(String sCluster1, DataInputStream in) {
                consumerResult.accept(sCluster1, NSLookup.readString(in));
            }
        });
    }

    public static String readString(DataInputStream in) {
        try {
            int cbResult = in.readInt();
            if (cbResult == 0) {
                return null;
            }
            in.readShort();
            byte[] abResult = new byte[NSLookup.readPackedInt(in)];
            in.readFully(abResult);
            return new String(abResult);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] asArg) throws IOException {
        int cTimeoutMillis;
        int nTTL;
        int nPort;
        String sName;
        String sCluster;
        String sLocal;
        String sHost;
        try {
            String sPort;
            LinkedHashMap mapArgs = NSLookup.parseArguments(asArg, VALID_COMMANDS, true);
            sHost = (String)mapArgs.remove(COMMAND_HOST);
            sLocal = (String)mapArgs.remove(COMMAND_LOCAL);
            sCluster = (String)mapArgs.remove(COMMAND_CLUSTER);
            sName = (String)mapArgs.remove(COMMAND_NAME);
            if (sName == null) {
                sName = DEFAULT_NAME;
            }
            if (sHost == null) {
                sHost = DEFAULT_HOST;
            }
            nPort = (sPort = (String)mapArgs.remove(COMMAND_PORT)) == null ? 7574 : Integer.parseInt(sPort);
            String sTTL = (String)mapArgs.remove(COMMAND_TTL);
            nTTL = sTTL == null ? 4 : Integer.parseInt(sTTL);
            String sTimeoutSec = (String)mapArgs.remove(COMMAND_TIMEOUT);
            int n = cTimeoutMillis = sTimeoutSec == null ? 5000 : Integer.parseInt(sTimeoutSec) * 1000;
            if (!mapArgs.isEmpty()) {
                NSLookup.showInstructions();
                System.exit(1);
            }
        }
        catch (Throwable e) {
            System.err.println(e);
            System.err.println();
            NSLookup.showInstructions();
            System.exit(1);
            return;
        }
        Throwable ex = null;
        HashSet<InetAddress> setAddr = new HashSet<InetAddress>();
        if (sHost.equals("localhost")) {
            Enumeration<NetworkInterface> iterNics = NetworkInterface.getNetworkInterfaces();
            while (iterNics.hasMoreElements()) {
                Enumeration<InetAddress> iterAddr = iterNics.nextElement().getInetAddresses();
                while (iterAddr.hasMoreElements()) {
                    setAddr.add(iterAddr.nextElement());
                }
            }
        } else {
            Collections.addAll(setAddr, InetAddress.getAllByName(sHost));
        }
        for (InetAddress address : setAddr) {
            try {
                block27: {
                    InetSocketAddress socketAddr = new InetSocketAddress(address, nPort);
                    if (address.isMulticastAddress()) {
                        final String sClusterSearch = sCluster;
                        NSLookup.datagramLookup(sClusterSearch, NS_STRING_PREFIX + sName, socketAddr, sLocal == null ? null : InetAddress.getByName(sLocal), cTimeoutMillis, nTTL, null, new BiConsumer<String, String>(){

                            @Override
                            public void accept(String sClusterFound, String sResult) {
                                System.out.println((String)(sClusterSearch == null ? "Cluster " + sClusterFound + ":\t" + sResult : sResult));
                            }
                        });
                        continue;
                    }
                    try (Connection conn = Connection.open(sCluster, socketAddr, cTimeoutMillis);){
                        if (sCluster == null) {
                            StringTokenizer sTok = new StringTokenizer(conn.lookup("Cluster/name") + "," + conn.lookup("NameService/string/Cluster/foreign"), "[,]");
                            while (sTok.hasMoreElements()) {
                                sCluster = sTok.nextToken().trim();
                                Connection conn2 = Connection.open(sCluster, socketAddr, cTimeoutMillis);
                                try {
                                    System.out.println("Cluster " + sCluster + ":\t" + conn2.lookup(NS_STRING_PREFIX + sName));
                                }
                                finally {
                                    if (conn2 == null) continue;
                                    conn2.close();
                                }
                            }
                            break block27;
                        }
                        System.out.println(conn.lookup(NS_STRING_PREFIX + sName));
                    }
                }
                ex = null;
                break;
            }
            catch (IOException ioe) {
                ex = ioe;
            }
        }
        if (ex != null) {
            String sMsg = ex.getMessage();
            System.err.println("Error: " + (sMsg == null ? ex.getClass().getSimpleName() : sMsg) + "; while querying " + sHost + ":" + nPort + " for " + sName);
            System.exit(1);
        }
    }

    protected static void showInstructions() {
        String sClass = NSLookup.class.getCanonicalName();
        System.out.println();
        System.out.println("java " + sClass + " <commands ...>");
        System.out.println();
        System.out.println("command options:");
        System.out.println("\t-host    the cluster address (unicast or multicast); default 239.192.0.0");
        System.out.println("\t-local   the local IP to issue the request on when using multicast");
        System.out.println("\t-ttl     the TTL for multicast; default 4");
        System.out.println("\t-cluster the cluster; optional");
        System.out.println("\t-name    the name to lookup from the NameService; default Cluster/info");
        System.out.println("\t-port    the cluster port; default 7574");
        System.out.println("\t-timeout the timeout (in seconds) of the lookup request; default 5");
        System.out.println();
        System.out.println("Example:");
        System.out.println("\tjava " + sClass + " -host host.mycompany.com -name management/JMXServiceURL");
        System.out.println();
    }

    public static interface BiConsumer<T, U> {
        public void accept(T var1, U var2);
    }

    public static class Connection
    implements Closeable {
        final Socket socket = new Socket();
        final DataOutputStream outStream;
        final DataInputStream inStream;
        final byte[] abChan;

        protected Connection(SocketAddress socketAddr, int cTimeOutMillis) throws IOException {
            this.socket.setTcpNoDelay(true);
            this.socket.setSoTimeout(cTimeOutMillis);
            this.socket.connect(socketAddr, cTimeOutMillis);
            this.outStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.inStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.outStream.writeInt(1522655232);
            this.outStream.writeInt(3);
            NSLookup.write(this.outStream, CONN_OPEN);
            NSLookup.write(this.outStream, CHANNEL_OPEN);
            this.outStream.flush();
            NSLookup.read(this.inStream);
            byte[] aChanResponse = NSLookup.read(this.inStream);
            int cbChanId = aChanResponse.length - 9;
            this.abChan = Arrays.copyOfRange(aChanResponse, 8, 8 + cbChanId);
        }

        public static Connection open(String sCluster, SocketAddress socketAddr, int cTimeOutMillis) throws IOException {
            Connection connection = null;
            do {
                connection = new Connection(socketAddr, cTimeOutMillis);
                if (sCluster == null || sCluster.equals(connection.lookup("Cluster/name"))) continue;
                String sPort = connection.lookup("NameService/string/Cluster/foreign/" + sCluster + "/NameService/localPort");
                connection.close();
                connection = null;
                if (sPort == null) {
                    throw new IOException((String)(sCluster == null ? "no cluster could be located" : "cluster '" + sCluster + "' could not be located"));
                }
                socketAddr = new InetSocketAddress(((InetSocketAddress)socketAddr).getAddress(), (int)Integer.valueOf(sPort));
            } while (connection == null);
            return connection;
        }

        public String lookup(String sName) throws IOException {
            DataInputStream stream = this.lookupRaw(sName);
            return stream == null ? null : NSLookup.readString(stream);
        }

        public DataInputStream lookupRaw(String sName) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream reqStream = new DataOutputStream(baos);
            reqStream.write(this.abChan);
            reqStream.write(NS_LOOKUP_REQ_ID, 0, NS_LOOKUP_REQ_ID.length);
            byte[] abName = sName.getBytes("utf-8");
            NSLookup.writePackedInt(reqStream, abName.length);
            reqStream.write(abName, 0, abName.length);
            reqStream.write(64);
            reqStream.flush();
            NSLookup.write(this.outStream, baos.toByteArray());
            this.outStream.flush();
            byte[] aResponse = NSLookup.read(this.inStream);
            int nLen = aResponse.length;
            int nMinLen = this.abChan.length + 1;
            if (nLen <= nMinLen) {
                throw new EOFException("protocol error");
            }
            if (nLen == nMinLen + 7) {
                return null;
            }
            return new DataInputStream(new ByteArrayInputStream(aResponse, nMinLen, nLen - nMinLen - 1));
        }

        @Override
        public void close() throws IOException {
            this.socket.close();
        }
    }
}

