/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.locks.internal;

import com.oracle.coherence.concurrent.locks.LockOwner;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.Member;
import com.tangosol.net.ServiceInfo;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.UUID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;

public class ReadWriteLockHolder
implements ExternalizableLite,
PortableObject {
    private LockOwner m_writeLock;
    private final Set<LockOwner> m_setReadLocks = new HashSet<LockOwner>();

    public boolean isWriteLocked() {
        return this.m_writeLock != null;
    }

    public boolean isReadLocked() {
        return !this.m_setReadLocks.isEmpty();
    }

    public boolean isLocked() {
        return this.isWriteLocked() || this.isReadLocked();
    }

    public boolean isWriteLockedBy(LockOwner owner) {
        return this.isWriteLocked() && this.m_writeLock.equals(owner);
    }

    public boolean isWriteLockedByMember(UUID memberId) {
        return this.isWriteLocked() && this.m_writeLock.getMemberId().equals((Object)memberId);
    }

    public boolean isReadLockedBy(LockOwner owner) {
        return this.isReadLocked() && this.m_setReadLocks.contains(owner);
    }

    public boolean isReadLockedByMember(UUID memberId) {
        return this.isReadLocked() && this.m_setReadLocks.stream().anyMatch(lo -> lo.getMemberId().equals((Object)memberId));
    }

    public boolean isLockedBy(LockOwner owner) {
        return this.isWriteLockedBy(owner) || this.isReadLockedBy(owner);
    }

    public boolean isLockedByMember(UUID memberId) {
        return this.isWriteLockedByMember(memberId) || this.isReadLockedByMember(memberId);
    }

    public boolean isWriteLockedByClient() {
        return this.isWriteLocked() && this.m_writeLock.isClient();
    }

    public boolean lockWrite(LockOwner owner) {
        if (this.isWriteLockedBy(owner)) {
            return true;
        }
        if (this.isLocked()) {
            return false;
        }
        this.m_writeLock = owner;
        return true;
    }

    public boolean unlockWrite(LockOwner owner) {
        if (this.isWriteLockedBy(owner)) {
            this.m_writeLock = null;
            return true;
        }
        return false;
    }

    public boolean lockRead(LockOwner owner) {
        if (this.isReadLockedBy(owner)) {
            return true;
        }
        if (this.isWriteLockedBy(owner) || !this.isWriteLocked()) {
            this.m_setReadLocks.add(owner);
            return true;
        }
        return false;
    }

    public boolean unlockRead(LockOwner owner) {
        if (this.isReadLockedBy(owner)) {
            this.m_setReadLocks.remove(owner);
            return true;
        }
        return false;
    }

    public LockOwner getWriteLock() {
        return this.m_writeLock;
    }

    public Set<? extends LockOwner> getReadLocks() {
        return this.m_setReadLocks;
    }

    public int getReadLockCount() {
        return this.m_setReadLocks.size();
    }

    protected boolean removeLocksFor(UUID memberId) {
        boolean fModified = false;
        if (this.isWriteLockedByMember(memberId)) {
            this.m_writeLock = null;
            fModified = true;
        }
        fModified = this.removeLocksFor(this.m_setReadLocks, memberId) || fModified;
        return fModified;
    }

    private boolean removeLocksFor(Set<LockOwner> set, UUID memberId) {
        boolean fModified = false;
        Iterator<LockOwner> it = set.iterator();
        while (it.hasNext()) {
            LockOwner owner = it.next();
            if (!owner.getMemberId().equals((Object)memberId)) continue;
            it.remove();
            fModified = true;
        }
        return fModified;
    }

    protected boolean retainLocksFor(Set<UUID> setMemberIds) {
        boolean fModified = false;
        if (this.isWriteLocked() && !this.isWriteLockedByClient() && !setMemberIds.contains(this.m_writeLock.getMemberId())) {
            this.m_writeLock = null;
            fModified = true;
        }
        fModified = this.retainLocksFor(this.m_setReadLocks, setMemberIds) || fModified;
        return fModified;
    }

    private boolean retainLocksFor(Set<LockOwner> set, Set<UUID> setMemberIds) {
        boolean fModified = false;
        Iterator<LockOwner> it = set.iterator();
        while (it.hasNext()) {
            LockOwner owner = it.next();
            if (owner.isClient() || setMemberIds.contains(owner.getMemberId())) continue;
            it.remove();
            fModified = true;
        }
        return fModified;
    }

    public String toString() {
        return "ReadWriteLockHolder{writeLocked=" + this.isWriteLocked() + ", readLocked=" + this.isReadLocked() + ", writeLockOwner=" + String.valueOf(this.getWriteLock()) + ", readLocks=" + String.valueOf(this.getReadLocks()) + "}";
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_writeLock = (LockOwner)ExternalizableHelper.readObject((DataInput)in);
        ExternalizableHelper.readCollection((DataInput)in, this.m_setReadLocks, null);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_writeLock);
        ExternalizableHelper.writeCollection((DataOutput)out, this.m_setReadLocks);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_writeLock = (LockOwner)in.readObject(0);
        in.readCollection(1, this.m_setReadLocks);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, (Object)this.m_writeLock);
        out.writeCollection(1, this.m_setReadLocks);
    }

    public static class RemoveLocks
    implements InvocableMap.EntryProcessor<String, ReadWriteLockHolder, Void>,
    ExternalizableLite,
    PortableObject {
        protected UUID m_memberId;

        public RemoveLocks() {
        }

        public RemoveLocks(UUID memberId) {
            this.m_memberId = memberId;
        }

        public Void process(InvocableMap.Entry<String, ReadWriteLockHolder> entry) {
            ReadWriteLockHolder holder = (ReadWriteLockHolder)entry.getValue();
            if (this.m_memberId == null) {
                ServiceInfo info = ((BinaryEntry)entry).getContext().getCacheService().getInfo();
                Set setServiceMembers = info.getServiceMembers();
                Set<UUID> setValidMemberIds = setServiceMembers.stream().map(Member::getUuid).collect(Collectors.toSet());
                if (holder.retainLocksFor(setValidMemberIds)) {
                    entry.setValue((Object)holder);
                }
            } else if (holder.removeLocksFor(this.m_memberId)) {
                entry.setValue((Object)holder);
            }
            return null;
        }

        public void readExternal(DataInput in) throws IOException {
            this.m_memberId = (UUID)ExternalizableHelper.readObject((DataInput)in);
        }

        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_memberId);
        }

        public void readExternal(PofReader in) throws IOException {
            this.m_memberId = (UUID)in.readObject(0);
        }

        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, (Object)this.m_memberId);
        }
    }
}

