/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.locks;

import com.oracle.coherence.concurrent.locks.LockOwner;
import com.oracle.coherence.concurrent.locks.internal.ReadWriteLockHolder;
import com.tangosol.net.Member;
import com.tangosol.net.NamedMap;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.Processors;
import com.tangosol.util.listener.SimpleMapListener;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class RemoteReadWriteLock
implements ReadWriteLock {
    private final ReadLock f_readerLock;
    private final WriteLock f_writerLock;
    final Sync f_sync;

    RemoteReadWriteLock(String sName, NamedMap<String, ReadWriteLockHolder> locks) {
        this.f_sync = new Sync(sName, locks);
        this.f_readerLock = new ReadLock(this);
        this.f_writerLock = new WriteLock(this);
        locks.addMapListener((MapListener)new SimpleMapListener().addInsertHandler(this.f_sync::onHolderChange).addUpdateHandler(this.f_sync::onHolderChange), (Object)sName, false);
    }

    @Override
    public Lock readLock() {
        return this.f_readerLock;
    }

    @Override
    public Lock writeLock() {
        return this.f_writerLock;
    }

    public LockOwner getOwner() {
        return this.f_sync.getOwner();
    }

    public int getReadLockCount() {
        return this.f_sync.getReadLockCount();
    }

    public boolean isReadLocked() {
        return this.f_sync.isReadLocked();
    }

    public boolean isWriteLocked() {
        return this.f_sync.isWriteLocked();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.f_sync.isHeldExclusively();
    }

    public int getWriteHoldCount() {
        return this.f_sync.getWriteHoldCount();
    }

    public int getReadHoldCount() {
        return this.f_sync.getReadHoldCount();
    }

    public final boolean hasQueuedThreads() {
        return this.f_sync.hasQueuedThreads();
    }

    public final boolean hasQueuedThread(Thread thread) {
        return this.f_sync.isQueued(thread);
    }

    public final int getQueueLength() {
        return this.f_sync.getQueueLength();
    }

    public String toString() {
        int c = this.f_sync.getCount();
        int w = Sync.exclusiveCount(c);
        int r = Sync.sharedCount(c);
        return super.toString() + "[Write locks = " + w + ", Read locks = " + r + "]";
    }

    static class Sync
    extends AbstractQueuedSynchronizer {
        static final int SHARED_SHIFT = 16;
        static final int SHARED_UNIT = 65536;
        static final int MAX_COUNT = 65535;
        static final int EXCLUSIVE_MASK = 65535;
        private final Member f_localMember;
        private final String f_sName;
        private final NamedMap<String, ReadWriteLockHolder> f_locks;
        private final transient ThreadLocalHoldCounter readHolds;

        Sync(String sName, NamedMap<String, ReadWriteLockHolder> locks) {
            Member localMember = locks.getService().getCluster().getLocalMember();
            this.f_sName = sName;
            this.f_locks = locks;
            this.f_localMember = localMember;
            this.readHolds = new ThreadLocalHoldCounter();
            this.setState(this.getState());
        }

        @Override
        protected final boolean tryRelease(int releases) {
            Thread thread = Thread.currentThread();
            if (releases == -1) {
                if (thread == this.getExclusiveOwnerThread()) {
                    this.setExclusiveOwnerThread(null);
                }
                return true;
            }
            if (thread != this.getExclusiveOwnerThread()) {
                throw new IllegalMonitorStateException(String.valueOf(thread) + " != " + String.valueOf(this.getExclusiveOwnerThread()));
            }
            boolean fUnlocked = false;
            int c = this.getState() - releases;
            if (Sync.exclusiveCount(c) == 0) {
                LockOwner owner = new LockOwner(this.f_localMember, thread.getId());
                fUnlocked = (Boolean)this.f_locks.invoke((Object)this.f_sName, (InvocableMap.EntryProcessor & Serializable)entry -> {
                    ReadWriteLockHolder lock = (ReadWriteLockHolder)entry.getValue();
                    if (lock != null && lock.unlockWrite(owner)) {
                        entry.setValue((Object)lock);
                        return true;
                    }
                    return false;
                });
                if (fUnlocked) {
                    this.setExclusiveOwnerThread(null);
                } else {
                    throw new IllegalMonitorStateException();
                }
            }
            this.setState(c);
            return fUnlocked;
        }

        @Override
        protected final boolean tryAcquire(int acquires) {
            LockOwner owner;
            boolean fLocked;
            Thread thread = Thread.currentThread();
            if (acquires == -1) {
                this.setExclusiveOwnerThread(thread);
                return true;
            }
            int c = this.getState();
            int w = Sync.exclusiveCount(c);
            if (c != 0) {
                if (w == 0 || thread != this.getExclusiveOwnerThread()) {
                    return false;
                }
                if (w + Sync.exclusiveCount(acquires) > 65535) {
                    throw new Error("Maximum lock count exceeded");
                }
                this.setState(c + acquires);
                return true;
            }
            if (!this.writerShouldBlock() && (fLocked = ((Boolean)this.f_locks.invoke((Object)this.f_sName, arg_0 -> Sync.lambda$tryAcquire$da190f39$1(owner = new LockOwner(this.f_localMember, thread.getId()), arg_0))).booleanValue()) && this.compareAndSetState(c, c + acquires)) {
                this.setExclusiveOwnerThread(thread);
                return true;
            }
            return false;
        }

        @Override
        protected final boolean tryReleaseShared(int releases) {
            int cNext;
            int c;
            HoldCounter rh = (HoldCounter)this.readHolds.get();
            int count = rh.count;
            if (count <= 0) {
                throw new IllegalMonitorStateException("attempt to unlock read lock, not locked by current thread");
            }
            if (count <= 1) {
                this.readHolds.remove();
                Thread thread = Thread.currentThread();
                LockOwner owner = new LockOwner(this.f_localMember, thread.getId());
                boolean fUnlocked = (Boolean)this.f_locks.invoke((Object)this.f_sName, (InvocableMap.EntryProcessor & Serializable)entry -> {
                    ReadWriteLockHolder lock = (ReadWriteLockHolder)entry.getValue();
                    if (lock != null && lock.unlockRead(owner)) {
                        entry.setValue((Object)lock);
                        return true;
                    }
                    return false;
                });
                if (!fUnlocked) {
                    throw new IllegalMonitorStateException();
                }
            }
            --rh.count;
            while (!this.compareAndSetState(c = this.getState(), cNext = c - 65536)) {
            }
            return cNext == 0;
        }

        @Override
        protected final int tryAcquireShared(int unused) {
            return this.tryReadLock() ? 1 : -1;
        }

        final boolean tryReadLock() {
            HoldCounter rh;
            int c;
            Thread thread = Thread.currentThread();
            LockOwner owner = new LockOwner(this.f_localMember, thread.getId());
            boolean fLocked = false;
            do {
                c = this.getState();
                if (this.getExclusiveOwnerThread() != thread && (Sync.exclusiveCount(c) != 0 || this.readerShouldBlock())) {
                    return false;
                }
                int r = Sync.sharedCount(c);
                if (r == 65535) {
                    throw new Error("Maximum lock count exceeded");
                }
                rh = (HoldCounter)this.readHolds.get();
                if (rh.count != 0 || fLocked || (fLocked = ((Boolean)this.f_locks.invoke((Object)this.f_sName, (InvocableMap.EntryProcessor & Serializable)entry -> {
                    ReadWriteLockHolder lock = (ReadWriteLockHolder)entry.getValue(ReadWriteLockHolder::new);
                    boolean fRes = lock.lockRead(owner);
                    entry.setValue((Object)lock);
                    return fRes;
                })).booleanValue())) continue;
                this.readHolds.remove();
                return false;
            } while (!this.compareAndSetState(c, c + 65536));
            ++rh.count;
            return true;
        }

        boolean readerShouldBlock() {
            return this.hasQueuedPredecessors();
        }

        boolean writerShouldBlock() {
            return false;
        }

        @Override
        protected final boolean isHeldExclusively() {
            return this.getExclusiveOwnerThread() == Thread.currentThread();
        }

        private void onHolderChange(MapEvent<? extends String, ? extends ReadWriteLockHolder> event) {
            ReadWriteLockHolder holder = (ReadWriteLockHolder)event.getNewValue();
            if (holder.isWriteLocked() && !holder.isWriteLockedByMember(this.f_localMember.getUuid())) {
                this.acquire(-1);
            } else if (!holder.isWriteLocked()) {
                this.release(-1);
            }
        }

        final AbstractQueuedSynchronizer.ConditionObject newCondition() {
            throw new UnsupportedOperationException();
        }

        final LockOwner getOwner() {
            return (LockOwner)this.f_locks.invoke((Object)this.f_sName, Processors.extract(ReadWriteLockHolder::getWriteLock));
        }

        final int getReadLockCount() {
            return (Integer)this.f_locks.invoke((Object)this.f_sName, Processors.extract(ReadWriteLockHolder::getReadLockCount));
        }

        final boolean isReadLocked() {
            return (Boolean)this.f_locks.invoke((Object)this.f_sName, Processors.extract(ReadWriteLockHolder::isReadLocked));
        }

        final boolean isWriteLocked() {
            return (Boolean)this.f_locks.invoke((Object)this.f_sName, Processors.extract(ReadWriteLockHolder::isWriteLocked));
        }

        final int getWriteHoldCount() {
            return this.isHeldExclusively() ? Sync.exclusiveCount(this.getState()) : 0;
        }

        final int getReadHoldCount() {
            if (this.getReadLockCount() == 0) {
                return 0;
            }
            int count = ((HoldCounter)this.readHolds.get()).count;
            if (count == 0) {
                this.readHolds.remove();
            }
            return count;
        }

        final int getCount() {
            return this.getState();
        }

        static int sharedCount(int c) {
            return c >>> 16;
        }

        static int exclusiveCount(int c) {
            return c & 0xFFFF;
        }

        private static /* synthetic */ Boolean lambda$tryAcquire$da190f39$1(LockOwner owner, InvocableMap.Entry entry) {
            ReadWriteLockHolder lock = (ReadWriteLockHolder)entry.getValue(ReadWriteLockHolder::new);
            boolean fRes = lock.lockWrite(owner);
            entry.setValue((Object)lock);
            return fRes;
        }

        static final class ThreadLocalHoldCounter
        extends ThreadLocal<HoldCounter> {
            ThreadLocalHoldCounter() {
            }

            @Override
            public HoldCounter initialValue() {
                return new HoldCounter();
            }
        }

        static final class HoldCounter {
            int count;
            final long tid = Thread.currentThread().getId();

            HoldCounter() {
            }
        }
    }

    public static class ReadLock
    implements Lock {
        private final Sync f_sync;

        protected ReadLock(RemoteReadWriteLock lock) {
            this.f_sync = lock.f_sync;
        }

        @Override
        public void lock() {
            this.f_sync.acquireShared(1);
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.f_sync.acquireSharedInterruptibly(1);
        }

        @Override
        public boolean tryLock() {
            return this.f_sync.tryReadLock();
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            return this.f_sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
        }

        @Override
        public void unlock() {
            this.f_sync.releaseShared(1);
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            int r = this.f_sync.getReadLockCount();
            return super.toString() + "[Read locks = " + r + "]";
        }
    }

    public static class WriteLock
    implements Lock {
        private final Sync f_sync;

        protected WriteLock(RemoteReadWriteLock lock) {
            this.f_sync = lock.f_sync;
        }

        @Override
        public void lock() {
            this.f_sync.acquire(1);
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.f_sync.acquireInterruptibly(1);
        }

        @Override
        public boolean tryLock() {
            return this.f_sync.tryAcquire(1);
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            return this.f_sync.tryAcquireNanos(1, unit.toNanos(timeout));
        }

        @Override
        public void unlock() {
            this.f_sync.release(1);
        }

        @Override
        public Condition newCondition() {
            return this.f_sync.newCondition();
        }

        public String toString() {
            LockOwner o = this.f_sync.getOwner();
            return super.toString() + (String)(o == null ? "[Unlocked]" : "[Locked by " + String.valueOf(o) + "]");
        }

        public boolean isHeldByCurrentThread() {
            return this.f_sync.isHeldExclusively();
        }

        public int getHoldCount() {
            return this.f_sync.getWriteHoldCount();
        }
    }
}

