/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.util;

import com.oracle.coherence.concurrent.executor.function.Predicates;
import com.oracle.coherence.concurrent.executor.util.DayOfMonthPredicate;
import com.oracle.coherence.concurrent.executor.util.IntArrayPredicate;
import com.tangosol.util.function.Remote;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class CronPattern {
    protected static final ValueParser MINUTE_VALUE_PARSER = new MinuteValueParser();
    protected static final ValueParser HOUR_VALUE_PARSER = new HourValueParser();
    protected static final ValueParser DAY_OF_MONTH_VALUE_PARSER = new DayOfMonthValueParser();
    protected static final ValueParser MONTH_VALUE_PARSER = new MonthValueParser();
    protected static final ValueParser DAY_OF_WEEK_VALUE_PARSER = new DayOfWeekValueParser();
    protected final String f_sPattern;
    protected List<Remote.Predicate<?>> m_listMinuteMatchers = new ArrayList();
    protected List<Remote.Predicate<?>> m_listHourMatchers = new ArrayList();
    protected List<Remote.Predicate<?>> m_listDayOfMonthMatchers = new ArrayList();
    protected List<Remote.Predicate<?>> m_listMonthMatchers = new ArrayList();
    protected List<Remote.Predicate<?>> m_listDayOfWeekMatchers = new ArrayList();
    protected int m_cMatcherSize = 0;

    public CronPattern(String sPattern) throws IllegalArgumentException {
        this.f_sPattern = sPattern;
        StringTokenizer st1 = new StringTokenizer(sPattern, "|");
        if (st1.countTokens() < 1) {
            throw new IllegalArgumentException("invalid pattern: \"" + sPattern + "\"");
        }
        while (st1.hasMoreTokens()) {
            String sLocalPattern = st1.nextToken();
            StringTokenizer st2 = new StringTokenizer(sLocalPattern, " \t");
            if (st2.countTokens() != 5) {
                throw new IllegalArgumentException("invalid pattern: \"" + sLocalPattern + "\"");
            }
            try {
                this.m_listMinuteMatchers.add(this.buildPredicate(st2.nextToken(), MINUTE_VALUE_PARSER));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid pattern \"" + sLocalPattern + "\". Error parsing minutes field: " + e.getMessage() + ".");
            }
            try {
                this.m_listHourMatchers.add(this.buildPredicate(st2.nextToken(), HOUR_VALUE_PARSER));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid pattern \"" + sLocalPattern + "\". Error parsing hours field: " + e.getMessage() + ".");
            }
            try {
                this.m_listDayOfMonthMatchers.add(this.buildPredicate(st2.nextToken(), DAY_OF_MONTH_VALUE_PARSER));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid pattern \"" + sLocalPattern + "\". Error parsing days of month field: " + e.getMessage() + ".");
            }
            try {
                this.m_listMonthMatchers.add(this.buildPredicate(st2.nextToken(), MONTH_VALUE_PARSER));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid pattern \"" + sLocalPattern + "\". Error parsing months field: " + e.getMessage() + ".");
            }
            try {
                this.m_listDayOfWeekMatchers.add(this.buildPredicate(st2.nextToken(), DAY_OF_WEEK_VALUE_PARSER));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid pattern \"" + sLocalPattern + "\". Error parsing days of week field: " + e.getMessage() + ".");
            }
            ++this.m_cMatcherSize;
        }
    }

    public long getNextExecuteTime(TimeZone timezone, long cMillis) {
        ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(cMillis), timezone.toZoneId());
        int nMinute = zdt.getMinute();
        int nHour = zdt.getHour();
        int nDayOfMonth = zdt.getDayOfMonth();
        int nMonth = zdt.getMonth().getValue();
        int nDayOfWeek = zdt.getDayOfWeek().getValue();
        int nYear = zdt.getYear();
        for (int i = 0; i < this.m_cMatcherSize; ++i) {
            Remote.Predicate<?> monthMatcher;
            int nNextMonth;
            Remote.Predicate<?> minuteMatcher = this.m_listMinuteMatchers.get(i);
            int nextMinute = this.getNextMinute(nMinute, minuteMatcher);
            if (nextMinute > nMinute) {
                return zdt.withMinute(nextMinute).toInstant().toEpochMilli();
            }
            Remote.Predicate<?> hourMatcher = this.m_listHourMatchers.get(i);
            int nextHour = this.getNextHour(nHour, hourMatcher);
            if (nextHour > nHour) {
                return zdt.withMinute(nextMinute).withHour(nextHour).toInstant().toEpochMilli();
            }
            Remote.Predicate<?> dayOfMonthMatcher = this.m_listDayOfMonthMatchers.get(i);
            Remote.Predicate<?> dayOfWeekMatcher = this.m_listDayOfWeekMatchers.get(i);
            boolean fDayOfMonthSet = false;
            int nNextDayOfMonth = 0;
            if ((dayOfMonthMatcher instanceof Predicates.AlwaysPredicate && dayOfWeekMatcher instanceof Predicates.AlwaysPredicate || dayOfMonthMatcher instanceof IntArrayPredicate) && (nNextDayOfMonth = this.getNextDayOfMonth(zdt, dayOfMonthMatcher)) > nDayOfMonth) {
                if (dayOfWeekMatcher instanceof Predicates.AlwaysPredicate) {
                    return zdt.withMinute(nextMinute).withHour(nextHour).withDayOfMonth(nNextDayOfMonth).toInstant().toEpochMilli();
                }
                fDayOfMonthSet = true;
            }
            if (dayOfWeekMatcher instanceof IntArrayPredicate) {
                int cOffset;
                int nNextDayOfWeek = this.getNextDayOfWeek(nDayOfWeek, dayOfWeekMatcher);
                int n = cOffset = nNextDayOfWeek > nDayOfWeek ? nNextDayOfWeek - nDayOfWeek : nNextDayOfWeek + 7 - nDayOfWeek;
                if (fDayOfMonthSet) {
                    if (cOffset > nNextDayOfMonth - nDayOfMonth) {
                        cOffset = nNextDayOfMonth - nDayOfMonth;
                    }
                    return zdt.withMinute(nextMinute).withHour(nextHour).plusDays(cOffset).toInstant().toEpochMilli();
                }
                if (zdt.plusDays(cOffset).getDayOfMonth() > nDayOfMonth) {
                    return zdt.withMinute(nextMinute).withHour(nextHour).plusDays(cOffset).toInstant().toEpochMilli();
                }
                ZonedDateTime nextZdt = zdt.plusDays(cOffset);
                if (nNextDayOfMonth > 0) {
                    int nextDay = nextZdt.getDayOfMonth();
                    if (nextDay < nNextDayOfMonth) {
                        nNextDayOfMonth = nextDay;
                    }
                } else {
                    nNextDayOfMonth = nextZdt.getDayOfMonth();
                }
            }
            if ((nNextMonth = this.getNextMonth(nMonth, monthMatcher = this.m_listMonthMatchers.get(i))) > nMonth) {
                return zdt.withMinute(nextMinute).withHour(nextHour).withDayOfMonth(nNextDayOfMonth).withMonth(nNextMonth).toInstant().toEpochMilli();
            }
            int nextYear = nYear + 1;
            zdt = zdt.withMinute(nextMinute).withHour(nextHour).withDayOfMonth(nNextDayOfMonth).withMonth(nNextMonth).withYear(nextYear);
        }
        return zdt.toInstant().toEpochMilli();
    }

    public long getNextExecuteTime(long cMillis) {
        return this.getNextExecuteTime(TimeZone.getDefault(), cMillis);
    }

    public int getNextMinute(int nMinute, Remote.Predicate<?> predicate) {
        if (predicate instanceof Predicates.AlwaysPredicate) {
            return nMinute > 58 ? 0 : nMinute + 1;
        }
        return ((IntArrayPredicate)predicate).getNext(nMinute);
    }

    public int getNextHour(int nHour, Remote.Predicate<?> predicate) {
        if (predicate instanceof Predicates.AlwaysPredicate) {
            return nHour > 22 ? 0 : nHour + 1;
        }
        return ((IntArrayPredicate)predicate).getNext(nHour);
    }

    public int getNextDayOfMonth(ZonedDateTime zdt, Remote.Predicate<?> predicate) {
        if (predicate instanceof Predicates.AlwaysPredicate) {
            return zdt.toLocalDate().plusDays(1L).getDayOfMonth();
        }
        return ((IntArrayPredicate)predicate).getNext(zdt.getDayOfMonth());
    }

    public int getNextDayOfWeek(int nDayOfWeek, Remote.Predicate<?> predicate) {
        if (predicate instanceof Predicates.AlwaysPredicate) {
            return nDayOfWeek > 5 ? 0 : nDayOfWeek + 1;
        }
        return ((IntArrayPredicate)predicate).getNext(nDayOfWeek);
    }

    public int getNextMonth(int nMonth, Remote.Predicate<?> predicate) {
        if (predicate instanceof Predicates.AlwaysPredicate) {
            return nMonth > 11 ? 1 : nMonth + 1;
        }
        return ((IntArrayPredicate)predicate).getNext(nMonth);
    }

    public String toString() {
        return this.f_sPattern;
    }

    protected Remote.Predicate<?> buildPredicate(String sPattern, ValueParser parser) throws Exception {
        if (sPattern.length() == 1 && sPattern.charAt(0) == '*') {
            return Predicates.AlwaysPredicate.get();
        }
        ArrayList<Integer> listValues = new ArrayList<Integer>();
        StringTokenizer st = new StringTokenizer(sPattern, ",");
        while (st.hasMoreTokens()) {
            List<Integer> listLocal;
            String sElement = st.nextToken();
            try {
                listLocal = this.parseListElement(sElement, parser);
            }
            catch (Exception e) {
                throw new Exception("invalid field \"" + sPattern + "\", invalid element \"" + sElement + "\", " + e.getMessage());
            }
            for (Integer value : listLocal) {
                if (listValues.contains(value)) continue;
                listValues.add(value);
            }
        }
        if (listValues.isEmpty()) {
            throw new Exception("invalid field \"" + sPattern + "\"");
        }
        if (parser == DAY_OF_MONTH_VALUE_PARSER) {
            return new DayOfMonthPredicate(listValues);
        }
        return new IntArrayPredicate(listValues);
    }

    protected List<Integer> parseListElement(String sElement, ValueParser parser) throws Exception {
        List<Integer> listValues;
        StringTokenizer st = new StringTokenizer(sElement, "/");
        int cSize = st.countTokens();
        if (cSize < 1 || cSize > 2) {
            throw new Exception("syntax error");
        }
        try {
            listValues = this.parseRange(st.nextToken(), parser);
        }
        catch (Exception e) {
            throw new Exception("invalid range, " + e.getMessage());
        }
        if (cSize == 2) {
            int nDiv;
            String dStr = st.nextToken();
            try {
                nDiv = Integer.parseInt(dStr);
            }
            catch (NumberFormatException e) {
                throw new Exception("invalid divisor \"" + dStr + "\"");
            }
            if (nDiv < 1) {
                throw new Exception("non positive divisor \"" + nDiv + "\"");
            }
            ArrayList<Integer> listValues2 = new ArrayList<Integer>();
            for (int i = 0; i < listValues.size(); i += nDiv) {
                listValues2.add(listValues.get(i));
            }
            return listValues2;
        }
        return listValues;
    }

    protected List<Integer> parseRange(String sRange, ValueParser parser) throws Exception {
        int nV2;
        int nV1;
        if (sRange.length() == 1 && sRange.charAt(0) == '*') {
            int cMin = parser.getMinValue();
            int cMax = parser.getMaxValue();
            ArrayList<Integer> values = new ArrayList<Integer>();
            for (int i = cMin; i <= cMax; ++i) {
                values.add(i);
            }
            return values;
        }
        StringTokenizer st = new StringTokenizer(sRange, "-");
        int cSize = st.countTokens();
        if (cSize < 1 || cSize > 2) {
            throw new Exception("syntax error");
        }
        String v1Str = st.nextToken();
        try {
            nV1 = parser.parse(v1Str);
        }
        catch (Exception e) {
            throw new Exception("invalid value \"" + v1Str + "\", " + e.getMessage());
        }
        if (cSize == 1) {
            ArrayList<Integer> listValues = new ArrayList<Integer>();
            listValues.add(nV1);
            return listValues;
        }
        String v2Str = st.nextToken();
        try {
            nV2 = parser.parse(v2Str);
        }
        catch (Exception e) {
            throw new Exception("invalid value \"" + v2Str + "\", " + e.getMessage());
        }
        ArrayList<Integer> listValues = new ArrayList<Integer>();
        if (nV1 < nV2) {
            for (int i = nV1; i <= nV2; ++i) {
                listValues.add(i);
            }
        } else if (nV1 > nV2) {
            int i;
            int cMin = parser.getMinValue();
            int cMax = parser.getMaxValue();
            for (i = nV1; i <= cMax; ++i) {
                listValues.add(i);
            }
            for (i = cMin; i <= nV2; ++i) {
                listValues.add(i);
            }
        } else {
            listValues.add(nV1);
        }
        return listValues;
    }

    protected static int parseAlias(String sValue, String[] asAliases, int cOffset) throws Exception {
        for (int i = 0; i < asAliases.length; ++i) {
            if (!asAliases[i].equalsIgnoreCase(sValue)) continue;
            return cOffset + i;
        }
        throw new Exception("invalid alias \"" + sValue + "\"");
    }

    protected static interface ValueParser {
        public int parse(String var1) throws Exception;

        public int getMinValue();

        public int getMaxValue();
    }

    private static class MinuteValueParser
    extends SimpleValueParser {
        public MinuteValueParser() {
            super(0, 59);
        }
    }

    private static class HourValueParser
    extends SimpleValueParser {
        public HourValueParser() {
            super(0, 23);
        }
    }

    private static class DayOfMonthValueParser
    extends SimpleValueParser {
        public DayOfMonthValueParser() {
            super(1, 31);
        }

        @Override
        public int parse(String sValue) throws Exception {
            if (sValue.equalsIgnoreCase("L")) {
                return 32;
            }
            return super.parse(sValue);
        }
    }

    private static class MonthValueParser
    extends SimpleValueParser {
        private static final String[] ALIASES = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};

        public MonthValueParser() {
            super(1, 12);
        }

        @Override
        public int parse(String sValue) throws Exception {
            try {
                return super.parse(sValue);
            }
            catch (Exception e) {
                return CronPattern.parseAlias(sValue, ALIASES, 1);
            }
        }
    }

    private static class DayOfWeekValueParser
    extends SimpleValueParser {
        private static final String[] ALIASES = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};

        public DayOfWeekValueParser() {
            super(0, 7);
        }

        @Override
        public int parse(String sValue) throws Exception {
            try {
                return super.parse(sValue) % 7;
            }
            catch (Exception e) {
                return CronPattern.parseAlias(sValue, ALIASES, 0);
            }
        }
    }

    private static class SimpleValueParser
    implements ValueParser {
        protected int m_nMinValue;
        protected int m_nMaxValue;

        public SimpleValueParser(int minValue, int nMaxValue) {
            this.m_nMinValue = minValue;
            this.m_nMaxValue = nMaxValue;
        }

        @Override
        public int parse(String sValue) throws Exception {
            int i;
            try {
                i = Integer.parseInt(sValue);
            }
            catch (NumberFormatException e) {
                throw new Exception("invalid integer value");
            }
            if (i < this.m_nMinValue || i > this.m_nMaxValue) {
                throw new Exception("value out of range");
            }
            return i;
        }

        @Override
        public int getMinValue() {
            return this.m_nMinValue;
        }

        @Override
        public int getMaxValue() {
            return this.m_nMaxValue;
        }
    }
}

