/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.concurrent.executor.RemoteExecutor;
import com.oracle.coherence.concurrent.executor.Task;
import com.tangosol.io.ExternalizableLite;
import java.util.concurrent.ExecutorService;

public interface TaskExecutorService
extends RemoteExecutor {
    public Registration register(ExecutorService var1, Registration.Option ... var2);

    public Registration deregister(ExecutorService var1);

    public <T> Task.Orchestration<T> orchestrate(Task<T> var1);

    default public <T> Task.Coordinator<T> submit(Task<T> task) {
        return this.orchestrate(task).submit();
    }

    public <R> Task.Coordinator<R> acquire(String var1);

    public static interface Registration {
        public String getId();

        public <T extends Option> T getOption(Class<T> var1, T var2);

        public void close();

        public static interface Option
        extends ExternalizableLite {
        }
    }

    public static interface ExecutorInfo
    extends ExternalizableLite {
        public String getId();

        public State getState();

        public long getLastUpdateTime();

        public long getJoinTime();

        public long getMaxMemory();

        public long getTotalMemory();

        public long getFreeMemory();

        public <T extends Registration.Option> T getOption(Class<T> var1, T var2);

        public static enum State {
            JOINING,
            RUNNING,
            CLOSING_GRACEFULLY,
            CLOSING,
            CLOSED,
            REJECTING;


            public int getCode() {
                return this.ordinal() + 1;
            }
        }
    }
}

