/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.concurrent.executor.ExecutionPlan;
import com.oracle.coherence.concurrent.executor.ExecutionStrategy;
import com.oracle.coherence.concurrent.executor.MutableExecutionPlan;
import com.oracle.coherence.concurrent.executor.TaskExecutorService;
import com.oracle.coherence.concurrent.executor.internal.ExecutorTrace;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.function.Remote;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class StandardExecutionStrategy
implements ExecutionStrategy,
PortableObject {
    protected int m_cDesiredExecutors;
    protected Remote.Predicate<? super TaskExecutorService.ExecutorInfo> m_predicate;
    protected boolean m_fPerformConcurrently;
    protected static final AtomicInteger COUNTER = new AtomicInteger();

    public StandardExecutionStrategy() {
    }

    public StandardExecutionStrategy(int cDesiredExecutors, Remote.Predicate<? super TaskExecutorService.ExecutorInfo> predicate, boolean fConcurrentExecution) {
        this.m_cDesiredExecutors = cDesiredExecutors;
        this.m_predicate = predicate;
        this.m_fPerformConcurrently = fConcurrentExecution;
    }

    @Override
    public ExecutionPlan analyze(ExecutionPlan currentPlan, Map<String, ? extends TaskExecutorService.ExecutorInfo> mapExecutorInfo, EnumSet<ExecutionStrategy.EvaluationRationale> rationales) {
        Remote.Predicate<? super TaskExecutorService.ExecutorInfo> predicate = this.m_predicate;
        Map mapCandidates = mapExecutorInfo.values().stream().filter((Predicate<? extends TaskExecutorService.ExecutorInfo>)predicate).sorted((info1, info2) -> (int)(info1.getJoinTime() - info2.getJoinTime())).collect(Collectors.toMap(TaskExecutorService.ExecutorInfo::getId, Function.identity(), (x, y) -> y, LinkedHashMap::new));
        int cCandidateCount = mapCandidates.size();
        ExecutorTrace.log(() -> String.format("Executor candidates [%s]; current desired count [%s]", mapCandidates.keySet(), this.m_cDesiredExecutors));
        MutableExecutionPlan newPlan = new MutableExecutionPlan(currentPlan);
        int cPendingRecoveries = newPlan.getPendingRecoveryCount();
        ExecutorTrace.log(() -> String.format("Recovery count [%s]", newPlan.getPendingRecoveryCount()));
        Iterator<String> iterator = newPlan.getIds();
        while (iterator.hasNext()) {
            String sExecutorId = iterator.next();
            if (newPlan.getAction(sExecutorId).isEffectivelyAssigned() && mapCandidates.containsKey(sExecutorId)) {
                mapCandidates.remove(sExecutorId);
                continue;
            }
            if ((!newPlan.contains(sExecutorId) || mapCandidates.containsKey(sExecutorId)) && newPlan.getAction(sExecutorId) != ExecutionPlan.Action.REASSIGN) continue;
            newPlan.release(sExecutorId);
            ++cPendingRecoveries;
            mapCandidates.remove(sExecutorId);
        }
        int cEffectivelyAssigned = newPlan.count(ExecutionPlan.Action::isEffectivelyAssigned);
        ExecutorTrace.log(() -> String.format("Current effective assignment count [%s]", newPlan.count(ExecutionPlan.Action::isEffectivelyAssigned)));
        int cDesired = this.m_cDesiredExecutors < 0 ? cCandidateCount : this.m_cDesiredExecutors;
        ExecutorTrace.log(() -> String.format("Desired executor count (calculated) [%s]", cDesired));
        int cExtra = 0;
        if (this.m_fPerformConcurrently) {
            cExtra = Math.max(0, cDesired - cEffectivelyAssigned);
        } else if (cEffectivelyAssigned < cDesired && (rationales.contains((Object)ExecutionStrategy.EvaluationRationale.TASK_CREATED) || rationales.contains((Object)ExecutionStrategy.EvaluationRationale.TASK_RESULT_PROVIDED))) {
            cExtra = 1;
        }
        int cExtraFinal = cExtra;
        ExecutorTrace.log(() -> String.format("Additional executor required count [%s]", cExtraFinal));
        int cRemaining = mapCandidates.size();
        String[] asExecutorIds = mapCandidates.keySet().toArray(new String[cRemaining]);
        ExecutorTrace.log(() -> String.format("Remaining executor candidates [%s]", Arrays.toString(asExecutorIds)));
        while (cRemaining > 0 && cExtra > 0) {
            int len = asExecutorIds.length;
            for (int i = 0; i < len && cRemaining > 0 && cExtra > 0; --cExtra, --cRemaining, ++i) {
                String sExecutorId = asExecutorIds[COUNTER.incrementAndGet() % len];
                if (cPendingRecoveries > 0) {
                    newPlan.recover(sExecutorId);
                    --cPendingRecoveries;
                    continue;
                }
                newPlan.assign(sExecutorId);
            }
        }
        cEffectivelyAssigned = newPlan.count(ExecutionPlan.Action::isEffectivelyAssigned);
        ExecutorTrace.log(() -> String.format("Effective candidate count [%s]", newPlan.count(ExecutionPlan.Action::isEffectivelyAssigned)));
        newPlan.setSatisfied(cEffectivelyAssigned == cDesired && cEffectivelyAssigned > 0);
        newPlan.setPendingRecoveryCount(Math.max(cPendingRecoveries, 0));
        return newPlan;
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_cDesiredExecutors = ExternalizableHelper.readInt((DataInput)in);
        this.m_predicate = (Remote.Predicate)ExternalizableHelper.readObject((DataInput)in);
        this.m_fPerformConcurrently = in.readBoolean();
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.m_cDesiredExecutors);
        ExternalizableHelper.writeObject((DataOutput)out, this.m_predicate);
        out.writeBoolean(this.m_fPerformConcurrently);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_cDesiredExecutors = in.readInt(0);
        this.m_predicate = (Remote.Predicate)in.readObject(1);
        this.m_fPerformConcurrently = in.readBoolean(2);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_cDesiredExecutors);
        out.writeObject(1, this.m_predicate);
        out.writeBoolean(2, this.m_fPerformConcurrently);
    }
}

