/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent;

import com.oracle.coherence.concurrent.LocalSemaphore;
import com.oracle.coherence.concurrent.RemoteSemaphore;
import com.oracle.coherence.concurrent.config.ConcurrentServicesSessionConfiguration;
import com.oracle.coherence.concurrent.internal.SemaphoreStatus;
import com.tangosol.net.Coherence;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import com.tangosol.util.InvocableMap;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Semaphores {
    public static final String SESSION_NAME = ConcurrentServicesSessionConfiguration.SESSION_NAME;
    private static final Map<String, RemoteSemaphore> f_mapSemaphores = new ConcurrentHashMap<String, RemoteSemaphore>();
    private static final Map<String, LocalSemaphore> f_mapLocalSemaphores = new ConcurrentHashMap<String, LocalSemaphore>();

    public static RemoteSemaphore remoteSemaphore(String sName, int permits) {
        NamedMap<String, SemaphoreStatus> map = Semaphores.semaphoresMap();
        return f_mapSemaphores.compute(sName, (k, v) -> {
            if (v == null) {
                int existingInitialPermits = (Integer)map.invoke((Object)sName, (InvocableMap.EntryProcessor & Serializable)entry -> {
                    if (entry.isPresent()) {
                        return ((SemaphoreStatus)entry.getValue()).getInitialPermits();
                    }
                    entry.setValue((Object)new SemaphoreStatus(permits));
                    return permits;
                });
                if (existingInitialPermits != permits) {
                    throw new IllegalArgumentException("The semaphore " + sName + " with a different initial number of permits " + existingInitialPermits + " already exists.");
                }
                return new RemoteSemaphore((String)k, permits, map);
            }
            if (v.getInitialPermits() != permits) {
                throw new IllegalArgumentException("The semaphore " + sName + " with a different initial number of permits " + v.getInitialPermits() + " already exists.");
            }
            return v;
        });
    }

    public static LocalSemaphore localSemaphore(String sName, int cPermits) {
        return f_mapLocalSemaphores.computeIfAbsent(sName, n -> new LocalSemaphore(cPermits));
    }

    static void clear() {
        f_mapLocalSemaphores.clear();
        f_mapSemaphores.clear();
        Semaphores.semaphoresMap().clear();
    }

    public static NamedMap<String, SemaphoreStatus> semaphoresMap() {
        return Semaphores.session().getMap("semaphores", new NamedMap.Option[0]);
    }

    protected static Session session() {
        return (Session)Coherence.findSession((String)SESSION_NAME).orElseThrow(() -> new IllegalStateException(String.format("The session '%s' has not been initialized", SESSION_NAME)));
    }
}

