/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.concurrent.executor.NamedClusteredExecutorService;
import com.oracle.coherence.concurrent.executor.options.Name;
import com.tangosol.util.function.Remote;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public interface RemoteExecutor {
    public static final String DEFAULT_EXECUTOR_NAME = "coherence-concurrent-default-executor";

    public ScheduledFuture<?> schedule(Remote.Runnable var1, long var2, TimeUnit var4);

    public <V> ScheduledFuture<V> schedule(Remote.Callable<V> var1, long var2, TimeUnit var4);

    public ScheduledFuture<?> scheduleAtFixedRate(Remote.Runnable var1, long var2, long var4, TimeUnit var6);

    public ScheduledFuture<?> scheduleWithFixedDelay(Remote.Runnable var1, long var2, long var4, TimeUnit var6);

    public <T> List<Future<T>> invokeAll(Collection<? extends Remote.Callable<T>> var1) throws InterruptedException;

    public <T> List<Future<T>> invokeAll(Collection<? extends Remote.Callable<T>> var1, long var2, TimeUnit var4) throws InterruptedException;

    public <T> T invokeAny(Collection<? extends Remote.Callable<T>> var1) throws InterruptedException, ExecutionException;

    public <T> T invokeAny(Collection<? extends Remote.Callable<T>> var1, long var2, TimeUnit var4) throws InterruptedException, ExecutionException, TimeoutException;

    public <T> Future<T> submit(Remote.Callable<T> var1);

    public <T> Future<T> submit(Remote.Runnable var1, T var2);

    public Future<?> submit(Remote.Runnable var1);

    public void execute(Remote.Runnable var1);

    public boolean isShutdown();

    public boolean isTerminated();

    public boolean awaitTermination(long var1, TimeUnit var3) throws InterruptedException;

    public void shutdown();

    public List<Runnable> shutdownNow();

    public static RemoteExecutor get(String sName) {
        Objects.requireNonNull(sName, "sName argument must not be null");
        if (sName.isEmpty()) {
            throw new IllegalArgumentException("sName cannot be zero-length");
        }
        return new NamedClusteredExecutorService(Name.of(sName));
    }

    public static RemoteExecutor getDefault() {
        return RemoteExecutor.get(DEFAULT_EXECUTOR_NAME);
    }
}

