/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.concurrent.executor.ClusteredTaskManager;
import com.oracle.coherence.concurrent.executor.PortableAbstractProcessor;
import com.oracle.coherence.concurrent.executor.Task;
import com.oracle.coherence.concurrent.executor.TaskProperties;
import com.oracle.coherence.concurrent.executor.internal.ExecutorTrace;
import com.oracle.coherence.concurrent.executor.util.Caches;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.KeyAssociation;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class ClusteredProperties
implements Task.Properties,
ExternalizableLite,
PortableObject {
    protected String m_sTaskId;
    protected CacheService m_service;

    public ClusteredProperties() {
    }

    public ClusteredProperties(String sTaskId, CacheService service) {
        this.m_sTaskId = sTaskId;
        this.m_service = service;
    }

    public ClusteredProperties(String sTaskId, CacheService service, TaskProperties properties) {
        this.m_sTaskId = sTaskId;
        this.m_service = service;
        NamedCache propertyCache = Caches.properties(service);
        Iterator iterator = properties.getProperties().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            propertyCache.put(new PropertyKey<Serializable>(sTaskId, (Serializable)entry.getKey()), new PropertyValue<Serializable>(sTaskId, (Serializable)entry.getValue()));
        }
    }

    @Override
    public <V extends Serializable> V get(String sKey) {
        if (this.m_service != null) {
            NamedCache propertyCache = Caches.properties(this.getCacheService());
            PropertyValue value = (PropertyValue)propertyCache.get(new PropertyKey<String>(this.m_sTaskId, sKey));
            return value == null ? null : (V)value.getValue();
        }
        return null;
    }

    @Override
    public <V extends Serializable> V put(String sKey, V value) {
        if (this.m_service != null) {
            NamedCache propertyCache = Caches.properties(this.getCacheService());
            PropertyValue oldValue = (PropertyValue)propertyCache.invoke(new PropertyKey<String>(this.m_sTaskId, sKey), new SetPropertyValueProcessor(new PropertyValue<V>(this.m_sTaskId, value)));
            return oldValue == null ? null : (V)oldValue.getValue();
        }
        Logger.warn((String)"Failed to put a property; the cache service is null.");
        return null;
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_sTaskId = ExternalizableHelper.readUTF((DataInput)in);
        this.m_service = (CacheService)ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeUTF((DataOutput)out, (String)this.m_sTaskId);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_service);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_sTaskId = in.readString(0);
        this.m_service = (CacheService)in.readObject(1);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(0, this.m_sTaskId);
        out.writeObject(1, (Object)this.m_service);
    }

    protected CacheService getCacheService() {
        return this.m_service;
    }

    public static class PropertyKey<T extends Serializable>
    implements ExternalizableLite,
    KeyAssociation<String>,
    PortableObject {
        protected String m_sTaskId;
        protected T m_oKey;

        public PropertyKey() {
        }

        public PropertyKey(String sTaskId, T oKey) {
            this.m_sTaskId = sTaskId;
            this.m_oKey = oKey;
        }

        public String getAssociatedKey() {
            return this.m_sTaskId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyKey that = (PropertyKey)o;
            if (!Objects.equals(this.m_sTaskId, that.m_sTaskId)) {
                return false;
            }
            return Objects.equals(this.m_oKey, that.m_oKey);
        }

        public int hashCode() {
            int result = this.m_sTaskId != null ? this.m_sTaskId.hashCode() : 0;
            result = 31 * result + (this.m_oKey != null ? this.m_oKey.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.m_sTaskId + ":" + this.m_oKey;
        }

        public String getTaskId() {
            return this.m_sTaskId;
        }

        public T getKey() {
            return this.m_oKey;
        }

        public void readExternal(DataInput in) throws IOException {
            this.m_sTaskId = ExternalizableHelper.readUTF((DataInput)in);
            this.m_oKey = (Serializable)ExternalizableHelper.readObject((DataInput)in);
        }

        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeUTF((DataOutput)out, (String)this.m_sTaskId);
            ExternalizableHelper.writeObject((DataOutput)out, this.m_oKey);
        }

        public void readExternal(PofReader in) throws IOException {
            this.m_sTaskId = in.readString(0);
            this.m_oKey = (Serializable)in.readObject(1);
        }

        public void writeExternal(PofWriter out) throws IOException {
            out.writeString(0, this.m_sTaskId);
            out.writeObject(1, this.m_oKey);
        }
    }

    public static class PropertyValue<T extends Serializable>
    implements ExternalizableLite,
    PortableObject {
        protected String m_sTaskId;
        protected T m_oValue;

        public PropertyValue() {
        }

        public PropertyValue(String sTaskId, T oValue) {
            this.m_sTaskId = sTaskId;
            this.m_oValue = oValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyValue that = (PropertyValue)o;
            if (!Objects.equals(this.m_sTaskId, that.m_sTaskId)) {
                return false;
            }
            return Objects.equals(this.m_oValue, that.m_oValue);
        }

        public int hashCode() {
            int result = this.m_sTaskId != null ? this.m_sTaskId.hashCode() : 0;
            result = 31 * result + (this.m_oValue != null ? this.m_oValue.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.m_sTaskId + ":" + this.m_oValue;
        }

        public String getTaskId() {
            return this.m_sTaskId;
        }

        public T getValue() {
            return this.m_oValue;
        }

        public void readExternal(DataInput in) throws IOException {
            this.m_sTaskId = ExternalizableHelper.readUTF((DataInput)in);
            this.m_oValue = (Serializable)ExternalizableHelper.readObject((DataInput)in);
        }

        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeUTF((DataOutput)out, (String)this.m_sTaskId);
            ExternalizableHelper.writeObject((DataOutput)out, this.m_oValue);
        }

        public void readExternal(PofReader in) throws IOException {
            this.m_sTaskId = in.readString(0);
            this.m_oValue = (Serializable)in.readObject(1);
        }

        public void writeExternal(PofWriter out) throws IOException {
            out.writeString(0, this.m_sTaskId);
            out.writeObject(1, this.m_oValue);
        }
    }

    public static class SetPropertyValueProcessor<K extends Serializable, V extends Serializable>
    extends PortableAbstractProcessor<PropertyKey<K>, PropertyValue<V>, PropertyValue<V>>
    implements ExternalizableLite {
        protected PropertyValue<V> m_oValue;

        public SetPropertyValueProcessor() {
        }

        public SetPropertyValueProcessor(PropertyValue<V> oValue) {
            this.m_oValue = oValue;
        }

        public PropertyValue<V> process(InvocableMap.Entry<PropertyKey<K>, PropertyValue<V>> entry) {
            String sTaskId = ((PropertyKey)entry.getKey()).getTaskId();
            ClusteredTaskManager manager = null;
            ExecutorTrace.entering(SetPropertyValueProcessor.class, "process", sTaskId);
            BinaryEntry managerEntry = ((BinaryEntry)entry).getAssociatedEntry(Caches.TASKS_CACHE_NAME, (Object)sTaskId);
            PropertyValue result = null;
            if (managerEntry != null) {
                manager = (ClusteredTaskManager)managerEntry.getValue();
            }
            if (manager != null && !manager.isCompleted()) {
                if (entry.isPresent()) {
                    result = (PropertyValue)entry.getValue();
                }
                entry.setValue(this.m_oValue);
            } else {
                ExecutorTrace.log(() -> String.format("Ignoring attempt to set property [%s] for task [%s] as it has been completed or no longer exists", this.m_oValue, sTaskId));
            }
            ExecutorTrace.exiting(SetPropertyValueProcessor.class, "process", (Object)sTaskId, new Object[0]);
            return result;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_oValue = (PropertyValue)in.readObject(0);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, this.m_oValue);
        }

        public void readExternal(DataInput in) throws IOException {
            this.m_oValue = (PropertyValue)ExternalizableHelper.readObject((DataInput)in);
        }

        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject((DataOutput)out, this.m_oValue);
        }
    }
}

