/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.concurrent.executor.ExecutionStrategy;
import com.oracle.coherence.concurrent.executor.ExecutionStrategyBuilder;
import com.oracle.coherence.concurrent.executor.Task;
import com.oracle.coherence.concurrent.executor.TaskExecutorService;
import com.oracle.coherence.concurrent.executor.TaskProperties;
import com.oracle.coherence.concurrent.executor.util.OptionsByType;
import com.tangosol.util.function.Remote;
import java.io.Serializable;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;

public abstract class AbstractOrchestration<T, C extends TaskExecutorService>
implements Task.Orchestration<T> {
    protected C m_taskExecutorService;
    protected Task<T> m_task;
    protected String m_sTaskId;
    protected ExecutionStrategyBuilder m_strategyBuilder;
    protected ExecutionStrategy m_strategy;
    protected OptionsByType<Task.Option> m_optionsByType;
    protected Task.Properties m_properties;
    protected Duration m_retainDuration;
    protected Set<Task.Subscriber<? super T>> m_setSubscribers;

    public AbstractOrchestration(C taskExecutorService, Task<T> task) {
        this.m_taskExecutorService = taskExecutorService;
        this.m_task = task;
        this.m_sTaskId = null;
        this.m_strategyBuilder = new ExecutionStrategyBuilder();
        this.m_strategy = null;
        this.m_optionsByType = OptionsByType.empty();
        this.m_properties = null;
        this.m_retainDuration = null;
        this.m_setSubscribers = new HashSet<Task.Subscriber<? super T>>();
    }

    @Override
    public Task.Orchestration<T> concurrently() {
        this.m_strategyBuilder.concurrently();
        return this;
    }

    @Override
    public Task.Orchestration<T> sequentially() {
        this.m_strategyBuilder.sequentially();
        return this;
    }

    @Override
    public Task.Orchestration<T> filter(Remote.Predicate<? super TaskExecutorService.ExecutorInfo> predicate) {
        this.m_strategyBuilder.filter(predicate);
        return this;
    }

    @Override
    public Task.Orchestration<T> limit(int cLimit) {
        this.m_strategyBuilder.limit(cLimit);
        return this;
    }

    @Override
    public Task.Orchestration<T> as(String taskId) {
        this.m_sTaskId = taskId == null ? null : taskId.trim();
        return this;
    }

    @Override
    public Task.Orchestration<T> with(Task.Option ... options) {
        this.m_optionsByType = OptionsByType.from(Task.Option.class, options, new Task.Option[0]);
        return this;
    }

    @Override
    public Task.Orchestration<T> retain(Duration duration) {
        this.m_retainDuration = duration;
        return this;
    }

    @Override
    public Task.SubscribedOrchestration<T> subscribe(Task.Subscriber<? super T> subscriber) {
        this.m_setSubscribers.add(subscriber);
        return this;
    }

    @Override
    public Task.Coordinator<T> submit() {
        Task.Collectable<T, T> collectable = this.collect();
        for (Task.Subscriber<? super T> subscriber : this.m_setSubscribers) {
            collectable.subscribe(subscriber);
        }
        return collectable.submit();
    }

    @Override
    public <V extends Serializable> Task.Orchestration<T> define(String sName, V value) {
        if (this.m_properties == null) {
            this.m_properties = this.getPropertiesSupplier().get();
        }
        this.m_properties.put(sName, value);
        return this;
    }

    protected abstract Task.Collectable<T, T> collect();

    public C getTaskExecutorService() {
        return this.m_taskExecutorService;
    }

    public Task<T> getTask() {
        return this.m_task;
    }

    public String getTaskId() {
        return this.m_sTaskId;
    }

    public ExecutionStrategy getAssignmentStrategy() {
        if (this.m_strategy == null) {
            this.m_strategy = this.m_strategyBuilder.build();
        }
        return this.m_strategy;
    }

    public OptionsByType<Task.Option> getOptionsByType() {
        return this.m_optionsByType;
    }

    public Task.Properties getProperties() {
        return this.m_properties;
    }

    public Duration getRetainDuration() {
        return this.m_retainDuration;
    }

    protected Supplier<Task.Properties> getPropertiesSupplier() {
        return TaskProperties::new;
    }
}

