/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.atomic.internal.cdi;

import com.oracle.coherence.cdi.Name;
import com.oracle.coherence.cdi.Remote;
import com.oracle.coherence.concurrent.atomic.AsyncAtomicReference;
import com.oracle.coherence.concurrent.atomic.AsyncLocalAtomicReference;
import com.oracle.coherence.concurrent.atomic.AsyncRemoteAtomicReference;
import com.oracle.coherence.concurrent.atomic.Atomics;
import com.oracle.coherence.concurrent.atomic.LocalAtomicReference;
import com.oracle.coherence.concurrent.atomic.RemoteAtomicReference;
import com.oracle.coherence.concurrent.atomic.internal.cdi.AbstractAtomicProducer;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.InjectionPoint;

@ApplicationScoped
public class AsyncAtomicReferenceProducer
extends AbstractAtomicProducer {
    @Produces
    @Name(value="")
    @Remote
    <V> AsyncAtomicReference<V> getAtomicReference(InjectionPoint ip) {
        if (ip.getQualifiers().contains(Remote.Literal.INSTANCE)) {
            return this.getRemoteAtomicReference(ip);
        }
        return this.getLocalAtomicReference(ip);
    }

    @Produces
    <V> AsyncLocalAtomicReference<V> getUnqualifiedLocalAtomicReference(InjectionPoint ip) {
        return this.getLocalAtomicReference(ip);
    }

    @Produces
    @Name(value="")
    @Typed(value={AsyncLocalAtomicReference.class})
    <V> AsyncLocalAtomicReference<V> getLocalAtomicReference(InjectionPoint ip) {
        LocalAtomicReference ref = Atomics.localAtomicReference(this.getName(ip));
        return ref.async();
    }

    @Produces
    @Typed(value={AsyncRemoteAtomicReference.class})
    <V> AsyncRemoteAtomicReference<V> getUnqualifiedRemoteAtomicReference(InjectionPoint ip) {
        return this.getRemoteAtomicReference(ip);
    }

    @Produces
    @Name(value="")
    @Typed(value={AsyncRemoteAtomicReference.class})
    <V> AsyncRemoteAtomicReference<V> getRemoteAtomicReference(InjectionPoint ip) {
        RemoteAtomicReference ref = Atomics.remoteAtomicReference(this.getName(ip));
        return ref.async();
    }
}

