/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.internal;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.concurrent.executor.ClusteredRegistration;
import com.oracle.coherence.concurrent.executor.options.Debugging;
import java.util.function.Supplier;

public class ExecutorTrace {
    public static final int LOGLEVEL = 7;

    public static boolean isEnabled(int nSeverity) {
        return ClusteredRegistration.s_fTraceLogging && Logger.isEnabled((int)nSeverity);
    }

    public static void log(String message) {
        ExecutorTrace.log(message, 7);
    }

    public static void log(String message, Debugging debugging) {
        Logger.log((String)message, (int)debugging.getLogLevel());
    }

    public static void log(String message, int nSeverity) {
        if (ExecutorTrace.isEnabled(nSeverity)) {
            Logger.log((String)message, (int)nSeverity);
        }
    }

    public static void log(Supplier<String> supplierMessage) {
        ExecutorTrace.log(supplierMessage, 7);
    }

    public static void log(Supplier<String> supplierMessage, Debugging debugging) {
        Logger.log(supplierMessage, (int)debugging.getLogLevel());
    }

    public static void log(Supplier<String> supplierMessage, int nSeverity) {
        if (ExecutorTrace.isEnabled(nSeverity)) {
            Logger.log(supplierMessage, (int)nSeverity);
        }
    }
}

