/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.config.builders;

import com.oracle.coherence.concurrent.config.NamedExecutorService;
import com.oracle.coherence.concurrent.config.builders.AbstractExecutorBuilder;
import com.tangosol.coherence.config.ParameterList;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.ParameterResolver;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;

public class WorkStealingBuilder
extends AbstractExecutorBuilder<NamedExecutorService> {
    protected Expression<Integer> m_parallelism;

    public NamedExecutorService realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
        String sName = (String)this.m_name.evaluate(resolver);
        int nParallelism = this.m_parallelism == null ? Runtime.getRuntime().availableProcessors() : ((Integer)this.m_parallelism.evaluate(resolver)).intValue();
        Supplier<ExecutorService> supplier = () -> Executors.newWorkStealingPool(nParallelism);
        NamedExecutorService service = new NamedExecutorService(sName, this.description(nParallelism), supplier);
        this.register(service);
        return service;
    }

    @Injectable(value="parallelism")
    public void setParallelism(Expression<Integer> parallelism) {
        this.m_parallelism = parallelism;
    }

    protected String description(int nParallelism) {
        return String.format("WorkStealingThreadPool(Parallelism=%s)", nParallelism);
    }
}

