/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.concurrent.executor.ExecutionPlan;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;

public class MutableExecutionPlan
implements ExecutionPlan,
PortableObject {
    protected LinkedHashMap<String, ExecutionPlan.Action> m_mapActions = new LinkedHashMap();
    protected boolean m_fSatisfied = false;
    protected int m_cPendingRecoveryCount = 0;

    public MutableExecutionPlan() {
    }

    public MutableExecutionPlan(ExecutionPlan executionPlan) {
        this();
        if (executionPlan != null) {
            Iterator<String> iterator = executionPlan.getIds();
            while (iterator.hasNext()) {
                String sId = iterator.next();
                ExecutionPlan.Action action = executionPlan.getAction(sId);
                this.m_mapActions.put(sId, action);
            }
            this.m_fSatisfied = executionPlan.isSatisfied();
            this.m_cPendingRecoveryCount = executionPlan.getPendingRecoveryCount();
        }
    }

    public void setPendingRecoveryCount(int cPendingRecoveryCount) {
        this.m_cPendingRecoveryCount = cPendingRecoveryCount;
    }

    public void assign(String sId) {
        this.m_mapActions.put(sId, ExecutionPlan.Action.ASSIGN);
    }

    public void recover(String sId) {
        this.m_mapActions.put(sId, ExecutionPlan.Action.RECOVER);
    }

    public void release(String sId) {
        this.m_mapActions.put(sId, ExecutionPlan.Action.RELEASE);
    }

    public boolean contains(String sId) {
        return this.m_mapActions.containsKey(sId);
    }

    public void setSatisfied(boolean fSatisfied) {
        this.m_fSatisfied = fSatisfied;
    }

    @Override
    public ExecutionPlan.Action getAction(String sId) {
        return this.m_mapActions.get(sId);
    }

    @Override
    public boolean setAction(String sId, ExecutionPlan.Action action) {
        if (this.m_mapActions.get(sId) != action) {
            this.m_mapActions.put(sId, action);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.m_mapActions.size();
    }

    @Override
    public int count(Predicate<? super ExecutionPlan.Action> predicate) {
        return (int)this.m_mapActions.values().stream().filter(predicate).count();
    }

    @Override
    public boolean isSatisfied() {
        return this.m_fSatisfied;
    }

    @Override
    public int getPendingRecoveryCount() {
        return this.m_cPendingRecoveryCount;
    }

    @Override
    public boolean optimize() {
        boolean fChanged = false;
        Iterator<Map.Entry<String, ExecutionPlan.Action>> iterator = this.m_mapActions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ExecutionPlan.Action> entry = iterator.next();
            if (entry.getValue() != ExecutionPlan.Action.RELEASE) continue;
            iterator.remove();
            fChanged = true;
        }
        return fChanged;
    }

    @Override
    public Iterator<String> getIds() {
        return this.m_mapActions.keySet().iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ExecutionPlan{");
        builder.append("satisfied=");
        builder.append(this.m_fSatisfied);
        builder.append(", actions=[");
        boolean first = true;
        for (String executorServiceId : this.m_mapActions.keySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("(");
            builder.append(executorServiceId);
            builder.append(",");
            builder.append((Object)this.m_mapActions.get(executorServiceId));
            builder.append(")");
        }
        builder.append("]}");
        return builder.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MutableExecutionPlan)) {
            return false;
        }
        MutableExecutionPlan that = (MutableExecutionPlan)other;
        if (this.m_fSatisfied != that.m_fSatisfied) {
            return false;
        }
        return this.m_mapActions.equals(that.m_mapActions);
    }

    public int hashCode() {
        int result = this.m_mapActions.hashCode();
        result = 31 * result + (this.m_fSatisfied ? 1 : 0);
        return result;
    }

    public void readExternal(DataInput in) throws IOException {
        ExternalizableHelper.readMap((DataInput)in, this.m_mapActions, null);
        this.m_fSatisfied = in.readBoolean();
        this.m_cPendingRecoveryCount = ExternalizableHelper.readInt((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeMap((DataOutput)out, this.m_mapActions);
        out.writeBoolean(this.m_fSatisfied);
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.m_cPendingRecoveryCount);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_mapActions = (LinkedHashMap)in.readMap(0, this.m_mapActions);
        this.m_fSatisfied = in.readBoolean(1);
        this.m_cPendingRecoveryCount = in.readInt(2);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeMap(0, this.m_mapActions);
        out.writeBoolean(1, this.m_fSatisfied);
        out.writeInt(2, this.m_cPendingRecoveryCount);
    }
}

