/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.util;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.base.Objects;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Stack;

public class OptionsByType<T>
implements Externalizable,
PortableObject {
    protected LinkedHashMap<Class<? extends T>, T> m_mapOptionsByType;
    protected Class<T> m_clzOfOption;

    public OptionsByType() {
    }

    private OptionsByType(Class<T> clzOfOption) {
        this.m_mapOptionsByType = new LinkedHashMap();
        this.m_clzOfOption = clzOfOption;
    }

    private OptionsByType(Class<T> clzOfOptions, T[] options) {
        this.m_mapOptionsByType = new LinkedHashMap();
        this.m_clzOfOption = clzOfOptions;
        this.addAll(options);
    }

    public <U extends T> U get(Class<U> clzOfOption) {
        return this.get(clzOfOption, this.getDefaultFor(clzOfOption));
    }

    public <U extends T> U get(Class<U> clzOfOption, U defaultOption) {
        if (clzOfOption == null) {
            return null;
        }
        T option = this.m_mapOptionsByType.get(clzOfOption);
        if (option == null) {
            return defaultOption;
        }
        return (U)option;
    }

    public <O extends T> boolean contains(Class<O> clzOfOption) {
        return this.get(clzOfOption) != null;
    }

    public boolean contains(T option) {
        if (option == null) {
            return false;
        }
        Class<T> clzOfOption = this.getClassOf(option);
        T oValue = this.get(clzOfOption);
        return Objects.equals(option, oValue);
    }

    public T[] asArray() {
        Object[] aOptions = new Object[this.m_mapOptionsByType.size()];
        int nCount = 0;
        for (T option : this.m_mapOptionsByType.values()) {
            aOptions[nCount++] = option;
        }
        return aOptions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OptionsByType{");
        boolean fFirst = true;
        for (T option : this.m_mapOptionsByType.values()) {
            if (fFirst) {
                fFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(option);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        String sClassOfOptionName = input.readUTF();
        this.m_clzOfOption = Class.forName(sClassOfOptionName);
        this.m_mapOptionsByType = new LinkedHashMap();
        for (int optionCount = input.readInt(); optionCount > 0; --optionCount) {
            Object option = input.readObject();
            this.add(option);
        }
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeUTF(this.m_clzOfOption.getName());
        ArrayList<T> serializableOptions = new ArrayList<T>(this.m_mapOptionsByType.size());
        for (T option : this.m_mapOptionsByType.values()) {
            if (!(option instanceof Serializable)) continue;
            serializableOptions.add(option);
        }
        output.writeInt(serializableOptions.size());
        Iterator<Object> iterator = serializableOptions.iterator();
        while (iterator.hasNext()) {
            output.writeObject(iterator.next());
        }
    }

    @SafeVarargs
    public static <T> OptionsByType<T> from(Class<T> classOfOption, T[] baseOptions, T ... options) {
        OptionsByType<T> optionsByType = new OptionsByType<T>(classOfOption, baseOptions);
        optionsByType.addAll(options);
        return optionsByType;
    }

    public static <T> OptionsByType<T> empty() {
        return EmptyOptionsByType.INSTANCE;
    }

    public OptionsByType<T> add(T option) {
        Class<T> clz = this.getClassOf(option);
        this.m_mapOptionsByType.put(clz, option);
        return this;
    }

    public OptionsByType<T> addAll(T[] options) {
        if (options != null) {
            for (T option : options) {
                this.add(option);
            }
        }
        return this;
    }

    public OptionsByType<T> addAll(OptionsByType<? extends T> optionsByType) {
        for (T option : optionsByType.asArray()) {
            this.add(option);
        }
        return this;
    }

    protected Class<T> getClassOf(T option) {
        return option == null ? null : this.getClassOf(option.getClass());
    }

    protected <O extends T> Class<O> getClassOf(Class<?> clzOfOption) {
        Class<T> clzOfOptionLocal = this.m_clzOfOption;
        if (clzOfOptionLocal.equals(clzOfOption)) {
            return clzOfOption;
        }
        Stack stackHierarchy = new Stack();
        while (clzOfOption != null) {
            stackHierarchy.push(clzOfOption);
            for (Class<?> clzInterface : clzOfOption.getInterfaces()) {
                if (clzOfOptionLocal.equals(clzInterface)) {
                    while (clzOfOption != null && Modifier.isAbstract(clzOfOption.getModifiers()) && !clzOfOption.isInterface()) {
                        clzOfOption = stackHierarchy.isEmpty() ? null : (Class)stackHierarchy.pop();
                    }
                    return clzOfOption == null ? null : (clzOfOption.isSynthetic() ? clzInterface : clzOfOption);
                }
                if (!clzOfOptionLocal.isAssignableFrom(clzInterface)) continue;
                while (clzOfOption != null && Modifier.isAbstract(clzOfOption.getModifiers()) && !clzOfOption.isInterface()) {
                    clzOfOption = stackHierarchy.isEmpty() ? null : (Class)stackHierarchy.pop();
                }
                if (clzOfOption == null) {
                    return null;
                }
                return clzInterface;
            }
            clzOfOption = clzOfOption.getSuperclass();
        }
        return null;
    }

    protected <U extends T> U getDefaultFor(Class<U> clzOfOption) {
        int nModifiers;
        if (clzOfOption == null) {
            return null;
        }
        for (Method method : clzOfOption.getMethods()) {
            nModifiers = method.getModifiers();
            if (method.getAnnotation(Default.class) == null || method.getParameterTypes().length != 0 || !Modifier.isStatic(nModifiers) || !Modifier.isPublic(nModifiers) || !clzOfOption.isAssignableFrom(method.getReturnType())) continue;
            try {
                return (U)method.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (AccessibleObject accessibleObject : clzOfOption.getFields()) {
            nModifiers = ((Field)accessibleObject).getModifiers();
            if (((Field)accessibleObject).getAnnotation(Default.class) == null || !Modifier.isStatic(nModifiers) || !Modifier.isPublic(nModifiers) || !clzOfOption.isAssignableFrom(((Field)accessibleObject).getType())) continue;
            try {
                return (U)((Field)accessibleObject).get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Constructor<U> constructor = clzOfOption.getConstructor(new Class[0]);
            int nModifiers2 = constructor.getModifiers();
            if (constructor.getAnnotation(Default.class) != null && Modifier.isPublic(nModifiers2)) {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception exception) {}
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public void readExternal(PofReader in) throws IOException {
        String sClassOfOptionName = in.readString(0);
        try {
            this.m_clzOfOption = Class.forName(sClassOfOptionName);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        this.m_mapOptionsByType = new LinkedHashMap();
        int cOptionCount = in.readInt(1);
        for (int c = 0; c < cOptionCount; ++c) {
            Object option = in.readObject(c + 2);
            this.add(option);
        }
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(0, this.m_clzOfOption.getName());
        LinkedHashMap<Class<T>, T> mapOptionsByType = this.m_mapOptionsByType;
        ArrayList listSerializableOptions = new ArrayList(mapOptionsByType.size());
        for (Object option : mapOptionsByType.values()) {
            if (option instanceof PortableObject) {
                listSerializableOptions.add(option);
                continue;
            }
            Logger.warn(() -> String.format("The option [%s] is not a Portable object and will not be serialized", option));
        }
        out.writeInt(1, listSerializableOptions.size());
        int c = 2;
        Iterator iterator = listSerializableOptions.iterator();
        while (iterator.hasNext()) {
            out.writeObject(c++, iterator.next());
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.CONSTRUCTOR, ElementType.FIELD, ElementType.METHOD})
    public static @interface Default {
    }

    protected static final class EmptyOptionsByType<T>
    extends OptionsByType<T> {
        public static final EmptyOptionsByType<?> INSTANCE = new EmptyOptionsByType();
        private static final Object[] EMPTY = new Object[0];

        public EmptyOptionsByType() {
            super(null);
        }

        @Override
        public <U extends T> U get(Class<U> clzOfOption) {
            return this.getDefaultFor(clzOfOption);
        }

        @Override
        public <U extends T> U get(Class<U> clzOfOption, U defaultOption) {
            return defaultOption;
        }

        @Override
        public <O extends T> boolean contains(Class<O> clzOfOption) {
            return false;
        }

        @Override
        public boolean contains(T option) {
            return false;
        }

        @Override
        public T[] asArray() {
            return EMPTY;
        }

        @Override
        public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput output) throws IOException {
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
        }
    }
}

