/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.tasks.internal;

import com.oracle.coherence.concurrent.executor.Task;
import com.oracle.coherence.concurrent.executor.tasks.internal.RunnableTask;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import java.io.IOException;
import java.time.Duration;

public class ScheduledRunnableTask
extends RunnableTask
implements Runnable {
    protected Duration m_initialDelay;
    protected long m_ldtExecuteNanos;
    protected Duration m_period;
    protected Duration m_delay;

    public ScheduledRunnableTask() {
    }

    public ScheduledRunnableTask(Runnable runnable, Duration initialDelay) {
        this(runnable, initialDelay, null, null);
    }

    public ScheduledRunnableTask(Runnable runnable, Duration initialDelay, Duration period, Duration delay) {
        super(runnable);
        this.m_ldtExecuteNanos = System.nanoTime() + (initialDelay == null ? 0L : initialDelay.toNanos());
        this.m_initialDelay = initialDelay;
        this.m_period = period;
        this.m_delay = delay;
    }

    public Duration getInitialDelay() {
        return this.m_initialDelay;
    }

    public Duration getPeriod() {
        return this.m_period;
    }

    @Override
    public Boolean execute(Task.Context<Boolean> context) throws Exception {
        long currentNanos = System.nanoTime();
        if (this.m_ldtExecuteNanos > currentNanos) {
            throw Task.Yield.atLeast(Duration.ofNanos(this.m_ldtExecuteNanos - currentNanos));
        }
        if (this.m_period != null) {
            this.m_ldtExecuteNanos = currentNanos + this.m_period.toNanos();
        }
        this.getRunnable().run();
        if (this.m_period != null) {
            long cWaitNanos = this.m_ldtExecuteNanos - System.nanoTime();
            if (cWaitNanos > 0L) {
                throw Task.Yield.atLeast(Duration.ofNanos(cWaitNanos));
            }
            throw Task.Yield.atLeast(Duration.ZERO);
        }
        if (this.m_delay != null) {
            this.m_ldtExecuteNanos = System.nanoTime() + this.m_delay.toNanos();
            throw Task.Yield.atLeast(this.m_delay);
        }
        return true;
    }

    @Override
    public void run() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        long seconds = in.readLong(1);
        if (seconds > 0L) {
            this.m_delay = Duration.ofSeconds(seconds);
        }
        this.m_ldtExecuteNanos = in.readLong(2);
        seconds = in.readLong(3);
        if (seconds > 0L) {
            this.m_initialDelay = Duration.ofSeconds(seconds);
        }
        if ((seconds = in.readLong(4)) > 0L) {
            this.m_period = Duration.ofSeconds(seconds);
        }
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        super.writeExternal(out);
        out.writeLong(1, this.m_delay == null ? 0L : this.m_delay.getSeconds());
        out.writeLong(2, this.m_ldtExecuteNanos);
        out.writeLong(3, this.m_initialDelay == null ? 0L : this.m_initialDelay.getSeconds());
        out.writeLong(4, this.m_period == null ? 0L : this.m_period.getSeconds());
    }
}

