/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.concurrent.executor.ExecutionPlan;
import com.oracle.coherence.concurrent.executor.ExecutionStrategy;
import com.oracle.coherence.concurrent.executor.MutableExecutionPlan;
import com.oracle.coherence.concurrent.executor.TaskExecutorService;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.function.Remote;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

public class StandardExecutionStrategy
implements ExecutionStrategy,
PortableObject {
    protected int m_cDesiredExecutors;
    protected Remote.Predicate<? super TaskExecutorService.ExecutorInfo> m_predicate;
    protected boolean m_fPerformConcurrently;

    public StandardExecutionStrategy() {
    }

    public StandardExecutionStrategy(int cDesiredExecutors, Remote.Predicate<? super TaskExecutorService.ExecutorInfo> predicate, boolean fConcurrentExecution) {
        this.m_cDesiredExecutors = cDesiredExecutors;
        this.m_predicate = predicate;
        this.m_fPerformConcurrently = fConcurrentExecution;
    }

    @Override
    public ExecutionPlan analyze(ExecutionPlan currentPlan, Map<String, ? extends TaskExecutorService.ExecutorInfo> mapExecutorInfo, EnumSet<ExecutionStrategy.EvaluationRationale> rationales) {
        Random random = new Random();
        HashMap<String, TaskExecutorService.ExecutorInfo> mapCandidates = new HashMap<String, TaskExecutorService.ExecutorInfo>();
        for (TaskExecutorService.ExecutorInfo executorInfo : mapExecutorInfo.values()) {
            if (!this.m_predicate.test((Object)executorInfo)) continue;
            mapCandidates.put(executorInfo.getId(), executorInfo);
        }
        int cCandidateCount = mapCandidates.size();
        MutableExecutionPlan mutableExecutionPlan = new MutableExecutionPlan(currentPlan);
        int cPendingRecoveries = mutableExecutionPlan.getPendingRecoveryCount();
        Iterator<String> iterator = mutableExecutionPlan.getIds();
        while (iterator.hasNext()) {
            String sExecutorId = iterator.next();
            if (mutableExecutionPlan.getAction(sExecutorId).isEffectivelyAssigned() && mapCandidates.containsKey(sExecutorId)) {
                mapCandidates.remove(sExecutorId);
                continue;
            }
            if ((!mutableExecutionPlan.contains(sExecutorId) || mapCandidates.containsKey(sExecutorId)) && mutableExecutionPlan.getAction(sExecutorId) != ExecutionPlan.Action.REASSIGN) continue;
            mutableExecutionPlan.release(sExecutorId);
            ++cPendingRecoveries;
            mapCandidates.remove(sExecutorId);
        }
        int cEffectivelyAssigned = mutableExecutionPlan.count(ExecutionPlan.Action::isEffectivelyAssigned);
        int cDesired = this.m_cDesiredExecutors < 0 ? cCandidateCount : this.m_cDesiredExecutors;
        int cExtra = 0;
        if (this.m_fPerformConcurrently) {
            cExtra = Math.max(0, cDesired - cEffectivelyAssigned);
        } else if (cEffectivelyAssigned < cDesired && (rationales.contains((Object)ExecutionStrategy.EvaluationRationale.TASK_CREATED) || rationales.contains((Object)ExecutionStrategy.EvaluationRationale.TASK_RESULT_PROVIDED))) {
            cExtra = 1;
        }
        int cRemaining = mapCandidates.size();
        while (cRemaining > 0 && cExtra > 0) {
            Iterator iterator2 = mapCandidates.keySet().iterator();
            while (iterator2.hasNext() && cRemaining > 0 && cExtra > 0) {
                String sExecutorId = (String)iterator2.next();
                if (cRemaining != cExtra && !random.nextBoolean()) continue;
                if (cPendingRecoveries > 0) {
                    mutableExecutionPlan.recover(sExecutorId);
                    --cPendingRecoveries;
                } else {
                    mutableExecutionPlan.assign(sExecutorId);
                }
                --cExtra;
                --cRemaining;
            }
        }
        cEffectivelyAssigned = mutableExecutionPlan.count(ExecutionPlan.Action::isEffectivelyAssigned);
        mutableExecutionPlan.setSatisfied(cEffectivelyAssigned == cDesired && cEffectivelyAssigned > 0);
        mutableExecutionPlan.setPendingRecoveryCount(Math.max(cPendingRecoveries, 0));
        return mutableExecutionPlan;
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_cDesiredExecutors = in.readInt(0);
        this.m_predicate = (Remote.Predicate)in.readObject(1);
        this.m_fPerformConcurrently = in.readBoolean(2);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_cDesiredExecutors);
        out.writeObject(1, this.m_predicate);
        out.writeBoolean(2, this.m_fPerformConcurrently);
    }
}

