/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.concurrent.executor.Task;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;

public class RecoveringTask
implements Task<Boolean>,
PortableObject {
    protected Duration m_duration;

    public RecoveringTask() {
    }

    public RecoveringTask(Duration duration) {
        this.m_duration = duration;
    }

    @Override
    public Boolean execute(Task.Context<Boolean> context) throws Exception {
        int cIterationCount;
        Instant startedInstant = Instant.now();
        Integer nStart = (Integer)context.getProperties().get("count");
        int n = cIterationCount = nStart == null ? 0 : nStart;
        while (Instant.now().isBefore(startedInstant.plus(this.m_duration)) && !Thread.currentThread().isInterrupted()) {
            context.getProperties().put("count", ++cIterationCount);
            try {
                Blocking.sleep((long)1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
        }
        return context.isResuming();
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_duration = Duration.ofSeconds(in.readLong(0));
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeLong(0, this.m_duration.getSeconds());
    }
}

