/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Objects;

public class Result<T>
implements ExternalizableLite,
PortableObject {
    protected boolean m_fPresent;
    protected T m_value;
    protected Throwable m_throwable;

    public Result() {
        this.m_fPresent = false;
        this.m_value = null;
        this.m_throwable = null;
    }

    private Result(T value) {
        this.m_fPresent = true;
        this.m_value = value;
        this.m_throwable = null;
    }

    private Result(Throwable throwable) {
        this.m_fPresent = true;
        this.m_value = null;
        this.m_throwable = throwable;
    }

    public static <T> Result<T> none() {
        return new Result<T>();
    }

    public static <T> Result<T> of(T value) {
        return new Result<T>(value);
    }

    public static Result throwable(Throwable throwable) {
        return new Result(throwable);
    }

    public boolean isPresent() {
        return this.m_fPresent;
    }

    public boolean isValue() {
        return this.isPresent() && this.m_throwable == null;
    }

    public boolean isThrowable() {
        return this.isPresent() && this.m_throwable != null;
    }

    public T get() throws Throwable {
        if (this.m_fPresent) {
            if (this.m_throwable == null) {
                return this.m_value;
            }
            throw this.m_throwable;
        }
        throw new NoSuchElementException("Result doesn't contain a value");
    }

    public T orElse(T value) {
        return this.isValue() ? this.m_value : value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        if (this.m_fPresent != result.m_fPresent) {
            return false;
        }
        if (!Objects.equals(this.m_value, result.m_value)) {
            return false;
        }
        return Objects.equals(this.m_throwable, result.m_throwable);
    }

    public int hashCode() {
        int result = this.m_fPresent ? 1 : 0;
        result = 31 * result + (this.m_value != null ? this.m_value.hashCode() : 0);
        result = 31 * result + (this.m_throwable != null ? this.m_throwable.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Result{" + (String)(this.m_fPresent ? (this.m_throwable == null ? "value=" + String.valueOf(this.m_value) : "throwable=" + String.valueOf(this.m_throwable)) : "not-present") + "}";
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_fPresent = in.readBoolean();
        this.m_value = ExternalizableHelper.readObject((DataInput)in);
        this.m_throwable = (Throwable)ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeBoolean(this.m_fPresent);
        ExternalizableHelper.writeObject((DataOutput)out, this.m_value);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_throwable);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_fPresent = in.readBoolean(0);
        this.m_value = in.readObject(1);
        this.m_throwable = (Throwable)in.readObject(2);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeBoolean(0, this.m_fPresent);
        out.writeObject(1, this.m_value);
        out.writeObject(2, (Object)this.m_throwable);
    }
}

