/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import javax.enterprise.util.Nonbinding;

public class AnnotationInstance {
    private final Class<? extends Annotation> f_clzAnnotationType;
    private final Method[] f_aMembers;
    private final Object[] f_aoValues;
    private Integer m_nCachedHashCode;

    private AnnotationInstance(Class<? extends Annotation> clzAnnotationType, Method[] aMembers, Object[] aoValues) {
        this.f_clzAnnotationType = clzAnnotationType;
        this.f_aMembers = aMembers;
        this.f_aoValues = aoValues;
        this.m_nCachedHashCode = aMembers.length == 0 ? Integer.valueOf(0) : null;
    }

    public static AnnotationInstance create(Annotation instance) {
        if (instance == null) {
            return new AnnotationInstance(Annotation.class, new Method[0], new Object[0]);
        }
        Method[] members = instance.annotationType().getDeclaredMethods();
        Object[] values = new Object[members.length];
        for (int i = 0; i < members.length; ++i) {
            values[i] = members[i].isAnnotationPresent(Nonbinding.class) ? null : AnnotationInstance.invoke(members[i], instance);
        }
        return new AnnotationInstance(instance.annotationType(), members, values);
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append('@').append(this.f_clzAnnotationType.getName()).append('(');
        for (int i = 0; i < this.f_aMembers.length; ++i) {
            int j;
            string.append(this.f_aMembers[i].getName()).append('=');
            Object value = this.f_aoValues[i];
            if (value instanceof boolean[]) {
                this.appendInBraces(string, Arrays.toString((boolean[])value));
            } else if (value instanceof byte[]) {
                this.appendInBraces(string, Arrays.toString((byte[])value));
            } else if (value instanceof short[]) {
                this.appendInBraces(string, Arrays.toString((short[])value));
            } else if (value instanceof int[]) {
                this.appendInBraces(string, Arrays.toString((int[])value));
            } else if (value instanceof long[]) {
                this.appendInBraces(string, Arrays.toString((long[])value));
            } else if (value instanceof float[]) {
                this.appendInBraces(string, Arrays.toString((float[])value));
            } else if (value instanceof double[]) {
                this.appendInBraces(string, Arrays.toString((double[])value));
            } else if (value instanceof char[]) {
                this.appendInBraces(string, Arrays.toString((char[])value));
            } else if (value instanceof String[]) {
                String[] strings = (String[])value;
                Object[] quoted = new String[strings.length];
                for (j = 0; j < strings.length; ++j) {
                    quoted[j] = "\"" + strings[j] + "\"";
                }
                this.appendInBraces(string, Arrays.toString(quoted));
            } else if (value instanceof Class[]) {
                Class[] classes = (Class[])value;
                Object[] names = new String[classes.length];
                for (j = 0; j < classes.length; ++j) {
                    names[j] = classes[j].getName() + ".class";
                }
                this.appendInBraces(string, Arrays.toString(names));
            } else if (value instanceof Object[]) {
                this.appendInBraces(string, Arrays.toString((Object[])value));
            } else if (value instanceof String) {
                string.append('\"').append(value).append('\"');
            } else if (value instanceof Class) {
                string.append(((Class)value).getName()).append(".class");
            } else {
                string.append(value);
            }
            if (i >= this.f_aMembers.length - 1) continue;
            string.append(", ");
        }
        return string.append(')').toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AnnotationInstance that = (AnnotationInstance)other;
        if (!Objects.equals(this.f_clzAnnotationType, that.f_clzAnnotationType)) {
            return false;
        }
        if (this.f_aMembers.length != that.f_aMembers.length) {
            return false;
        }
        for (int i = 0; i < this.f_aMembers.length; ++i) {
            Object thisValue = this.f_aoValues[i];
            Object thatValue = that.f_aoValues[i];
            if (!(thisValue instanceof byte[] && thatValue instanceof byte[] ? !Arrays.equals((byte[])thisValue, (byte[])thatValue) : (thisValue instanceof short[] && thatValue instanceof short[] ? !Arrays.equals((short[])thisValue, (short[])thatValue) : (thisValue instanceof int[] && thatValue instanceof int[] ? !Arrays.equals((int[])thisValue, (int[])thatValue) : (thisValue instanceof long[] && thatValue instanceof long[] ? !Arrays.equals((long[])thisValue, (long[])thatValue) : (thisValue instanceof float[] && thatValue instanceof float[] ? !Arrays.equals((float[])thisValue, (float[])thatValue) : (thisValue instanceof double[] && thatValue instanceof double[] ? !Arrays.equals((double[])thisValue, (double[])thatValue) : (thisValue instanceof char[] && thatValue instanceof char[] ? !Arrays.equals((char[])thisValue, (char[])thatValue) : (thisValue instanceof boolean[] && thatValue instanceof boolean[] ? !Arrays.equals((boolean[])thisValue, (boolean[])thatValue) : (thisValue instanceof Object[] && thatValue instanceof Object[] ? !Arrays.equals((Object[])thisValue, (Object[])thatValue) : !Objects.equals(thisValue, thatValue))))))))))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.m_nCachedHashCode == null) {
            int hashCode = 0;
            for (int i = 0; i < this.f_aMembers.length; ++i) {
                int memberNameHashCode = 127 * this.f_aMembers[i].getName().hashCode();
                Object value = this.f_aoValues[i];
                int memberValueHashCode = value instanceof boolean[] ? Arrays.hashCode((boolean[])value) : (value instanceof short[] ? Arrays.hashCode((short[])value) : (value instanceof int[] ? Arrays.hashCode((int[])value) : (value instanceof long[] ? Arrays.hashCode((long[])value) : (value instanceof float[] ? Arrays.hashCode((float[])value) : (value instanceof double[] ? Arrays.hashCode((double[])value) : (value instanceof byte[] ? Arrays.hashCode((byte[])value) : (value instanceof char[] ? Arrays.hashCode((char[])value) : (value instanceof Object[] ? Arrays.hashCode((Object[])value) : Objects.hashCode(value)))))))));
                hashCode += memberNameHashCode ^ memberValueHashCode;
            }
            this.m_nCachedHashCode = hashCode;
        }
        return this.m_nCachedHashCode;
    }

    private static Object invoke(Method method, Object oTarget) {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(oTarget, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Error checking value of member method " + method.getName() + " on " + String.valueOf(method.getDeclaringClass()), e);
        }
    }

    private void appendInBraces(StringBuilder sb, String s) {
        sb.append('{').append(s, 1, s.length() - 1).append('}');
    }
}

