/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi;

import com.oracle.coherence.cdi.CoherenceExtension;
import com.oracle.coherence.cdi.Name;
import com.oracle.coherence.cdi.SessionName;
import com.tangosol.net.Coherence;
import com.tangosol.net.Session;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;

@ApplicationScoped
public class SessionProducer {
    private final BeanManager f_beanManager;

    @Inject
    public SessionProducer(BeanManager context) {
        this.f_beanManager = context;
    }

    @Produces
    public Session getDefaultSession(InjectionPoint injectionPoint) {
        return this.getSession("");
    }

    @Produces
    @SessionName
    public Session getSessionWithSessionName(InjectionPoint injectionPoint) {
        String sName = injectionPoint.getQualifiers().stream().filter(q -> q.annotationType().isAssignableFrom(SessionName.class)).map(q -> ((SessionName)q).value().trim()).findFirst().orElse("");
        return this.getSession(sName);
    }

    @Produces
    @Name(value="")
    public Session getSessionWithName(InjectionPoint injectionPoint) {
        String sName = injectionPoint.getQualifiers().stream().filter(q -> q.annotationType().isAssignableFrom(Name.class)).map(q -> ((Name)q).value().trim()).findFirst().orElse("");
        return this.getSession(sName);
    }

    private Session getSession(String sName) {
        String sSessionName = sName == null || sName.trim().isEmpty() ? "" : sName;
        CoherenceExtension.ensureCoherence(this.f_beanManager);
        return (Session)Coherence.findSession((String)sSessionName).orElseThrow(() -> new DefinitionException("No Session is configured with name " + sSessionName));
    }
}

