/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi;

import com.oracle.coherence.inject.ConfigUri;
import com.oracle.coherence.inject.Name;
import com.tangosol.coherence.config.Config;
import com.tangosol.io.DefaultSerializer;
import com.tangosol.io.NamedSerializerFactory;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerFactory;
import com.tangosol.io.pof.ConfigurablePofContext;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.OperationalContext;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.literal.NamedLiteral;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;

@ApplicationScoped
public class SerializerProducer
implements NamedSerializerFactory {
    private final Map<String, SerializerFactory> f_mapSerializerFactory;
    private final BeanManager f_beanManager;
    private final DefaultSerializer f_defaultSerializer = new DefaultSerializer();
    private final Map<ClassLoader, Map<String, Serializer>> f_mapSerializer = new ConcurrentHashMap<ClassLoader, Map<String, Serializer>>();
    private final Map<String, ConfigurablePofContext> f_mapPofSerializer = new ConcurrentHashMap<String, ConfigurablePofContext>();
    private final String f_sDefaultPofConfig = Config.getProperty((String)"coherence.pof.config", (String)"pof-config.xml");

    @Inject
    SerializerProducer(BeanManager beanManager) {
        this.f_beanManager = beanManager;
        Instance instance = beanManager == null ? null : beanManager.createInstance().select(OperationalContext.class, new Annotation[0]);
        this.f_mapSerializerFactory = instance != null && instance.isResolvable() ? ((OperationalContext)instance.get()).getSerializerMap() : Collections.emptyMap();
    }

    SerializerProducer(BeanManager beanManager, OperationalContext context) {
        this.f_beanManager = beanManager;
        this.f_mapSerializerFactory = context == null ? Collections.emptyMap() : context.getSerializerMap();
    }

    public static SerializerProducer create() {
        return SerializerProducer.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Produces
    public Serializer getDefaultSerializer(InjectionPoint ip) {
        Member member = ip.getMember();
        ClassLoader loader = member == null ? Base.getContextClassLoader() : member.getDeclaringClass().getClassLoader();
        return this.getNamedSerializer("", loader);
    }

    @Produces
    @Name(value="")
    @ConfigUri(value="")
    public Serializer getNamedSerializer(InjectionPoint ip) {
        String sName = ip.getQualifiers().stream().filter(q -> q instanceof Name).map(q -> ((Name)q).value()).findFirst().orElse("");
        String sURI = ip.getQualifiers().stream().filter(q -> q instanceof ConfigUri).map(q -> ((ConfigUri)q).value()).findFirst().orElse("");
        Member member = ip.getMember();
        ClassLoader loader = member == null ? Base.getContextClassLoader() : member.getDeclaringClass().getClassLoader();
        return this.getNamedSerializer(sName, sURI, loader);
    }

    public Serializer getNamedSerializer(String sName, ClassLoader loader) {
        return this.getNamedSerializer(sName, null, loader);
    }

    Serializer getNamedSerializer(String sName, String sConfigUri, ClassLoader loader) {
        if (sName.trim().isEmpty()) {
            return ExternalizableHelper.ensureSerializer((ClassLoader)loader);
        }
        SerializerFactory factory = this.f_mapSerializerFactory.get(sName);
        if (factory != null) {
            Map mapByName = this.f_mapSerializer.computeIfAbsent(loader, k -> new ConcurrentHashMap());
            return mapByName.computeIfAbsent(sName, k -> factory.createSerializer(loader));
        }
        if ("java".equalsIgnoreCase(sName)) {
            return this.f_defaultSerializer;
        }
        if ("pof".equalsIgnoreCase(sName)) {
            String sURI = sConfigUri == null ? this.f_sDefaultPofConfig : sConfigUri;
            return (Serializer)this.f_mapPofSerializer.computeIfAbsent(sURI, this::ensurePofSerializer);
        }
        if (this.f_beanManager == null) {
            throw new IllegalArgumentException("Cannot locate a serializer named '" + sName + "' no BeanManager present");
        }
        Instance instance = this.f_beanManager.createInstance().select(Serializer.class, new Annotation[]{NamedLiteral.of((String)sName)});
        if (instance.isResolvable()) {
            return (Serializer)instance.get();
        }
        throw new IllegalArgumentException("Cannot locate a serializer named '" + sName + "'");
    }

    private ConfigurablePofContext ensurePofSerializer(String sConfig) {
        return new ConfigurablePofContext(sConfig);
    }

    public static class Builder {
        private OperationalContext m_operationalContext;
        private BeanManager m_beanManager;

        private Builder() {
        }

        public Builder beanManager(BeanManager beanManager) {
            this.m_beanManager = beanManager;
            return this;
        }

        public SerializerProducer build() {
            return new SerializerProducer(this.m_beanManager, this.ensureOperationalContext());
        }

        private OperationalContext ensureOperationalContext() {
            if (this.m_operationalContext == null) {
                return (OperationalContext)CacheFactory.getCluster();
            }
            return this.m_operationalContext;
        }
    }
}

