/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi;

import com.oracle.coherence.inject.Name;
import com.oracle.coherence.inject.SessionName;
import com.oracle.coherence.inject.SubscriberGroup;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.Session;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.net.topic.Publisher;
import com.tangosol.net.topic.Subscriber;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;

@ApplicationScoped
public class NamedTopicProducer {
    private final BeanManager f_beanManager;

    @Inject
    public NamedTopicProducer(BeanManager beanManager) {
        this.f_beanManager = beanManager;
    }

    @Produces
    <V> NamedTopic<V> getNonQualifiedNamedTopic(InjectionPoint injectionPoint) {
        return this.getNamedTopic(injectionPoint);
    }

    @Produces
    @Name(value="")
    @SessionName(value="")
    <V> NamedTopic<V> getNamedTopic(InjectionPoint injectionPoint) {
        String sName = null;
        String sSession = "";
        for (Annotation annotation : injectionPoint.getQualifiers()) {
            if (Name.class.equals(annotation.annotationType())) {
                sName = ((Name)annotation).value();
                continue;
            }
            if (!SessionName.class.equals(annotation.annotationType())) continue;
            sSession = ((SessionName)annotation).value();
        }
        if (sName == null) {
            sName = injectionPoint.getMember().getName();
        }
        String sSessionName = sSession;
        Session session = (Session)this.f_beanManager.createInstance().select(Session.class, new Annotation[]{Name.Literal.of((String)sSessionName)}).get();
        return session.getTopic(sName, new NamedCollection.Option[0]);
    }

    @Produces
    <V> Publisher<V> getNonQualifiedNamedTopicPublisher(InjectionPoint injectionPoint) {
        return this.getNamedTopicPublisher(injectionPoint);
    }

    @Produces
    @Name(value="")
    @SessionName(value="")
    <V> Publisher<V> getNamedTopicPublisher(InjectionPoint injectionPoint) {
        NamedTopic<V> topic = this.getNamedTopic(injectionPoint);
        return topic.createPublisher();
    }

    <V> void closePublisher(@Disposes Publisher<V> publisher) {
        publisher.close();
    }

    <V> void closeQualifiedPublisher(@Disposes @Name(value="") @SessionName(value="") Publisher<V> publisher) {
        publisher.close();
    }

    @Produces
    <V> Subscriber<V> getNonQualifiedNamedTopicSubscriber(InjectionPoint injectionPoint) {
        return this.getNamedTopicSubscriber(injectionPoint);
    }

    @Produces
    @Name(value="")
    @SessionName(value="")
    <V> Subscriber<V> getNamedTopicSubscriber(InjectionPoint injectionPoint) {
        String sGroup = injectionPoint.getQualifiers().stream().filter(q -> SubscriberGroup.class.isAssignableFrom(q.getClass())).map(q -> ((SubscriberGroup)q).value()).findFirst().orElse(null);
        NamedTopic<V> topic = this.getNamedTopic(injectionPoint);
        return sGroup == null ? topic.createSubscriber() : topic.createSubscriber(new Subscriber.Option[]{Subscriber.Name.of((String)sGroup)});
    }

    <V> void closeSubscriber(@Disposes Subscriber<V> subscriber) {
        subscriber.close();
    }

    <V> void closeQualifiedSubscriber(@Disposes @Name(value="") @SessionName(value="") Subscriber<V> subscriber) {
        subscriber.close();
    }
}

