/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi;

import com.oracle.coherence.cdi.CdiEventObserver;
import com.oracle.coherence.cdi.CdiMapEventObserver;
import com.oracle.coherence.cdi.ExtractorProducer;
import com.oracle.coherence.cdi.FilterProducer;
import com.oracle.coherence.cdi.MapEventTransformerProducer;
import com.oracle.coherence.event.AnnotatedMapListener;
import com.oracle.coherence.event.EventObserverSupport;
import com.oracle.coherence.inject.AnnotationInstance;
import com.oracle.coherence.inject.ExtractorBinding;
import com.oracle.coherence.inject.ExtractorFactory;
import com.oracle.coherence.inject.FilterBinding;
import com.oracle.coherence.inject.FilterFactory;
import com.oracle.coherence.inject.MapEventTransformerBinding;
import com.oracle.coherence.inject.MapEventTransformerFactory;
import com.oracle.coherence.inject.Name;
import com.tangosol.net.Coherence;
import com.tangosol.net.SessionProvider;
import com.tangosol.net.events.CoherenceLifecycleEvent;
import com.tangosol.net.events.SessionLifecycleEvent;
import com.tangosol.net.events.application.LifecycleEvent;
import com.tangosol.net.events.internal.NamedEventInterceptor;
import com.tangosol.net.events.partition.cache.CacheLifecycleEvent;
import com.tangosol.util.MapEvent;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.WithAnnotations;

public class CoherenceExtension
implements Extension {
    private final Map<AnnotationInstance, Class<? extends FilterFactory<?, ?>>> m_mapFilterSupplier = new HashMap();
    private final Map<AnnotationInstance, Class<? extends ExtractorFactory<?, ?, ?>>> m_mapExtractorSupplier = new HashMap();
    private final Map<AnnotationInstance, Class<? extends MapEventTransformerFactory<?, ?, ?, ?>>> m_mapMapEventTransformerSupplier = new HashMap();
    private Coherence m_coherence;
    private final List<EventObserverSupport.EventHandler<?, ?>> m_listInterceptors = new ArrayList();
    private final List<AnnotatedMapListener<?, ?>> m_listListener = new ArrayList();

    private void processCoherenceLifecycleEventObservers(@Observes ProcessObserverMethod<CoherenceLifecycleEvent, ?> event) {
        this.m_listInterceptors.add((EventObserverSupport.EventHandler<?, ?>)new EventObserverSupport.CoherenceLifecycleEventHandler(new CdiEventObserver<CoherenceLifecycleEvent>(event)));
    }

    private void processSessionLifecycleEventObservers(@Observes ProcessObserverMethod<SessionLifecycleEvent, ?> event) {
        this.m_listInterceptors.add((EventObserverSupport.EventHandler<?, ?>)new EventObserverSupport.SessionLifecycleEventHandler(new CdiEventObserver<SessionLifecycleEvent>(event)));
    }

    private void processLifecycleEventObservers(@Observes ProcessObserverMethod<LifecycleEvent, ?> event) {
        this.m_listInterceptors.add((EventObserverSupport.EventHandler<?, ?>)new EventObserverSupport.LifecycleEventHandler(new CdiEventObserver<LifecycleEvent>(event)));
    }

    private void processCacheLifecycleEventObservers(@Observes ProcessObserverMethod<CacheLifecycleEvent, ?> event) {
        this.m_listInterceptors.add((EventObserverSupport.EventHandler<?, ?>)new EventObserverSupport.CacheLifecycleEventHandler(new CdiEventObserver<CacheLifecycleEvent>(event)));
    }

    private <K, V> void processMapEventObservers(@Observes ProcessObserverMethod<MapEvent<K, V>, ?> event) {
        this.m_listListener.add(new AnnotatedMapListener(new CdiMapEventObserver<K, V>(event), event.getAnnotatedMethod().getAnnotations()));
    }

    private <T extends FilterFactory<?, ?>> void processFilterInjectionPoint(@Observes @WithAnnotations(value={FilterBinding.class}) ProcessAnnotatedType<T> event) {
        AnnotatedType type = event.getAnnotatedType();
        type.getAnnotations().stream().filter(a -> a.annotationType().isAnnotationPresent(FilterBinding.class)).map(AnnotationInstance::create).forEach(a -> this.m_mapFilterSupplier.put((AnnotationInstance)a, type.getJavaClass()));
    }

    private <T extends ExtractorFactory<?, ?, ?>> void processValueExtractorInjectionPoint(@Observes @WithAnnotations(value={ExtractorBinding.class}) ProcessAnnotatedType<T> event) {
        AnnotatedType type = event.getAnnotatedType();
        type.getAnnotations().stream().filter(a -> a.annotationType().isAnnotationPresent(ExtractorBinding.class)).map(AnnotationInstance::create).forEach(a -> this.m_mapExtractorSupplier.put((AnnotationInstance)a, type.getJavaClass()));
    }

    private <T extends MapEventTransformerFactory<?, ?, ?, ?>> void processMapEventTransformerInjectionPoint(@Observes @WithAnnotations(value={MapEventTransformerBinding.class}) ProcessAnnotatedType<T> event) {
        AnnotatedType type = event.getAnnotatedType();
        type.getAnnotations().stream().filter(a -> a.annotationType().isAnnotationPresent(MapEventTransformerBinding.class)).map(AnnotationInstance::create).forEach(a -> this.m_mapMapEventTransformerSupplier.put((AnnotationInstance)a, type.getJavaClass()));
    }

    private void addBeans(@Observes AfterBeanDiscovery event) {
        FilterProducer.FilterFactoryResolver filterResolver = new FilterProducer.FilterFactoryResolver(this.m_mapFilterSupplier);
        event.addBean().produceWith(i -> filterResolver).types(new Type[]{FilterProducer.FilterFactoryResolver.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE}).scope(ApplicationScoped.class).beanClass(FilterProducer.FilterFactoryResolver.class);
        ExtractorProducer.ValueExtractorFactoryResolver extractorResolver = new ExtractorProducer.ValueExtractorFactoryResolver(this.m_mapExtractorSupplier);
        event.addBean().produceWith(i -> extractorResolver).types(new Type[]{ExtractorProducer.ValueExtractorFactoryResolver.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE}).scope(ApplicationScoped.class).beanClass(ExtractorProducer.ValueExtractorFactoryResolver.class);
        MapEventTransformerProducer.MapEventTransformerFactoryResolver mapEventTransformerResolver = new MapEventTransformerProducer.MapEventTransformerFactoryResolver(this.m_mapMapEventTransformerSupplier);
        event.addBean().produceWith(i -> mapEventTransformerResolver).types(new Type[]{MapEventTransformerProducer.MapEventTransformerFactoryResolver.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE}).scope(ApplicationScoped.class).beanClass(MapEventTransformerProducer.MapEventTransformerFactoryResolver.class);
    }

    public List<AnnotatedMapListener<?, ?>> getMapListeners() {
        return this.m_listListener;
    }

    synchronized void startServer(@Observes @Priority(value=1) @Initialized(value=ApplicationScoped.class) Object event, BeanManager beanManager) {
        this.m_coherence = CoherenceExtension.ensureCoherence(beanManager);
    }

    List<EventObserverSupport.EventHandler<?, ?>> getInterceptors() {
        return this.m_listInterceptors;
    }

    public static Coherence ensureCoherence(BeanManager beanManager) {
        Instance instance = beanManager.createInstance().select(Coherence.class, new Annotation[]{Name.Literal.of((String)"")});
        if (instance.isResolvable()) {
            return (Coherence)instance.get();
        }
        throw new IllegalStateException("Cannot resolve default Coherence instance");
    }

    synchronized void stopServer(@Observes BeforeShutdown event) {
        SessionProvider.get().close();
        if (this.m_coherence != null) {
            this.m_coherence.close();
        }
        Coherence.closeAll();
    }

    public Coherence getCoherence() {
        return this.m_coherence;
    }

    public static interface InterceptorProvider {
        public Iterable<NamedEventInterceptor<?>> getInterceptors();
    }
}

