/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi;

import com.oracle.coherence.cdi.CdiMapListener;
import com.oracle.coherence.cdi.CoherenceExtension;
import com.oracle.coherence.cdi.FilterProducer;
import com.oracle.coherence.cdi.MapEventTransformerProducer;
import com.oracle.coherence.cdi.RemoteMapLifecycleEvent;
import com.oracle.coherence.cdi.events.Created;
import com.tangosol.net.NamedMap;
import com.tangosol.net.events.partition.cache.CacheLifecycleEvent;
import com.tangosol.util.Filter;
import com.tangosol.util.MapEventTransformer;
import com.tangosol.util.filter.MapEventFilter;
import com.tangosol.util.filter.MapEventTransformerFilter;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;

@ApplicationScoped
public class CdiMapListenerManager {
    @Inject
    private CoherenceExtension m_extension;
    @Inject
    private FilterProducer m_filterProducer;
    @Inject
    private MapEventTransformerProducer m_transformerProducer;

    private void registerCacheListeners(@Observes @Created CacheLifecycleEvent event) {
        this.registerListeners((NamedMap)event.getCache(), event.getScope(), null, event.getServiceName());
    }

    private void registerRemoteListeners(@Observes @Created RemoteMapLifecycleEvent event) {
        this.registerListeners(event.getMap(), event.getScope(), event.getSessionName(), event.getServiceName());
    }

    private void registerListeners(NamedMap cache, String sEventScope, String sEventSession, String sEventService) {
        Set<CdiMapListener<?, ?>> setListeners = this.m_extension.getMapListeners(this.removeScope(sEventService), cache.getName());
        for (CdiMapListener<?, ?> listener : setListeners) {
            MapEventTransformer transformer;
            boolean fSessionOK;
            String sScope;
            if (listener.hasFilterAnnotation()) {
                listener.resolveFilter(this.m_filterProducer);
            }
            if (listener.hasTransformerAnnotation()) {
                listener.resolveTransformer(this.m_transformerProducer);
            }
            boolean fScopeOK = (sScope = listener.getScopeName()) == null || sScope.equals(sEventScope);
            String sSession = listener.getRemoteSessionName();
            boolean bl = fSessionOK = sSession == null || sSession.equals(sEventSession);
            if (!fScopeOK || !fSessionOK) continue;
            MapEventFilter filter = listener.getFilter();
            if (filter != null && !(filter instanceof MapEventFilter)) {
                filter = new MapEventFilter(7, filter);
            }
            if ((transformer = listener.getTransformer()) != null) {
                filter = new MapEventTransformerFilter((Filter)filter, transformer);
            }
            boolean fLite = listener.isLite();
            if (listener.isSynchronous()) {
                cache.addMapListener(listener.synchronous(), (Filter)filter, fLite);
                continue;
            }
            cache.addMapListener(listener, (Filter)filter, fLite);
        }
    }

    private String removeScope(String sServiceName) {
        if (sServiceName == null) {
            return "";
        }
        int nIndex = sServiceName.indexOf(58);
        return nIndex > -1 ? sServiceName.substring(nIndex + 1) : sServiceName;
    }
}

