/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi.server;

import com.oracle.coherence.cdi.events.Activated;
import com.oracle.coherence.cdi.events.Activating;
import com.oracle.coherence.cdi.events.Arrived;
import com.oracle.coherence.cdi.events.Assigned;
import com.oracle.coherence.cdi.events.CacheName;
import com.oracle.coherence.cdi.events.Committed;
import com.oracle.coherence.cdi.events.Committing;
import com.oracle.coherence.cdi.events.Created;
import com.oracle.coherence.cdi.events.Departed;
import com.oracle.coherence.cdi.events.Departing;
import com.oracle.coherence.cdi.events.Destroyed;
import com.oracle.coherence.cdi.events.Disposing;
import com.oracle.coherence.cdi.events.Executed;
import com.oracle.coherence.cdi.events.Executing;
import com.oracle.coherence.cdi.events.Inserted;
import com.oracle.coherence.cdi.events.Inserting;
import com.oracle.coherence.cdi.events.Lost;
import com.oracle.coherence.cdi.events.MapName;
import com.oracle.coherence.cdi.events.Processor;
import com.oracle.coherence.cdi.events.Recovered;
import com.oracle.coherence.cdi.events.Removed;
import com.oracle.coherence.cdi.events.Removing;
import com.oracle.coherence.cdi.events.Rollback;
import com.oracle.coherence.cdi.events.ScopeName;
import com.oracle.coherence.cdi.events.ServiceName;
import com.oracle.coherence.cdi.events.Truncated;
import com.oracle.coherence.cdi.events.Updated;
import com.oracle.coherence.cdi.events.Updating;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.events.Event;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventDispatcherAwareInterceptor;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.application.LifecycleEvent;
import com.tangosol.net.events.internal.ConfigurableCacheFactoryDispatcher;
import com.tangosol.net.events.partition.PartitionedServiceDispatcher;
import com.tangosol.net.events.partition.TransactionEvent;
import com.tangosol.net.events.partition.TransferEvent;
import com.tangosol.net.events.partition.UnsolicitedCommitEvent;
import com.tangosol.net.events.partition.cache.CacheLifecycleEvent;
import com.tangosol.net.events.partition.cache.EntryEvent;
import com.tangosol.net.events.partition.cache.EntryProcessorEvent;
import com.tangosol.net.events.partition.cache.PartitionedCacheDispatcher;
import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.concurrent.CompletableFuture;
import javax.enterprise.inject.spi.ObserverMethod;

class CdiInterceptorSupport {
    CdiInterceptorSupport() {
    }

    static class UnsolicitedCommitEventHandler
    extends ServiceEventHandler<UnsolicitedCommitEvent, UnsolicitedCommitEvent.Type> {
        UnsolicitedCommitEventHandler(ObserverMethod<UnsolicitedCommitEvent> observer) {
            super(observer, UnsolicitedCommitEvent.Type.class);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (!(a instanceof Committed)) continue;
                this.addType(UnsolicitedCommitEvent.Type.COMMITTED);
            }
        }
    }

    static class TransferEventHandler
    extends ServiceEventHandler<TransferEvent, TransferEvent.Type> {
        TransferEventHandler(ObserverMethod<TransferEvent> observer) {
            super(observer, TransferEvent.Type.class);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof Assigned) {
                    this.addType(TransferEvent.Type.ASSIGNED);
                    continue;
                }
                if (a instanceof Arrived) {
                    this.addType(TransferEvent.Type.ARRIVED);
                    continue;
                }
                if (a instanceof Departing) {
                    this.addType(TransferEvent.Type.DEPARTING);
                    continue;
                }
                if (a instanceof Departed) {
                    this.addType(TransferEvent.Type.DEPARTED);
                    continue;
                }
                if (a instanceof Lost) {
                    this.addType(TransferEvent.Type.LOST);
                    continue;
                }
                if (a instanceof Recovered) {
                    this.addType(TransferEvent.Type.RECOVERED);
                    continue;
                }
                if (!(a instanceof Rollback)) continue;
                this.addType(TransferEvent.Type.ROLLBACK);
            }
        }
    }

    static class TransactionEventHandler
    extends ServiceEventHandler<TransactionEvent, TransactionEvent.Type> {
        TransactionEventHandler(ObserverMethod<TransactionEvent> observer) {
            super(observer, TransactionEvent.Type.class);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof Committing) {
                    this.addType(TransactionEvent.Type.COMMITTING);
                    continue;
                }
                if (!(a instanceof Committed)) continue;
                this.addType(TransactionEvent.Type.COMMITTED);
            }
        }
    }

    static abstract class ServiceEventHandler<E extends Event<T>, T extends Enum<T>>
    extends EventHandler<E, T> {
        protected final String m_serviceName;

        protected ServiceEventHandler(ObserverMethod<E> observer, Class<T> classType) {
            super(observer, classType);
            String service = null;
            for (Annotation a : observer.getObservedQualifiers()) {
                if (!(a instanceof ServiceName)) continue;
                service = ((ServiceName)a).value();
            }
            this.m_serviceName = service;
        }

        @Override
        protected boolean isApplicable(EventDispatcher dispatcher, String sScopeName) {
            PartitionedServiceDispatcher psd;
            ConfigurableCacheFactory ccf;
            if (dispatcher instanceof PartitionedServiceDispatcher && ((ccf = this.getConfigurableCacheFactory((psd = (PartitionedServiceDispatcher)dispatcher).getService())) == null || sScopeName == null || sScopeName.equals(ccf.getScopeName()))) {
                return this.m_serviceName == null || this.m_serviceName.equals(this.removeScope(psd.getServiceName()));
            }
            return false;
        }

        protected ConfigurableCacheFactory getConfigurableCacheFactory(PartitionedService service) {
            if (service instanceof PartitionedCache) {
                PartitionedCache pc = (PartitionedCache)service;
                return pc.getBackingMapManager().getCacheFactory();
            }
            return null;
        }
    }

    static class EntryProcessorEventHandler
    extends CacheEventHandler<EntryProcessorEvent, EntryProcessorEvent.Type> {
        private final Class<?> m_classProcessor;

        EntryProcessorEventHandler(ObserverMethod<EntryProcessorEvent> observer) {
            super(observer, EntryProcessorEvent.Type.class);
            Class classProcessor = null;
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof Processor) {
                    classProcessor = ((Processor)a).value();
                    continue;
                }
                if (a instanceof Executing) {
                    this.addType(EntryProcessorEvent.Type.EXECUTING);
                    continue;
                }
                if (!(a instanceof Executed)) continue;
                this.addType(EntryProcessorEvent.Type.EXECUTED);
            }
            this.m_classProcessor = classProcessor;
        }

        @Override
        protected boolean shouldFire(EntryProcessorEvent event) {
            return this.m_classProcessor == null || this.m_classProcessor.equals(event.getProcessor().getClass());
        }
    }

    static class EntryEventHandler<K, V>
    extends CacheEventHandler<EntryEvent<K, V>, EntryEvent.Type> {
        EntryEventHandler(ObserverMethod<EntryEvent<K, V>> observer) {
            super(observer, EntryEvent.Type.class);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof Inserting) {
                    this.addType(EntryEvent.Type.INSERTING);
                    continue;
                }
                if (a instanceof Inserted) {
                    this.addType(EntryEvent.Type.INSERTED);
                    continue;
                }
                if (a instanceof Updating) {
                    this.addType(EntryEvent.Type.UPDATING);
                    continue;
                }
                if (a instanceof Updated) {
                    this.addType(EntryEvent.Type.UPDATED);
                    continue;
                }
                if (a instanceof Removing) {
                    this.addType(EntryEvent.Type.REMOVING);
                    continue;
                }
                if (!(a instanceof Removed)) continue;
                this.addType(EntryEvent.Type.REMOVED);
            }
        }
    }

    static class CacheLifecycleEventHandler
    extends CacheEventHandler<CacheLifecycleEvent, CacheLifecycleEvent.Type> {
        CacheLifecycleEventHandler(ObserverMethod<CacheLifecycleEvent> observer) {
            super(observer, CacheLifecycleEvent.Type.class);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof Created) {
                    this.addType(CacheLifecycleEvent.Type.CREATED);
                    continue;
                }
                if (a instanceof Destroyed) {
                    this.addType(CacheLifecycleEvent.Type.DESTROYED);
                    continue;
                }
                if (!(a instanceof Truncated)) continue;
                this.addType(CacheLifecycleEvent.Type.TRUNCATED);
            }
        }
    }

    static abstract class CacheEventHandler<E extends Event<T>, T extends Enum<T>>
    extends EventHandler<E, T> {
        protected final String m_cacheName;
        protected final String m_serviceName;

        protected CacheEventHandler(ObserverMethod<E> observer, Class<T> classType) {
            super(observer, classType);
            String cache = null;
            String service = null;
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof CacheName) {
                    cache = ((CacheName)a).value();
                    continue;
                }
                if (a instanceof MapName) {
                    cache = ((MapName)a).value();
                    continue;
                }
                if (!(a instanceof ServiceName)) continue;
                service = ((ServiceName)a).value();
            }
            this.m_cacheName = cache;
            this.m_serviceName = service;
        }

        @Override
        protected boolean isApplicable(EventDispatcher dispatcher, String sScopeName) {
            if (dispatcher instanceof PartitionedCacheDispatcher) {
                PartitionedCacheDispatcher pcd = (PartitionedCacheDispatcher)dispatcher;
                ConfigurableCacheFactory ccf = pcd.getBackingMapContext().getManagerContext().getManager().getCacheFactory();
                if (sScopeName == null || sScopeName.equals(ccf.getScopeName())) {
                    return !(this.m_cacheName != null && !this.m_cacheName.equals(pcd.getCacheName()) || this.m_serviceName != null && !this.m_serviceName.equals(this.removeScope(pcd.getServiceName())));
                }
            }
            return false;
        }
    }

    static class LifecycleEventHandler
    extends EventHandler<LifecycleEvent, LifecycleEvent.Type> {
        LifecycleEventHandler(ObserverMethod<LifecycleEvent> observer) {
            super(observer, LifecycleEvent.Type.class);
            for (Annotation a : observer.getObservedQualifiers()) {
                if (a instanceof Activating) {
                    this.addType(LifecycleEvent.Type.ACTIVATING);
                    continue;
                }
                if (a instanceof Activated) {
                    this.addType(LifecycleEvent.Type.ACTIVATED);
                    continue;
                }
                if (!(a instanceof Disposing)) continue;
                this.addType(LifecycleEvent.Type.DISPOSING);
            }
        }

        @Override
        protected boolean isApplicable(EventDispatcher dispatcher, String sScopeName) {
            return dispatcher instanceof ConfigurableCacheFactoryDispatcher;
        }

        @Override
        protected String getEventScope(LifecycleEvent event) {
            return event.getConfigurableCacheFactory().getScopeName();
        }
    }

    static abstract class EventHandler<E extends Event<T>, T extends Enum<T>>
    implements EventDispatcherAwareInterceptor<E> {
        protected final ObserverMethod<E> m_observer;
        protected final EnumSet<T> m_setTypes;
        private final String m_sScopeName;

        protected EventHandler(ObserverMethod<E> observer, Class<T> classEventType) {
            this.m_observer = observer;
            this.m_setTypes = EnumSet.noneOf(classEventType);
            String sScope = null;
            for (Annotation a : observer.getObservedQualifiers()) {
                if (!(a instanceof ScopeName)) continue;
                sScope = ((ScopeName)a).value();
            }
            this.m_sScopeName = sScope;
        }

        public void introduceEventDispatcher(String sIdentifier, EventDispatcher dispatcher) {
            if (this.isApplicable(dispatcher, this.m_sScopeName)) {
                dispatcher.addEventInterceptor(this.getId(), (EventInterceptor)this, this.eventTypes(), false);
            }
        }

        public void onEvent(E event) {
            if (this.shouldFire(event)) {
                String sObserverScope = this.m_sScopeName;
                String sEventScope = this.getEventScope(event);
                if (sObserverScope == null || sEventScope == null || sObserverScope.equals(sEventScope)) {
                    if (this.m_observer.isAsync()) {
                        CompletableFuture.supplyAsync(() -> {
                            this.m_observer.notify((Object)event);
                            return event;
                        });
                    } else {
                        this.m_observer.notify(event);
                    }
                }
            }
        }

        protected String getId() {
            return this.m_observer.toString();
        }

        protected abstract boolean isApplicable(EventDispatcher var1, String var2);

        protected boolean shouldFire(E event) {
            return true;
        }

        protected String getEventScope(E event) {
            return null;
        }

        protected void addType(T type) {
            this.m_setTypes.add(type);
        }

        protected EnumSet<T> eventTypes() {
            return this.m_setTypes.isEmpty() ? EnumSet.complementOf(this.m_setTypes) : this.m_setTypes;
        }

        public String getScopeName() {
            return this.m_sScopeName;
        }

        protected String removeScope(String sServiceName) {
            int nIndex = sServiceName.indexOf(58);
            return nIndex > -1 ? sServiceName.substring(nIndex + 1) : sServiceName;
        }
    }
}

