/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.callables;

import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.tangosol.coherence.component.net.extend.connection.TcpConnection;
import com.tangosol.coherence.component.util.SafeService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.Member;
import com.tangosol.net.Service;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionAcceptor;
import com.tangosol.util.UUID;
import java.util.Collection;

public class HasExtendConnection
implements RemoteCallable<Boolean> {
    private final String m_sProxyServiceName;
    private final UUID m_uuid;

    public HasExtendConnection(String sProxyServiceName, UUID uuid) {
        this.m_sProxyServiceName = sProxyServiceName;
        this.m_uuid = uuid;
    }

    public Boolean call() throws Exception {
        Cluster cluster = CacheFactory.getCluster();
        Service service = cluster.getService(this.m_sProxyServiceName);
        if (service instanceof SafeService) {
            service = ((SafeService)service).getService();
        }
        if (service instanceof ProxyService) {
            ConnectionAcceptor acceptor = ((ProxyService)service).getAcceptor();
            Collection colConnection = acceptor.getConnections();
            for (Connection connection : colConnection) {
                Member member = ((TcpConnection)connection).getMember();
                if (!member.getUuid().equals((Object)this.m_uuid)) continue;
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("Service " + this.m_sProxyServiceName + " is not a ProxyService");
    }
}

