/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.callables;

import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.tangosol.internal.net.service.grid.ProxyServiceDependencies;
import com.tangosol.internal.net.service.peer.acceptor.GrpcAcceptorDependencies;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.ProxyService;
import com.tangosol.net.grpc.GrpcAcceptorController;

public class FindGrpcProxyPort
implements RemoteCallable<Integer> {
    public static final FindGrpcProxyPort INSTANCE = new FindGrpcProxyPort();
    private final String m_sScope;

    public FindGrpcProxyPort() {
        this("");
    }

    public FindGrpcProxyPort(String sScope) {
        this.m_sScope = sScope;
    }

    public Integer call() {
        return this.findPort(this.m_sScope);
    }

    private int findPort(String sScope) {
        Cluster cluster = CacheFactory.getCluster();
        ProxyService service = (ProxyService)cluster.getService(sScope + "$GRPC:GrpcProxy");
        if (service == null) {
            return -1;
        }
        ProxyServiceDependencies depsService = (ProxyServiceDependencies)service.getDependencies();
        GrpcAcceptorDependencies depsAcceptor = (GrpcAcceptorDependencies)depsService.getAcceptorDependencies();
        GrpcAcceptorController controller = depsAcceptor.getController();
        return controller.getLocalPort();
    }

    public static int local() {
        return FindGrpcProxyPort.local("");
    }

    public static int local(String sScope) {
        return INSTANCE.findPort(sScope);
    }
}

