/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.callables;

import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;

public class IsReady
implements RemoteCallable<Boolean> {
    public static final IsReady INSTANCE = new IsReady();

    public Boolean call() throws Exception {
        try {
            Cluster cluster = CacheFactory.getCluster();
            if (cluster != null && cluster.isRunning()) {
                boolean fReady = cluster.getManagement().allHealthChecksReady();
                if (!fReady) {
                    Logger.info((String)"Bedrock: IsReady check failed");
                }
                return true;
            }
            Logger.info((String)"Bedrock: IsReady check - cluster is null or not running");
            return false;
        }
        catch (Exception e) {
            Logger.err((String)"Bedrock: IsReady check failed", (Throwable)e);
            return false;
        }
    }
}

