/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.coherence.CoherenceCacheServer;
import com.oracle.bedrock.runtime.coherence.ServiceStatus;
import com.oracle.bedrock.runtime.coherence.callables.FindExtendProxyPort;
import com.oracle.bedrock.runtime.coherence.callables.FindGrpcProxyPort;
import com.oracle.bedrock.runtime.coherence.callables.HasSession;
import com.oracle.bedrock.runtime.coherence.callables.HasSessionWithScope;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.concurrent.callable.RemoteCallableStaticMethod;
import com.oracle.bedrock.runtime.java.ContainerBasedJavaApplicationLauncher;
import com.oracle.bedrock.runtime.java.JavaApplication;
import com.oracle.bedrock.runtime.java.container.ContainerClassLoader;
import com.oracle.bedrock.runtime.java.options.ClassName;
import com.oracle.bedrock.runtime.java.options.Headless;
import com.oracle.bedrock.runtime.java.options.IPv4Preferred;
import com.oracle.bedrock.runtime.java.options.JavaModules;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.SystemProperty;
import com.oracle.bedrock.runtime.remote.RemotePlatform;
import com.oracle.bedrock.util.Trilean;
import com.tangosol.net.Coherence;
import com.tangosol.net.NamedCache;
import com.tangosol.net.Session;
import com.tangosol.util.UID;
import com.tangosol.util.UUID;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public interface CoherenceClusterMember
extends JavaApplication {
    public int getClusterSize();

    public int getLocalMemberClusterPort();

    public int getLocalMemberId();

    public UID getLocalMemberUID();

    public UUID getLocalMemberUUID();

    public Set<UID> getClusterMemberUIDs();

    public String getMachineName();

    public String getMemberName();

    public String getRoleName();

    public String getRackName();

    public String getSiteName();

    public String getClusterName();

    public <K, V> NamedCache<K, V> getCache(String var1);

    public <K, V> NamedCache<K, V> getCache(String var1, Class<K> var2, Class<V> var3);

    public <K, V> NamedCache<K, V> getCache(String var1, String var2);

    public <K, V> NamedCache<K, V> getCache(String var1, String var2, Class<K> var3, Class<V> var4);

    public <K, V> NamedCache<K, V> getCache(String var1, String var2, String var3);

    public <K, V> NamedCache<K, V> getCache(String var1, String var2, String var3, Class<K> var4, Class<V> var5);

    public Session getSession();

    public Session getSession(String var1);

    public Session getSession(String var1, String var2);

    public boolean isServiceRunning(String var1);

    default public boolean isServiceRunning(String scopeName, String serviceName) {
        return this.isServiceRunning(scopeName + ":" + serviceName);
    }

    public boolean isCoherenceRunning();

    public boolean isCoherenceRunning(String var1);

    public boolean isSafe();

    public boolean isReady();

    public Trilean isStorageEnabled(String var1);

    default public Trilean isStorageEnabled(String scopeName, String serviceName) {
        return this.isStorageEnabled(scopeName + ":" + serviceName);
    }

    public Set<String> getServiceNames();

    public ServiceStatus getServiceStatus(String var1);

    public int getExtendConnectionCount(String var1);

    public boolean hasExtendConnection(String var1, UUID var2);

    default public ServiceStatus getServiceStatus(String scopeName, String serviceName) {
        return this.getServiceStatus(scopeName + ":" + serviceName);
    }

    public void threadDump();

    default public int getExtendProxyPort() {
        return (Integer)this.invoke(FindExtendProxyPort.INSTANCE, new Option[0]);
    }

    default public int getExtendProxyPort(String sServiceName) {
        return (Integer)this.invoke(new FindExtendProxyPort(sServiceName), new Option[0]);
    }

    default public int getGrpcProxyPort() {
        return (Integer)this.invoke(FindGrpcProxyPort.INSTANCE, new Option[0]);
    }

    default public int getGrpcProxyPort(String sScope) {
        return (Integer)this.invoke(new FindGrpcProxyPort(sScope), new Option[0]);
    }

    default public boolean hasSession(String sName) {
        return (Boolean)this.invoke(new HasSession(sName), new Option[0]);
    }

    default public boolean hasSession(String sSessionName, String sCoherenceName) {
        return (Boolean)this.invoke(new HasSession(sSessionName, sCoherenceName), new Option[0]);
    }

    default public boolean hasSessionWithScope(String sName) {
        return (Boolean)this.invoke(new HasSessionWithScope(sName), new Option[0]);
    }

    default public boolean hasSessionWithScope(String sScopeName, String sCoherenceName) {
        return (Boolean)this.invoke(new HasSessionWithScope(sScopeName, sCoherenceName), new Option[0]);
    }

    public static class StartCoherence
    implements RemoteCallable<Void> {
        public Void call() throws Exception {
            Coherence.clusterMember().start();
            return null;
        }
    }

    public static class GetLocalHostProperty
    implements SystemProperty.ContextSensitiveValue {
        private static GetLocalHostProperty INSTANCE = new GetLocalHostProperty();

        public Object resolve(String name, Platform platform, OptionsByType optionsByType) {
            try {
                if (platform instanceof RemotePlatform) {
                    InetAddress inetAddress = platform.getAddress();
                    if (inetAddress == null) {
                        return null;
                    }
                    return inetAddress.getHostAddress();
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            return null;
        }
    }

    public static class GetMemberProperty
    implements SystemProperty.ContextSensitiveValue {
        private static GetMemberProperty INSTANCE = new GetMemberProperty();

        public Object resolve(String name, Platform platform, OptionsByType optionsByType) {
            try {
                if (platform instanceof RemotePlatform) {
                    return platform.getName();
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            return null;
        }
    }

    public static class MetaClass
    implements com.oracle.bedrock.runtime.MetaClass<CoherenceClusterMember>,
    ContainerBasedJavaApplicationLauncher.ApplicationController {
        public static final String DEFAULT_CACHE_SERVER_CLASSNAME = "com.tangosol.net.DefaultCacheServer";
        public static final String MAIN_CLASSNAME = "com.tangosol.net.Coherence";
        public static final String CACHE_FACTORY_CLASSNAME = "com.tangosol.net.CacheFactory";

        @OptionsByType.Default
        public MetaClass() {
        }

        public Class<? extends CoherenceClusterMember> getImplementationClass(Platform platform, OptionsByType optionsByType) {
            return CoherenceCacheServer.class;
        }

        public void onLaunching(Platform platform, OptionsByType optionsByType) {
            optionsByType.addIfAbsent((Option)ClassName.of((String)MAIN_CLASSNAME));
            optionsByType.addIfAbsent((Option)IPv4Preferred.yes());
            optionsByType.add((Option)Headless.enabled());
            SystemProperties properties = ((SystemProperties)optionsByType.get(SystemProperties.class, new Object[0])).addIfAbsent(SystemProperty.of((String)"coherence.localhost", (SystemProperty.ContextSensitiveValue)GetLocalHostProperty.INSTANCE, (Option[])new Option[0])).addIfAbsent(SystemProperty.of((String)"coherence.machine", (SystemProperty.ContextSensitiveValue)GetMemberProperty.INSTANCE, (Option[])new Option[0]));
            optionsByType.add((Option)properties);
            JavaModules javaModules = (JavaModules)optionsByType.get(JavaModules.class, new Object[0]);
            String sModule = this.getClass().getModule().getName();
            optionsByType.add((Option)javaModules.adding(new String[]{sModule, "com.oracle.coherence"}));
        }

        public void onLaunch(Platform platform, OptionsByType optionsByType) {
        }

        public void onLaunched(Platform platform, CoherenceClusterMember member, OptionsByType optionsByType) {
        }

        public CompletableFuture<Void> start(ContainerBasedJavaApplicationLauncher.ControllableApplication application) {
            StartCoherence callable = new StartCoherence();
            return application.submit((RemoteCallable)callable, new Option[0]);
        }

        public CompletableFuture<Void> destroy(ContainerBasedJavaApplicationLauncher.ControllableApplication application) {
            RemoteCallableStaticMethod callable = new RemoteCallableStaticMethod(MAIN_CLASSNAME, "closeAll", new Object[0]);
            return application.submit((RemoteCallable)callable, new Option[0]);
        }

        public void configure(ContainerClassLoader containerClassLoader, PipedOutputStream pipedOutputStream, PipedInputStream pipedInputStream, OptionsByType optionsByType) {
            ClassName className = (ClassName)optionsByType.getOrSetDefault(ClassName.class, (Option)ClassName.of((String)MAIN_CLASSNAME));
            ContainerBasedJavaApplicationLauncher.configureRemoteChannel((ContainerClassLoader)containerClassLoader, (PipedOutputStream)pipedOutputStream, (PipedInputStream)pipedInputStream, (String)className.getName());
        }
    }
}

