/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.callables;

import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.Service;

public class IsServiceRunning
implements RemoteCallable<Boolean> {
    private final String m_sServiceName;

    public IsServiceRunning(String sServiceName) {
        this.m_sServiceName = sServiceName;
    }

    public Boolean call() {
        try {
            Cluster cluster = CacheFactory.getCluster();
            if (cluster != null && cluster.isRunning()) {
                if ("Cluster".equals(this.m_sServiceName)) {
                    return true;
                }
                Service service = cluster.getService(this.m_sServiceName);
                return service != null && service.isRunning();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }
}

