/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.options;

import com.oracle.bedrock.ComposableOption;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.SystemProperty;

public class Logging
implements Profile,
ComposableOption<Logging> {
    public static final String PROPERTY = "coherence.log";
    public static final String PROPERTY_LEVEL = "coherence.log.level";
    private String destination;
    private Integer level;

    private Logging(String destination, Integer level) {
        this.destination = destination;
        this.level = level;
    }

    public static Logging to(String destination) {
        return new Logging(destination, null);
    }

    public static Logging toStdErr() {
        return new Logging("stderr", null);
    }

    public static Logging toStdOut() {
        return new Logging("stdout", null);
    }

    public static Logging at(int level) {
        return new Logging(null, level);
    }

    public static Logging atError() {
        return new Logging(null, 1);
    }

    public static Logging atWarn() {
        return new Logging(null, 2);
    }

    public static Logging atInfo() {
        return new Logging(null, 3);
    }

    public static Logging atConfig() {
        return new Logging(null, 4);
    }

    public static Logging atFine() {
        return new Logging(null, 5);
    }

    public static Logging atFiner() {
        return new Logging(null, 6);
    }

    public static Logging atFinest() {
        return new Logging(null, 7);
    }

    public static Logging atMax() {
        return new Logging(null, 9);
    }

    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        SystemProperties systemProperties = (SystemProperties)optionsByType.get(SystemProperties.class, new Object[0]);
        if (systemProperties != null && this.destination != null) {
            optionsByType.add((Option)SystemProperty.of((String)PROPERTY, (String)this.destination, (Option[])new Option[0]));
        }
        if (systemProperties != null && this.level != null) {
            optionsByType.add((Option)SystemProperty.of((String)PROPERTY_LEVEL, (Object)this.level, (Option[])new Option[0]));
        }
    }

    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public Logging compose(Logging other) {
        return new Logging(this.destination == null ? other.destination : this.destination, this.level == null ? other.level : this.level);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Logging)) {
            return false;
        }
        Logging logging = (Logging)o;
        if (this.destination != null ? !this.destination.equals(logging.destination) : logging.destination != null) {
            return false;
        }
        return this.level != null ? this.level.equals(logging.level) : logging.level == null;
    }

    public int hashCode() {
        int result = this.destination != null ? this.destination.hashCode() : 0;
        result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Logging(destination='" + this.destination + "', level=" + this.level + ")";
    }
}

