/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.callables;

import com.oracle.bedrock.runtime.coherence.ServiceStatus;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.Service;

public class GetServiceStatus
implements RemoteCallable<ServiceStatus> {
    private final String serviceName;

    public GetServiceStatus(String serviceName) {
        this.serviceName = serviceName;
    }

    public ServiceStatus call() throws Exception {
        Service service;
        Cluster cluster = CacheFactory.getCluster();
        Service service2 = service = cluster == null ? null : cluster.getService(this.serviceName);
        if (service == null) {
            return null;
        }
        if (service.isRunning()) {
            if (service instanceof PartitionedService) {
                PartitionedService partitionedService = (PartitionedService)service;
                try {
                    int backupStrength = partitionedService.getBackupStrength();
                    switch (backupStrength) {
                        case 0: {
                            return ServiceStatus.ORPHANED;
                        }
                        case 1: {
                            return ServiceStatus.ENDANGERED;
                        }
                        case 2: {
                            return ServiceStatus.NODE_SAFE;
                        }
                        case 3: {
                            return ServiceStatus.MACHINE_SAFE;
                        }
                        case 4: {
                            return ServiceStatus.RACK_SAFE;
                        }
                        case 5: {
                            return ServiceStatus.SITE_SAFE;
                        }
                    }
                    return ServiceStatus.UNKNOWN;
                }
                catch (Exception e) {
                    return ServiceStatus.UNKNOWN;
                }
            }
            return ServiceStatus.RUNNING;
        }
        return ServiceStatus.STOPPED;
    }
}

