/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.junit;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.junit.SessionBuilder;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.coherence.CoherenceCluster;
import com.oracle.bedrock.runtime.coherence.CoherenceClusterBuilder;
import com.oracle.bedrock.runtime.coherence.CoherenceClusterMember;
import com.oracle.bedrock.runtime.coherence.options.ClusterName;
import com.oracle.bedrock.runtime.coherence.options.LocalStorage;
import com.oracle.bedrock.runtime.coherence.options.RoleName;
import com.oracle.bedrock.runtime.java.options.Headless;
import com.oracle.bedrock.runtime.options.Console;
import com.oracle.bedrock.testsupport.junit.AbstractAssemblyResource;
import com.oracle.bedrock.util.SystemProperties;
import com.oracle.coherence.common.collections.ConcurrentHashMap;
import com.tangosol.internal.net.ConfigurableCacheFactorySession;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.Session;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class CoherenceClusterResource
extends AbstractAssemblyResource<CoherenceClusterMember, CoherenceCluster, CoherenceClusterResource> {
    private Properties m_systemProperties;
    private final Map<SessionBuilder, ConfigurableCacheFactory> f_mapCCF = new HashMap<SessionBuilder, ConfigurableCacheFactory>();
    private final Map<SessionBuilder, Session> f_mapSession = new ConcurrentHashMap();

    public CoherenceClusterResource() {
        this.commonOptionsByType.add((Option)Headless.enabled());
        this.commonOptionsByType.add((Option)Console.system());
    }

    protected CoherenceClusterBuilder createBuilder() {
        return new CoherenceClusterBuilder();
    }

    public CoherenceCluster getCluster() {
        return (CoherenceCluster)this.assembly;
    }

    public void before() throws Throwable {
        if (this.launchDefinitions.isEmpty()) {
            throw new IllegalStateException("CoherenceClusterResource fails to define members to include when launching");
        }
        this.m_systemProperties = SystemProperties.createSnapshot();
        CacheFactory.setCacheFactoryBuilder(null);
        CacheFactory.shutdown();
        super.before();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after() {
        Map<SessionBuilder, ConfigurableCacheFactory> map = this.f_mapCCF;
        synchronized (map) {
            for (ConfigurableCacheFactory session : this.f_mapCCF.values()) {
                CacheFactory.getCacheFactoryBuilder().release(session);
            }
        }
        CacheFactory.setCacheFactoryBuilder(null);
        CacheFactory.shutdown();
        super.after();
        SystemProperties.replaceWith((Properties)this.m_systemProperties);
    }

    public Statement apply(Statement base, Description description) {
        this.commonOptionsByType.addIfAbsent((Option)ClusterName.of((String)description.getClassName()));
        return super.apply(base, description);
    }

    public CoherenceClusterResource include(int count, Option ... options) {
        return (CoherenceClusterResource)this.include(count, CoherenceClusterMember.class, options);
    }

    public synchronized ConfigurableCacheFactory createSession(SessionBuilder builder) {
        return this.f_mapCCF.compute(builder, (k, ccf) -> {
            if (ccf != null && !ccf.isDisposed()) {
                return ccf;
            }
            SystemProperties.replaceWith((Properties)this.m_systemProperties);
            OptionsByType optionsByType = OptionsByType.of((OptionsByType)this.commonOptionsByType);
            optionsByType.add((Option)RoleName.of((String)"client"));
            optionsByType.add((Option)LocalStorage.disabled());
            return builder.build(LocalPlatform.get(), this.getCluster(), optionsByType);
        });
    }

    public synchronized Session buildSession(SessionBuilder builder) {
        return this.f_mapSession.compute(builder, (k, session) -> {
            if (session != null && session.isActive()) {
                return session;
            }
            ConfigurableCacheFactory ccf = this.createSession(builder);
            return new ClosingConfigurableCacheFactorySession(ccf, builder.getClass().getClassLoader());
        });
    }

    public Option[] getCommonOptions() {
        return this.commonOptionsByType.asArray();
    }

    protected static class ClosingConfigurableCacheFactorySession
    extends ConfigurableCacheFactorySession {
        public ClosingConfigurableCacheFactorySession(ConfigurableCacheFactory ccf, ClassLoader loader) {
            super(ccf, loader);
        }

        public synchronized void close() throws Exception {
            if (this.isClosed()) {
                return;
            }
            super.close();
            ConfigurableCacheFactory ccf = this.getConfigurableCacheFactory();
            if (!ccf.isDisposed()) {
                ccf.dispose();
            }
        }
    }
}

