/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.junit;

import java.util.concurrent.TimeUnit;

public class SleepingApplication {
    public static void main(String[] arguments) throws InterruptedException {
        System.out.printf("%s started\n", SleepingApplication.class.getName());
        System.out.printf("Using java.home: %s\n", System.getProperty("java.home"));
        int secondsToSleep = 30;
        if (arguments.length == 1) {
            try {
                secondsToSleep = Integer.parseInt(arguments[0]);
            }
            catch (NumberFormatException e) {
                System.out.println("Argument [" + arguments[0] + "] is not a number representing seconds, defaulting to 5 seconds");
                secondsToSleep = 5;
            }
        }
        System.out.println("Now sleeping for " + secondsToSleep + " seconds");
        Thread.sleep(TimeUnit.SECONDS.toMillis(secondsToSleep));
        System.out.println("Finished sleeping... now terminating");
    }
}

