/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.junit;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;
import junit.framework.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

public class TestClassPredicate
implements Predicate<Class<?>>,
Serializable {
    @Override
    public boolean test(Class<?> testClass) {
        if (testClass == null || testClass.isAnnotation() || testClass.isAnonymousClass() || testClass.isEnum() || testClass.isInterface()) {
            return false;
        }
        return this.isJUnit3(testClass) || this.isJUnit4(testClass) || this.isJUnit48(testClass);
    }

    public boolean isJUnit3(Class<?> testClass) {
        return !this.isAbstract(testClass) && (Test.class.isAssignableFrom(testClass) || this.hasSuiteMethod(testClass));
    }

    protected boolean isJUnit4(Class<?> testClass) {
        return !this.isAbstract(testClass) && (this.isAnnotatedWithRunWith(testClass) || this.hasMethodsAnnotatedWithTest(testClass));
    }

    protected boolean isJUnit48(Class<?> testClass) {
        return this.isAbstract(testClass) && this.usesRunWithEnclosed(testClass);
    }

    private boolean isAbstract(Class<?> testClass) {
        return Modifier.isAbstract(testClass.getModifiers());
    }

    protected boolean hasSuiteMethod(Class<?> testClass) {
        try {
            Method suiteMethod = testClass.getDeclaredMethod("suite", new Class[0]);
            if (suiteMethod != null) {
                int modifiers = suiteMethod.getModifiers();
                Class<?> returnType = suiteMethod.getReturnType();
                return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Test.class.isAssignableFrom(returnType);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    protected boolean isAnnotatedWithRunWith(Class<?> testClass) {
        RunWith runWith = testClass.getAnnotation(RunWith.class);
        return runWith != null;
    }

    protected boolean hasMethodsAnnotatedWithTest(Class<?> testClass) {
        for (Method method : testClass.getDeclaredMethods()) {
            for (Annotation annotation : method.getAnnotations()) {
                if (!org.junit.Test.class.isAssignableFrom(annotation.annotationType())) continue;
                return true;
            }
        }
        Class<?> parent = testClass.getSuperclass();
        if (Object.class.equals(parent)) {
            return false;
        }
        return this.hasMethodsAnnotatedWithTest(parent);
    }

    protected boolean usesRunWithEnclosed(Class<?> testClass) {
        RunWith runWith = testClass.getAnnotation(RunWith.class);
        if (runWith == null) {
            return false;
        }
        Class runnerClass = runWith.value();
        return runnerClass != null && Enclosed.class.isAssignableFrom(runnerClass);
    }
}

