/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.options.Discriminator;
import java.util.UUID;

public class DisplayName
implements Option {
    private String name;

    private DisplayName(String name) {
        this.name = name == null ? UUID.randomUUID().toString() : name;
    }

    public String resolve(OptionsByType optionsByType) {
        if (optionsByType == null) {
            return this.name;
        }
        Discriminator discriminator = (Discriminator)optionsByType.get(Discriminator.class, new Object[0]);
        return discriminator == null ? this.name : this.name + "-" + discriminator.getValue();
    }

    public static DisplayName of(String name) {
        return new DisplayName(name);
    }

    @OptionsByType.Default
    public static DisplayName autoGenerate() {
        return new DisplayName(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DisplayName)) {
            return false;
        }
        DisplayName displayName = (DisplayName)o;
        return this.name.equals(displayName.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

