/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.profiles;

import com.oracle.bedrock.ComposableOption;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.SystemProperty;
import com.oracle.bedrock.util.Capture;
import java.util.Optional;

public class JmxProfile
implements Profile,
ComposableOption<JmxProfile> {
    private Optional<String> hostName;
    private Optional<Capture<Integer>> port;
    private Optional<Boolean> authenticate;
    private Optional<Boolean> ssl;

    private JmxProfile() {
        this.hostName = Optional.empty();
        this.port = Optional.empty();
        this.authenticate = Optional.empty();
        this.ssl = Optional.empty();
    }

    private JmxProfile(JmxProfile other) {
        this.hostName = other.hostName;
        this.port = other.port;
        this.authenticate = other.authenticate;
        this.ssl = other.ssl;
    }

    @Override
    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        SystemProperties systemProperties = (SystemProperties)optionsByType.get(SystemProperties.class, new Object[0]);
        systemProperties = systemProperties.addIfAbsent(SystemProperty.of("com.sun.management.jmxremote", new Option[0]));
        systemProperties = this.hostName.isPresent() ? systemProperties.addIfAbsent(SystemProperty.of("java.rmi.server.hostname", this.hostName.get(), new Option[0])) : systemProperties.addIfAbsent(SystemProperty.of("java.rmi.server.hostname", platform.getAddress().getHostAddress(), new Option[0]));
        systemProperties = systemProperties.addIfAbsent(SystemProperty.of("java.rmi.server.useCodebaseOnly", "true", new Option[0]));
        if (this.port.isPresent()) {
            systemProperties.addIfAbsent(SystemProperty.of("com.sun.management.jmxremote.port", this.port.get().get(), new Option[0]));
        } else {
            systemProperties = systemProperties.addIfAbsent(SystemProperty.of("com.sun.management.jmxremote.port", LocalPlatform.get().getAvailablePorts(), new Option[0]));
        }
        if (this.authenticate.isPresent()) {
            systemProperties = systemProperties.addIfAbsent(SystemProperty.of("com.sun.management.jmxremote.authenticate", this.authenticate.get(), new Option[0]));
        }
        if (this.ssl.isPresent()) {
            systemProperties = systemProperties.addIfAbsent(SystemProperty.of("com.sun.management.jmxremote.ssl", this.ssl.get(), new Option[0]));
        }
        optionsByType.add((Option)systemProperties);
    }

    @Override
    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    @Override
    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
    }

    private <T> Optional<T> oneOf(Optional<T> first, Optional<T> second) {
        if (first != null && first.isPresent() && (second == null || !second.isPresent())) {
            return first;
        }
        if ((first == null || !first.isPresent()) && second != null && second.isPresent()) {
            return second;
        }
        if (first != null && first.isPresent() && second != null && second.isPresent()) {
            return first;
        }
        return Optional.empty();
    }

    public JmxProfile compose(JmxProfile other) {
        JmxProfile composed = new JmxProfile();
        composed.hostName = this.oneOf(other.hostName, this.hostName);
        composed.port = this.oneOf(other.port, this.port);
        composed.authenticate = this.oneOf(other.authenticate, this.authenticate);
        composed.ssl = this.oneOf(other.ssl, this.ssl);
        return composed;
    }

    public static JmxProfile enabled() {
        JmxProfile jmxProfile = new JmxProfile();
        jmxProfile.authenticate = Optional.of(false);
        jmxProfile.ssl = Optional.of(false);
        return jmxProfile;
    }

    public static JmxProfile authentication(boolean enabled) {
        JmxProfile jmxProfile = new JmxProfile();
        jmxProfile.authenticate = Optional.of(enabled);
        return jmxProfile;
    }

    public static JmxProfile ssl(boolean enabled) {
        JmxProfile jmxProfile = new JmxProfile();
        jmxProfile.ssl = Optional.of(enabled);
        return jmxProfile;
    }

    public static JmxProfile hostname(String hostname) {
        JmxProfile jmxProfile = new JmxProfile();
        jmxProfile.hostName = Optional.of(hostname);
        return jmxProfile;
    }
}

