/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.options;

import com.oracle.bedrock.ComposableOption;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.concurrent.RemoteEventListener;
import com.oracle.bedrock.runtime.concurrent.options.StreamName;
import java.util.HashMap;
import java.util.function.BiConsumer;

public class RemoteEvents
implements ComposableOption<RemoteEvents> {
    private HashMap<StreamName, HashMap<RemoteEventListener, OptionsByType>> eventListeners = new HashMap();

    private RemoteEvents() {
    }

    private void add(RemoteEventListener listener, OptionsByType optionsByType) {
        StreamName streamName = (StreamName)optionsByType.get(StreamName.class, new Object[0]);
        HashMap streamEventListeners = this.eventListeners.computeIfAbsent(streamName, name -> new HashMap());
        streamEventListeners.put(listener, optionsByType);
    }

    public void forEach(BiConsumer<RemoteEventListener, Option[]> consumer) {
        this.eventListeners.forEach((? super K streamName, ? super V remoteEventListenerMap) -> remoteEventListenerMap.forEach((? super K remoteEventListener, ? super V optionsByType) -> consumer.accept((RemoteEventListener)remoteEventListener, optionsByType.asArray())));
    }

    public RemoteEvents compose(RemoteEvents other) {
        RemoteEvents remoteEvents = new RemoteEvents();
        remoteEvents.eventListeners.putAll(this.eventListeners);
        other.eventListeners.forEach((? super K streamName, ? super V remoteEventListenerMap) -> remoteEventListenerMap.forEach((? super K remoteEventListener, ? super V optionsByType) -> remoteEvents.add((RemoteEventListener)remoteEventListener, (OptionsByType)optionsByType)));
        return remoteEvents;
    }

    public static RemoteEvents listener(RemoteEventListener remoteEventListener, Option ... options) {
        RemoteEvents remoteEvents = new RemoteEvents();
        remoteEvents.add(remoteEventListener, OptionsByType.of((Option[])options));
        return remoteEvents;
    }

    @OptionsByType.Default
    public static RemoteEvents none() {
        return new RemoteEvents();
    }
}

