/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.container;

import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.runtime.java.container.Container;
import com.oracle.bedrock.runtime.java.container.ContainerMBeanServerBuilder;
import com.oracle.bedrock.runtime.java.container.ContainerScope;
import java.io.ObjectInputStream;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

@Internal
public class DelegatingMBeanServer
implements MBeanServer {
    private String domain;

    public DelegatingMBeanServer(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    private MBeanServer getDelegate() {
        ContainerScope scope = Container.getContainerScope();
        ContainerMBeanServerBuilder builder = scope == null ? Container.getDefaultScope().getMBeanServerBuilder() : scope.getMBeanServerBuilder();
        MBeanServer mBeanServer = builder.getMBeanServer(this.domain);
        if (mBeanServer == null) {
            mBeanServer = builder.newMBeanServer(this.domain, null, builder.newMBeanServerDelegate());
        }
        return mBeanServer;
    }

    @Override
    public void addNotificationListener(ObjectName paramObjectName, NotificationListener paramNotificationListener, NotificationFilter paramNotificationFilter, Object paramObject) throws InstanceNotFoundException {
        this.getDelegate().addNotificationListener(paramObjectName, paramNotificationListener, paramNotificationFilter, paramObject);
    }

    @Override
    public void addNotificationListener(ObjectName paramObjectName1, ObjectName paramObjectName2, NotificationFilter paramNotificationFilter, Object paramObject) throws InstanceNotFoundException {
        this.getDelegate().addNotificationListener(paramObjectName1, paramObjectName2, paramNotificationFilter, paramObject);
    }

    @Override
    public ObjectInstance createMBean(String paramString, ObjectName paramObjectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.getDelegate().createMBean(paramString, paramObjectName);
    }

    @Override
    public ObjectInstance createMBean(String paramString, ObjectName paramObjectName, Object[] paramArrayOfObject, String[] paramArrayOfString) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.getDelegate().createMBean(paramString, paramObjectName, paramArrayOfObject, paramArrayOfString);
    }

    @Override
    public ObjectInstance createMBean(String paramString, ObjectName paramObjectName1, ObjectName paramObjectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.getDelegate().createMBean(paramString, paramObjectName1, paramObjectName2);
    }

    @Override
    public ObjectInstance createMBean(String paramString, ObjectName paramObjectName1, ObjectName paramObjectName2, Object[] paramArrayOfObject, String[] paramArrayOfString) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.getDelegate().createMBean(paramString, paramObjectName1, paramObjectName2, paramArrayOfObject, paramArrayOfString);
    }

    @Override
    public ObjectInputStream deserialize(ObjectName paramObjectName, byte[] paramArrayOfByte) throws InstanceNotFoundException, OperationsException {
        return this.getDelegate().deserialize(paramObjectName, paramArrayOfByte);
    }

    @Override
    public ObjectInputStream deserialize(String paramString, byte[] paramArrayOfByte) throws OperationsException, ReflectionException {
        return this.getDelegate().deserialize(paramString, paramArrayOfByte);
    }

    @Override
    public ObjectInputStream deserialize(String paramString, ObjectName paramObjectName, byte[] paramArrayOfByte) throws InstanceNotFoundException, OperationsException, ReflectionException {
        return this.getDelegate().deserialize(paramString, paramObjectName, paramArrayOfByte);
    }

    @Override
    public Object getAttribute(ObjectName paramObjectName, String paramString) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.getDelegate().getAttribute(paramObjectName, paramString);
    }

    @Override
    public AttributeList getAttributes(ObjectName paramObjectName, String[] paramArrayOfString) throws InstanceNotFoundException, ReflectionException {
        return this.getDelegate().getAttributes(paramObjectName, paramArrayOfString);
    }

    @Override
    public ClassLoader getClassLoader(ObjectName paramObjectName) throws InstanceNotFoundException {
        return this.getDelegate().getClassLoader(paramObjectName);
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName paramObjectName) throws InstanceNotFoundException {
        return this.getDelegate().getClassLoaderFor(paramObjectName);
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        return this.getDelegate().getClassLoaderRepository();
    }

    @Override
    public String getDefaultDomain() {
        return this.getDelegate().getDefaultDomain();
    }

    @Override
    public String[] getDomains() {
        return this.getDelegate().getDomains();
    }

    @Override
    public Integer getMBeanCount() {
        return this.getDelegate().getMBeanCount();
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName paramObjectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.getDelegate().getMBeanInfo(paramObjectName);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName paramObjectName) throws InstanceNotFoundException {
        return this.getDelegate().getObjectInstance(paramObjectName);
    }

    @Override
    public Object instantiate(String paramString) throws ReflectionException, MBeanException {
        return this.getDelegate().instantiate(paramString);
    }

    @Override
    public Object instantiate(String paramString, Object[] paramArrayOfObject, String[] paramArrayOfString) throws ReflectionException, MBeanException {
        return this.getDelegate().instantiate(paramString, paramArrayOfObject, paramArrayOfString);
    }

    @Override
    public Object instantiate(String paramString, ObjectName paramObjectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.getDelegate().instantiate(paramString, paramObjectName);
    }

    @Override
    public Object instantiate(String paramString, ObjectName paramObjectName, Object[] paramArrayOfObject, String[] paramArrayOfString) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.getDelegate().instantiate(paramString, paramObjectName, paramArrayOfObject, paramArrayOfString);
    }

    @Override
    public Object invoke(ObjectName paramObjectName, String paramString, Object[] paramArrayOfObject, String[] paramArrayOfString) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.getDelegate().invoke(paramObjectName, paramString, paramArrayOfObject, paramArrayOfString);
    }

    @Override
    public boolean isInstanceOf(ObjectName paramObjectName, String paramString) throws InstanceNotFoundException {
        return this.getDelegate().isInstanceOf(paramObjectName, paramString);
    }

    @Override
    public boolean isRegistered(ObjectName paramObjectName) {
        return this.getDelegate().isRegistered(paramObjectName);
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName paramObjectName, QueryExp paramQueryExp) {
        return this.getDelegate().queryMBeans(paramObjectName, paramQueryExp);
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName paramObjectName, QueryExp paramQueryExp) {
        return this.getDelegate().queryNames(paramObjectName, paramQueryExp);
    }

    @Override
    public ObjectInstance registerMBean(Object paramObject, ObjectName paramObjectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.getDelegate().registerMBean(paramObject, paramObjectName);
    }

    @Override
    public void removeNotificationListener(ObjectName paramObjectName, NotificationListener paramNotificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.getDelegate().removeNotificationListener(paramObjectName, paramNotificationListener);
    }

    @Override
    public void removeNotificationListener(ObjectName paramObjectName, NotificationListener paramNotificationListener, NotificationFilter paramNotificationFilter, Object paramObject) throws InstanceNotFoundException, ListenerNotFoundException {
        this.getDelegate().removeNotificationListener(paramObjectName, paramNotificationListener, paramNotificationFilter, paramObject);
    }

    @Override
    public void removeNotificationListener(ObjectName paramObjectName1, ObjectName paramObjectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        this.getDelegate().removeNotificationListener(paramObjectName1, paramObjectName2);
    }

    @Override
    public void removeNotificationListener(ObjectName paramObjectName1, ObjectName paramObjectName2, NotificationFilter paramNotificationFilter, Object paramObject) throws InstanceNotFoundException, ListenerNotFoundException {
        this.getDelegate().removeNotificationListener(paramObjectName1, paramObjectName2, paramNotificationFilter, paramObject);
    }

    @Override
    public void setAttribute(ObjectName paramObjectName, Attribute paramAttribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.getDelegate().setAttribute(paramObjectName, paramAttribute);
    }

    @Override
    public AttributeList setAttributes(ObjectName paramObjectName, AttributeList paramAttributeList) throws InstanceNotFoundException, ReflectionException {
        return this.getDelegate().setAttributes(paramObjectName, paramAttributeList);
    }

    @Override
    public void unregisterMBean(ObjectName paramObjectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.getDelegate().unregisterMBean(paramObjectName);
    }
}

