/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.io.NetworkHelper;
import com.oracle.bedrock.runtime.AbstractPlatform;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationLauncher;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.OperatingSystem;
import com.oracle.bedrock.runtime.java.ContainerBasedJavaApplicationLauncher;
import com.oracle.bedrock.runtime.java.JavaApplication;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class JavaVirtualMachine
extends AbstractPlatform {
    private static JavaVirtualMachine INSTANCE = new JavaVirtualMachine();
    private boolean isAutoDebugEnabled = true;
    private InetAddress address;

    private JavaVirtualMachine() {
        super("Java Virtual Machine", new Option[0]);
        String addressSystemProperty = System.getProperty("bedrock.runtime.address");
        if (addressSystemProperty == null) {
            this.address = NetworkHelper.getFeasibleLocalHost();
        } else {
            try {
                this.address = InetAddress.getByName(addressSystemProperty);
            }
            catch (UnknownHostException e) {
                this.address = NetworkHelper.getFeasibleLocalHost();
            }
        }
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return LocalPlatform.get().getOperatingSystem();
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    public boolean isRunningWithDebugger() {
        try {
            return this.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
        }
        catch (Throwable t) {
            System.err.println("Error trying to determine debug status - " + t.getMessage());
            return false;
        }
    }

    public RuntimeMXBean getRuntimeMXBean() {
        return ManagementFactory.getRuntimeMXBean();
    }

    public void setAutoDebugEnabled(boolean enabled) {
        this.isAutoDebugEnabled = enabled;
    }

    public boolean getAutoDebugEnabled() {
        return this.isAutoDebugEnabled;
    }

    public boolean shouldEnableRemoteDebugging() {
        return this.getAutoDebugEnabled() && this.isRunningWithDebugger();
    }

    public static JavaVirtualMachine get() {
        return INSTANCE;
    }

    @Override
    protected <A extends Application, B extends ApplicationLauncher<A>> B getApplicationLauncher(MetaClass<A> metaClass, OptionsByType optionsByType) throws UnsupportedOperationException {
        Class<A> applicationClass = metaClass.getImplementationClass(this, optionsByType);
        if (JavaApplication.class.isAssignableFrom(applicationClass)) {
            return (B)new ContainerBasedJavaApplicationLauncher();
        }
        throw new UnsupportedOperationException("The JavaVirtualMachine Platform only supports launching JavaApplications.  The provided " + String.valueOf(applicationClass) + " does not appear to be a JavaApplication");
    }
}

