/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.console;

import com.oracle.bedrock.runtime.ApplicationConsole;
import com.oracle.bedrock.runtime.ApplicationConsoleBuilder;
import com.oracle.bedrock.runtime.java.io.NullReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;

public class FileWriterApplicationConsole
implements ApplicationConsole {
    private FileWriter m_fileWriter;
    private PrintWriter m_outputWriter;
    private PrintWriter m_errorWriter;
    private Reader m_inputReader;
    private boolean m_diagnosticMode;

    public FileWriterApplicationConsole(FileWriter fileWriter) {
        this(fileWriter, true);
    }

    public FileWriterApplicationConsole(String fileName) throws IOException {
        this(new FileWriter(fileName, true), true);
    }

    public FileWriterApplicationConsole(FileWriter fileWriter, boolean diagnosticMode) {
        this.m_diagnosticMode = diagnosticMode;
        this.m_fileWriter = fileWriter;
        this.m_outputWriter = new PrintWriter(fileWriter);
        this.m_errorWriter = new PrintWriter(fileWriter);
        this.m_inputReader = new NullReader();
    }

    @Override
    public void close() {
        try {
            this.m_inputReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.m_fileWriter.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.m_fileWriter = null;
            this.m_outputWriter = null;
            this.m_errorWriter = null;
            this.m_inputReader = null;
        }
    }

    @Override
    public PrintWriter getOutputWriter() {
        return this.m_outputWriter;
    }

    @Override
    public PrintWriter getErrorWriter() {
        return this.m_errorWriter;
    }

    @Override
    public Reader getInputReader() {
        return this.m_inputReader;
    }

    @Override
    public boolean isDiagnosticsEnabled() {
        return this.m_diagnosticMode;
    }

    public static ApplicationConsoleBuilder builder(String directory) {
        return FileWriterApplicationConsole.builder(directory, null, null);
    }

    public static ApplicationConsoleBuilder builder(String directory, String prefix) {
        return FileWriterApplicationConsole.builder(directory, prefix, null);
    }

    public static ApplicationConsoleBuilder builder(final String directory, final String prefix, final String suffix) {
        return new ApplicationConsoleBuilder(){

            @Override
            public ApplicationConsole build(String applicationName) {
                File file;
                Object normalizedDirectory = directory.trim();
                if (!((String)normalizedDirectory).endsWith(File.separator)) {
                    normalizedDirectory = (String)normalizedDirectory + File.separator;
                }
                if ((file = new File((String)normalizedDirectory)).exists()) {
                    String normalizedSuffix;
                    Object normalizedPrefix = prefix == null ? "" : prefix.trim();
                    String string = normalizedSuffix = suffix == null ? "" : suffix.trim();
                    if (((String)normalizedPrefix).length() > 0 && !((String)normalizedPrefix).endsWith("-")) {
                        normalizedPrefix = (String)normalizedPrefix + "-";
                    }
                    String normalizedApplicationName = applicationName.trim();
                    String fileName = (String)normalizedDirectory + (String)normalizedPrefix + normalizedApplicationName + normalizedSuffix;
                    try {
                        return new FileWriterApplicationConsole(fileName);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to create file:" + fileName, e);
                    }
                }
                throw new RuntimeException("The specified directory [" + directory + "] does not exist");
            }
        };
    }
}

